/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.relative;

import com.intellij.android.designer.AndroidDesignerUtils;
import com.intellij.android.designer.designSurface.AbstractEditOperation;
import com.intellij.android.designer.designSurface.feedbacks.TextFeedback;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.relative.ConstraintType;
import com.intellij.android.designer.model.layout.relative.DependencyGraph;
import com.intellij.android.designer.model.layout.relative.GuidelinePainter;
import com.intellij.android.designer.model.layout.relative.Match;
import com.intellij.android.designer.model.layout.relative.MoveHandler;
import com.intellij.android.designer.model.layout.relative.MultiLineTooltipManager;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RelativeLayoutDropOperation
extends AbstractEditOperation {
    private GuidelinePainter myFeedback;
    private MoveHandler myMoveHandler;
    private RadViewComponent myPrimary;
    private MultiLineTooltipManager myTooltip;

    public RelativeLayoutDropOperation(RadComponent container, OperationContext context) {
        super(container, context);
    }

    @Override
    public void showFeedback() {
        Point location;
        FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
        List<RadViewComponent> viewComponents = RadViewComponent.getViewComponents(this.myComponents);
        if (this.myFeedback == null) {
            this.myMoveHandler = new MoveHandler((RadViewComponent)this.myContainer, viewComponents, this.myContext);
            this.myFeedback = new GuidelinePainter(this.myMoveHandler);
            layer.add(this.myFeedback);
            this.myFeedback.setBounds(0, 0, layer.getWidth(), layer.getHeight());
            this.myTooltip = new MultiLineTooltipManager(layer, 4);
            this.myPrimary = viewComponents.get(0);
            Point location2 = this.myContext.getLocation();
            RadComponent pointedTo = this.myContext.getArea().findTarget(location2.x, location2.y, null);
            if (pointedTo instanceof RadViewComponent && this.myComponents.contains((Object)pointedTo)) {
                this.myPrimary = (RadViewComponent)pointedTo;
            }
        }
        Point moveDelta = this.myContext.getMoveDelta();
        Rectangle newBounds = this.myPrimary.getBounds(layer);
        if (newBounds.width == 0 || newBounds.height == 0) {
            Dimension size = AndroidDesignerUtils.computePreferredSize(this.myContext.getArea(), this.myPrimary, this.myContainer);
            newBounds = new Rectangle(0, 0, size.width, size.height);
        }
        if (moveDelta != null) {
            newBounds.x += moveDelta.x;
            newBounds.y += moveDelta.y;
        } else {
            location = this.myContext.getLocation();
            newBounds.x = location.x - newBounds.width / 2;
            newBounds.y = location.y - newBounds.height / 2;
        }
        this.myMoveHandler.updateMove(this.myPrimary, newBounds, this.myContext.getModifiers());
        this.myFeedback.repaint();
        this.describeMatch(this.myMoveHandler.getCurrentLeftMatch(), 0, this.myMoveHandler.getLeftMarginDp(), "layout_marginLeft");
        this.describeMatch(this.myMoveHandler.getCurrentRightMatch(), 1, this.myMoveHandler.getRightMarginDp(), "layout_marginRight");
        this.describeMatch(this.myMoveHandler.getCurrentTopMatch(), 2, this.myMoveHandler.getTopMarginDp(), "layout_marginTop");
        this.describeMatch(this.myMoveHandler.getCurrentBottomMatch(), 3, this.myMoveHandler.getBottomMarginDp(), "layout_marginBottom");
        location = this.myContext.getLocation();
        this.myTooltip.update((RadViewComponent)this.myContainer, location);
    }

    private void describeMatch(Match m, int line, int margin, String marginAttribute) {
        if (m == null) {
            this.myTooltip.setVisible(line, false);
            return;
        }
        this.myTooltip.setVisible(line, true);
        TextFeedback feedback = this.myTooltip.getFeedback(line);
        m.describe(feedback, margin, marginAttribute);
    }

    @Override
    public void eraseFeedback() {
        if (this.myFeedback != null) {
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            layer.remove(this.myFeedback);
            this.myTooltip.dispose();
            this.myFeedback = null;
            this.myTooltip = null;
            layer.repaint();
        }
    }

    @Override
    public void execute() throws Exception {
        if (this.myContext.isCreate() || this.myContext.isPaste() || this.myContext.isAdd()) {
            super.execute();
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                RelativeLayoutDropOperation.this.myMoveHandler.removeCycles();
                RadViewComponent previous = null;
                for (RadViewComponent component : RadViewComponent.getViewComponents(RelativeLayoutDropOperation.this.myComponents)) {
                    if (previous == null) {
                        RelativeLayoutDropOperation.this.myMoveHandler.applyConstraints(component);
                    } else {
                        RelativeLayoutDropOperation.this.myMoveHandler.attachPrevious(previous, component);
                    }
                    previous = component;
                }
            }
        });
    }

    @NotNull
    public static List<RadComponent> getValidTargets(String attributeName, RadViewComponent layout, List<RadViewComponent> sources) {
        ArrayList<RadComponent> result = new ArrayList<RadComponent>();
        ConstraintType constraintType = ConstraintType.fromAttribute(attributeName);
        assert (constraintType != null) : attributeName;
        DependencyGraph graph = DependencyGraph.get(layout);
        Set horizontalDependencies = constraintType.horizontalEdge ? graph.dependsOn(sources, false) : Collections.emptySet();
        Set verticalDependencies = constraintType.verticalEdge ? graph.dependsOn(sources, true) : Collections.emptySet();
        for (RadViewComponent component : RadViewComponent.getViewComponents(layout.getChildren())) {
            if (sources.contains((Object)component) || horizontalDependencies.contains((Object)component) || verticalDependencies.contains((Object)component)) continue;
            result.add(component);
        }
        ArrayList<RadComponent> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/relative/RelativeLayoutDropOperation", "getValidTargets"));
        }
        return arrayList;
    }
}

