/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.relative;

import com.android.tools.idea.designer.MarginType;
import com.android.tools.idea.designer.Segment;
import com.android.tools.idea.designer.SegmentType;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.relative.DependencyGraph;
import com.intellij.android.designer.model.layout.relative.GuidelineHandler;
import com.intellij.android.designer.model.layout.relative.Match;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.OperationContext;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MoveHandler
extends GuidelineHandler {
    private int myDraggedBaseline;

    public MoveHandler(@NotNull RadViewComponent layout, @NotNull List<RadViewComponent> elements, @NotNull OperationContext context) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/model/layout/relative/MoveHandler", "<init>"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/android/designer/model/layout/relative/MoveHandler", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/android/designer/model/layout/relative/MoveHandler", "<init>"));
        }
        super(layout, context);
        ArrayList<RadViewComponent> nodes = new ArrayList<RadViewComponent>();
        for (RadViewComponent element : elements) {
            DependencyGraph.ViewData view = this.myDependencyGraph.getView(element);
            if (view == null) continue;
            nodes.add(view.node);
        }
        this.myDraggedNodes = nodes;
        this.myHorizontalDeps = this.myDependencyGraph.dependsOn(nodes, false);
        this.myVerticalDeps = this.myDependencyGraph.dependsOn(nodes, true);
        for (RadViewComponent child : RadViewComponent.getViewComponents(layout.getChildren())) {
            boolean isDragged;
            FeedbackLayer target;
            Rectangle bc = child.getBounds(target = this.myContext.getArea().getFeedbackLayer());
            if (bc.isEmpty() || (isDragged = this.myDraggedNodes.contains((Object)child))) continue;
            String id = child.getId();
            boolean addHorizontal = !this.myHorizontalDeps.contains((Object)child);
            boolean addVertical = !this.myVerticalDeps.contains((Object)child);
            this.addBounds(child, id, addHorizontal, addVertical, false);
            if (!addHorizontal) continue;
            this.addBaseLine(child, id);
        }
        String id = layout.getId();
        this.addBounds(layout, id, true, true, true);
        this.addCenter(layout, id);
    }

    @Override
    protected void snapVertical(Segment vEdge, int x, Rectangle newBounds) {
        int maxDistance = 20;
        if (vEdge.edgeType == SegmentType.LEFT) {
            int margin;
            int n = margin = !this.mySnap ? 0 : Math.abs(newBounds.x - x);
            if (margin > maxDistance) {
                this.myLeftMargin = margin;
            } else {
                newBounds.x = x;
            }
        } else if (vEdge.edgeType == SegmentType.RIGHT) {
            int margin;
            int n = margin = !this.mySnap ? 0 : Math.abs(newBounds.x - (x - newBounds.width));
            if (margin > maxDistance) {
                this.myRightMargin = margin;
            } else {
                newBounds.x = x - newBounds.width;
            }
        } else if (vEdge.edgeType == SegmentType.CENTER_VERTICAL) {
            newBounds.x = x - newBounds.width / 2;
        } else assert (false) : vEdge;
    }

    @Override
    protected void snapHorizontal(Segment hEdge, int y, Rectangle newBounds) {
        int maxDistance = 20;
        if (hEdge.edgeType == SegmentType.TOP) {
            int margin;
            int n = margin = !this.mySnap ? 0 : Math.abs(newBounds.y - y);
            if (margin > maxDistance) {
                this.myTopMargin = margin;
            } else {
                newBounds.y = y;
            }
        } else if (hEdge.edgeType == SegmentType.BOTTOM) {
            int margin;
            int n = margin = !this.mySnap ? 0 : Math.abs(newBounds.y - (y - newBounds.height));
            if (margin > maxDistance) {
                this.myBottomMargin = margin;
            } else {
                newBounds.y = y - newBounds.height;
            }
        } else if (hEdge.edgeType == SegmentType.CENTER_HORIZONTAL) {
            int margin;
            int n = margin = !this.mySnap ? 0 : Math.abs(newBounds.y - (y - newBounds.height / 2));
            if (margin > maxDistance) {
                this.myTopMargin = margin;
            } else {
                newBounds.y = y - newBounds.height / 2;
            }
        } else if (hEdge.edgeType == SegmentType.BASELINE) {
            newBounds.y = y - this.myDraggedBaseline;
        } else assert (false) : hEdge;
    }

    public void updateMove(RadViewComponent primary, Rectangle newBounds, int modifierMask) {
        int baseline;
        this.clearSuggestions();
        this.mySnap = (modifierMask & 1) == 0;
        Rectangle b = this.myBounds = new Rectangle(newBounds);
        Segment edge = new Segment(b.y, b.x, MoveHandler.x2(b), null, null, SegmentType.TOP, MarginType.NO_MARGIN);
        List<Match> horizontalMatches = this.findClosest(edge, this.myHorizontalEdges);
        edge = new Segment(MoveHandler.y2(b), b.x, MoveHandler.x2(b), null, null, SegmentType.BOTTOM, MarginType.NO_MARGIN);
        this.addClosest(edge, this.myHorizontalEdges, horizontalMatches);
        edge = new Segment(b.x, b.y, MoveHandler.y2(b), null, null, SegmentType.LEFT, MarginType.NO_MARGIN);
        List<Match> verticalMatches = this.findClosest(edge, this.myVerticalEdges);
        edge = new Segment(MoveHandler.x2(b), b.y, MoveHandler.y2(b), null, null, SegmentType.RIGHT, MarginType.NO_MARGIN);
        this.addClosest(edge, this.myVerticalEdges, verticalMatches);
        edge = new Segment(MoveHandler.centerX(b), b.y, MoveHandler.y2(b), null, null, SegmentType.CENTER_VERTICAL, MarginType.NO_MARGIN);
        this.addClosest(edge, this.myCenterVertEdges, verticalMatches);
        edge = new Segment(MoveHandler.centerY(b), b.x, MoveHandler.x2(b), null, null, SegmentType.CENTER_HORIZONTAL, MarginType.NO_MARGIN);
        this.addClosest(edge, this.myCenterHorizEdges, horizontalMatches);
        if (primary != null && (baseline = primary.getBaseline()) != -1) {
            this.myDraggedBaseline = baseline;
            edge = new Segment(b.y + baseline, b.x, MoveHandler.x2(b), primary, null, SegmentType.BASELINE, MarginType.NO_MARGIN);
            this.addClosest(edge, this.myHorizontalEdges, horizontalMatches);
        }
        this.myHorizontalSuggestions = horizontalMatches;
        this.myVerticalSuggestions = verticalMatches;
        this.myRightMargin = 0;
        this.myLeftMargin = 0;
        this.myBottomMargin = 0;
        this.myTopMargin = 0;
        Match match = this.pickBestMatch(this.myHorizontalSuggestions);
        if (match != null) {
            if (this.myHorizontalDeps.contains((Object)match.edge.node)) {
                match.cycle = true;
            }
            this.myMoveTop = true;
            this.myMoveBottom = true;
            this.snapHorizontal(match.with, match.edge.at, this.myBounds);
            if (match.with.edgeType == SegmentType.TOP) {
                this.myCurrentTopMatch = match;
            } else if (match.with.edgeType == SegmentType.BOTTOM) {
                this.myCurrentBottomMatch = match;
            } else {
                assert (match.with.edgeType == SegmentType.CENTER_HORIZONTAL || match.with.edgeType == SegmentType.BASELINE) : match.with.edgeType;
                this.myCurrentTopMatch = match;
            }
        }
        if ((match = this.pickBestMatch(this.myVerticalSuggestions)) != null) {
            if (this.myVerticalDeps.contains((Object)match.edge.node)) {
                match.cycle = true;
            }
            this.myMoveLeft = true;
            this.myMoveRight = true;
            this.snapVertical(match.with, match.edge.at, this.myBounds);
            if (match.with.edgeType == SegmentType.LEFT) {
                this.myCurrentLeftMatch = match;
            } else if (match.with.edgeType == SegmentType.RIGHT) {
                this.myCurrentRightMatch = match;
            } else {
                assert (match.with.edgeType == SegmentType.CENTER_VERTICAL);
                this.myCurrentLeftMatch = match;
            }
        }
        this.checkCycles();
    }
}

