/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.relative;

import com.android.tools.idea.designer.Insets;
import com.android.tools.idea.designer.MarginType;
import com.android.tools.idea.designer.Segment;
import com.android.tools.idea.designer.SegmentType;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.intellij.android.designer.AndroidDesignerUtils;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.relative.ConstraintType;
import com.intellij.android.designer.model.layout.relative.DependencyGraph;
import com.intellij.android.designer.model.layout.relative.Match;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.Nullable;

public class GuidelineHandler {
    protected final DependencyGraph myDependencyGraph;
    protected final RadViewComponent layout;
    protected Collection<RadViewComponent> myDraggedNodes;
    protected Rectangle myBounds;
    protected boolean myMoveLeft;
    protected boolean myMoveRight;
    protected boolean myMoveTop;
    protected boolean myMoveBottom;
    protected boolean mySnap = true;
    protected Set<RadViewComponent> myHorizontalDeps;
    protected Set<RadViewComponent> myVerticalDeps;
    protected List<DependencyGraph.Constraint> myHorizontalCycle;
    protected List<DependencyGraph.Constraint> myVerticalCycle;
    protected final List<Segment> myHorizontalEdges;
    protected final List<Segment> myVerticalEdges;
    protected final List<Segment> myCenterVertEdges;
    protected final List<Segment> myCenterHorizEdges;
    protected List<Match> myHorizontalSuggestions;
    protected List<Match> myVerticalSuggestions;
    protected Match myCurrentLeftMatch;
    protected Match myCurrentTopMatch;
    protected Match myCurrentRightMatch;
    protected Match myCurrentBottomMatch;
    protected int myTopMargin;
    protected int myBottomMargin;
    protected int myLeftMargin;
    protected int myRightMargin;
    protected final OperationContext myContext;
    protected String myErrorMessage;

    GuidelineHandler(RadViewComponent layout, OperationContext context) {
        this.layout = layout;
        this.myContext = context;
        this.myHorizontalEdges = new ArrayList<Segment>();
        this.myVerticalEdges = new ArrayList<Segment>();
        this.myCenterVertEdges = new ArrayList<Segment>();
        this.myCenterHorizEdges = new ArrayList<Segment>();
        this.myDependencyGraph = DependencyGraph.get(layout);
    }

    public boolean haveSuggestions() {
        return this.myCurrentLeftMatch != null || this.myCurrentTopMatch != null || this.myCurrentRightMatch != null || this.myCurrentBottomMatch != null;
    }

    @Nullable
    protected Match pickBestMatch(List<Match> matches) {
        int alternatives = matches.size();
        if (alternatives == 0) {
            return null;
        }
        if (alternatives == 1) {
            return matches.get(0);
        }
        assert (alternatives > 1);
        Collections.sort(matches, new MatchComparator());
        return matches.get(0);
    }

    private boolean checkCycle(Match match, boolean vertical) {
        if (match != null && match.cycle) {
            for (RadViewComponent to : this.myDraggedNodes) {
                RadViewComponent from = match.edge.node;
                if (from == null) continue;
                assert (match.with.node == null || match.with.node == to);
                List<DependencyGraph.Constraint> path = this.myDependencyGraph.getPathTo(from, to, vertical);
                if (path == null) continue;
                if (vertical) {
                    this.myVerticalCycle = path;
                } else {
                    this.myHorizontalCycle = path;
                }
                String desc = DependencyGraph.Constraint.describePath(path, match.type.name, match.edge.id);
                this.myErrorMessage = "Constraint creates a cycle: " + desc;
                return true;
            }
        }
        return false;
    }

    protected String checkCycles() {
        this.myErrorMessage = null;
        this.myHorizontalCycle = null;
        this.myVerticalCycle = null;
        if (this.checkCycle(this.myCurrentTopMatch, true) || this.checkCycle(this.myCurrentBottomMatch, true)) {
            // empty if block
        }
        if (this.checkCycle(this.myCurrentLeftMatch, false) || this.checkCycle(this.myCurrentRightMatch, false)) {
            // empty if block
        }
        return this.myErrorMessage;
    }

    protected void addBounds(RadViewComponent node, String id, boolean addHorizontal, boolean addVertical, boolean includePadding) {
        Insets p;
        FeedbackLayer target = this.myContext.getArea().getFeedbackLayer();
        Rectangle b = node.getBounds(target);
        Insets m = node.getMargins(target);
        Insets insets = p = includePadding ? node.getPadding(target) : Insets.NONE;
        if (addHorizontal) {
            if (m.top != 0) {
                this.myHorizontalEdges.add(new Segment(b.y + p.top, b.x + p.left, GuidelineHandler.x2(b) - p.right, node, id, SegmentType.TOP, MarginType.WITHOUT_MARGIN));
                this.myHorizontalEdges.add(new Segment(b.y - m.top + p.top, b.x + p.left, GuidelineHandler.x2(b) - p.right, node, id, SegmentType.TOP, MarginType.WITH_MARGIN));
            } else {
                this.myHorizontalEdges.add(new Segment(b.y + p.top, b.x + p.left, GuidelineHandler.x2(b) - p.right, node, id, SegmentType.TOP, MarginType.NO_MARGIN));
            }
            if (m.bottom != 0) {
                this.myHorizontalEdges.add(new Segment(GuidelineHandler.y2(b) - p.bottom, b.x + p.left, GuidelineHandler.x2(b) - p.right, node, id, SegmentType.BOTTOM, MarginType.WITHOUT_MARGIN));
                this.myHorizontalEdges.add(new Segment(GuidelineHandler.y2(b) + m.bottom - p.bottom, b.x + p.left, GuidelineHandler.x2(b) - p.right, node, id, SegmentType.BOTTOM, MarginType.WITH_MARGIN));
            } else {
                this.myHorizontalEdges.add(new Segment(GuidelineHandler.y2(b) - p.bottom, b.x + p.left, GuidelineHandler.x2(b) - p.right, node, id, SegmentType.BOTTOM, MarginType.NO_MARGIN));
            }
        }
        if (addVertical) {
            if (m.left != 0) {
                this.myVerticalEdges.add(new Segment(b.x + p.left, b.y + p.top, GuidelineHandler.y2(b) - p.bottom, node, id, SegmentType.LEFT, MarginType.WITHOUT_MARGIN));
                this.myVerticalEdges.add(new Segment(b.x - m.left + p.left, b.y + p.top, GuidelineHandler.y2(b) - p.bottom, node, id, SegmentType.LEFT, MarginType.WITH_MARGIN));
            } else {
                this.myVerticalEdges.add(new Segment(b.x + p.left, b.y + p.top, GuidelineHandler.y2(b) - p.bottom, node, id, SegmentType.LEFT, MarginType.NO_MARGIN));
            }
            if (m.right != 0) {
                this.myVerticalEdges.add(new Segment(GuidelineHandler.x2(b) - p.right, b.y + p.top, GuidelineHandler.y2(b) - p.bottom, node, id, SegmentType.RIGHT, MarginType.WITHOUT_MARGIN));
                this.myVerticalEdges.add(new Segment(GuidelineHandler.x2(b) + m.right - p.right, b.y + p.top, GuidelineHandler.y2(b) - p.bottom, node, id, SegmentType.RIGHT, MarginType.WITH_MARGIN));
            } else {
                this.myVerticalEdges.add(new Segment(GuidelineHandler.x2(b) - p.right, b.y + p.top, GuidelineHandler.y2(b) - p.bottom, node, id, SegmentType.RIGHT, MarginType.NO_MARGIN));
            }
        }
    }

    protected void addCenter(RadViewComponent node, String id) {
        FeedbackLayer target = this.myContext.getArea().getFeedbackLayer();
        Rectangle b = node.getBounds(target);
        this.myCenterHorizEdges.add(new Segment(GuidelineHandler.centerY(b), b.x, GuidelineHandler.x2(b), node, id, SegmentType.CENTER_HORIZONTAL, MarginType.NO_MARGIN));
        this.myCenterVertEdges.add(new Segment(GuidelineHandler.centerX(b), b.y, GuidelineHandler.y2(b), node, id, SegmentType.CENTER_VERTICAL, MarginType.NO_MARGIN));
    }

    protected int addBaseLine(RadViewComponent node, String id) {
        int baselineY = node.getBaseline();
        if (baselineY != -1) {
            FeedbackLayer target = this.myContext.getArea().getFeedbackLayer();
            Rectangle b = node.getBounds(target);
            baselineY = node.fromModel((Component)target, (Dimension)new Dimension((int)0, (int)baselineY)).height;
            this.myHorizontalEdges.add(new Segment(b.y + baselineY, b.x, GuidelineHandler.x2(b), node, id, SegmentType.BASELINE, MarginType.NO_MARGIN));
        }
        return baselineY;
    }

    protected void snapVertical(Segment vEdge, int x, Rectangle newBounds) {
        newBounds.x = x;
    }

    protected void snapHorizontal(Segment hEdge, int y, Rectangle newBounds) {
        newBounds.y = y;
    }

    protected boolean isEdgeTypeCompatible(SegmentType edge, SegmentType dragged, int delta) {
        if (Math.abs(delta) > 20 && (dragged == SegmentType.LEFT || dragged == SegmentType.TOP ? delta > 0 : delta < 0)) {
            return false;
        }
        switch (edge) {
            case BOTTOM: 
            case TOP: {
                return dragged == SegmentType.TOP || dragged == SegmentType.BOTTOM;
            }
            case LEFT: 
            case RIGHT: {
                return dragged == SegmentType.LEFT || dragged == SegmentType.RIGHT;
            }
            case BASELINE: 
            case CENTER_HORIZONTAL: 
            case CENTER_VERTICAL: {
                return dragged == edge && Math.abs(delta) < 20;
            }
        }
        assert (false) : edge;
        return false;
    }

    protected List<Match> findClosest(Segment draggedEdge, List<Segment> edges) {
        ArrayList<Match> closest = new ArrayList<Match>();
        this.addClosest(draggedEdge, edges, closest);
        return closest;
    }

    protected void addClosest(Segment draggedEdge, List<Segment> edges, List<Match> closest) {
        int at = draggedEdge.at;
        int closestDelta = closest.size() > 0 ? closest.get((int)0).delta : Integer.MAX_VALUE;
        int closestDistance = Math.abs(closestDelta);
        for (Segment edge : edges) {
            boolean withParent;
            ConstraintType type;
            assert (draggedEdge.edgeType.isHorizontal() == edge.edgeType.isHorizontal());
            int delta = edge.at - at;
            int distance = Math.abs(delta);
            if (distance > closestDistance || !this.isEdgeTypeCompatible(edge.edgeType, draggedEdge.edgeType, delta) || (type = ConstraintType.forMatch(withParent = edge.node == this.layout, draggedEdge.edgeType, edge.edgeType)) == null || type.relativeToMargin && edge.marginType == MarginType.WITHOUT_MARGIN || !type.relativeToMargin && edge.marginType == MarginType.WITH_MARGIN) continue;
            Match match = new Match(edge, draggedEdge, type, delta);
            if (distance < closestDistance) {
                closest.clear();
                closestDistance = distance;
                closestDelta = delta;
            } else if (delta * closestDelta < 0) continue;
            closest.add(match);
        }
    }

    protected void clearSuggestions() {
        this.myErrorMessage = null;
        this.myVerticalSuggestions = null;
        this.myHorizontalSuggestions = null;
        this.myCurrentRightMatch = null;
        this.myCurrentLeftMatch = null;
        this.myCurrentBottomMatch = null;
        this.myCurrentTopMatch = null;
    }

    public void applyConstraints(RadViewComponent n) {
        String rtlConstraint;
        String constraint;
        String value;
        XmlTag tag;
        XmlAttribute attribute;
        XmlAttribute centerBoth = n.getTag().getAttribute("layout_centerInParent", "http://schemas.android.com/apk/res/android");
        if (centerBoth != null && "true".equals(centerBoth.getValue())) {
            centerBoth.delete();
            if (this.myCurrentTopMatch == null && this.myCurrentBottomMatch == null) {
                n.getTag().setAttribute("layout_centerVertical", "http://schemas.android.com/apk/res/android", "true");
            }
            if (this.myCurrentLeftMatch == null && this.myCurrentRightMatch == null) {
                n.getTag().setAttribute("layout_centerHorizontal", "http://schemas.android.com/apk/res/android", "true");
            }
        }
        if ((this.myMoveTop || this.myMoveBottom || this.myMoveLeft || this.myMoveRight) && (attribute = (tag = n.getTag()).getAttribute("layout_margin", "http://schemas.android.com/apk/res/android")) != null && (value = attribute.getValue()) != null) {
            attribute.delete();
            tag.setAttribute("layout_marginLeft", "http://schemas.android.com/apk/res/android", value);
            tag.setAttribute("layout_marginRight", "http://schemas.android.com/apk/res/android", value);
            tag.setAttribute("layout_marginTop", "http://schemas.android.com/apk/res/android", value);
            tag.setAttribute("layout_marginBottom", "http://schemas.android.com/apk/res/android", value);
        }
        if (this.myMoveTop) {
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignParentTop");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignTop");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_below");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_centerVertical");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignBaseline");
        }
        if (this.myMoveBottom) {
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignParentBottom");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignBottom");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_above");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_centerVertical");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignBaseline");
        }
        if (this.myMoveLeft) {
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignParentLeft");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignLeft");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignParentStart");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignStart");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_toRightOf");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_centerHorizontal");
        }
        if (this.myMoveRight) {
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignParentRight");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignRight");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignParentEnd");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignEnd");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_toLeftOf");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_centerHorizontal");
        }
        if (this.myMoveTop && this.myCurrentTopMatch != null) {
            GuidelineHandler.applyConstraint(n, this.myCurrentTopMatch.getConstraint(true));
            if (this.myCurrentTopMatch.type == ConstraintType.ALIGN_BASELINE) {
                String c = this.myCurrentTopMatch.getConstraint(true);
                c = c.replace("layout_alignBaseline", "layout_alignBottom");
                GuidelineHandler.applyConstraint(n, c);
            }
        }
        if (this.myMoveBottom && this.myCurrentBottomMatch != null) {
            GuidelineHandler.applyConstraint(n, this.myCurrentBottomMatch.getConstraint(true));
        }
        if (this.myMoveLeft && this.myCurrentLeftMatch != null) {
            constraint = this.myCurrentLeftMatch.getConstraint(true);
            rtlConstraint = this.myCurrentLeftMatch.getRtlConstraint(true);
            if (rtlConstraint != null && this.supportsStartEnd()) {
                if (this.requiresRightLeft()) {
                    GuidelineHandler.applyConstraint(n, constraint);
                }
                GuidelineHandler.applyConstraint(n, rtlConstraint);
            } else {
                GuidelineHandler.applyConstraint(n, constraint);
            }
        }
        if (this.myMoveRight && this.myCurrentRightMatch != null) {
            constraint = this.myCurrentRightMatch.getConstraint(true);
            rtlConstraint = this.myCurrentRightMatch.getRtlConstraint(true);
            if (rtlConstraint != null && this.supportsStartEnd()) {
                if (this.requiresRightLeft()) {
                    GuidelineHandler.applyConstraint(n, constraint);
                }
                GuidelineHandler.applyConstraint(n, rtlConstraint);
            } else {
                GuidelineHandler.applyConstraint(n, constraint);
            }
        }
        if (this.myMoveLeft) {
            GuidelineHandler.applyMargin(n, "layout_marginLeft", this.getLeftMarginDp());
        }
        if (this.myMoveRight) {
            GuidelineHandler.applyMargin(n, "layout_marginRight", this.getRightMarginDp());
        }
        if (this.myMoveTop) {
            GuidelineHandler.applyMargin(n, "layout_marginTop", this.getTopMarginDp());
        }
        if (this.myMoveBottom) {
            GuidelineHandler.applyMargin(n, "layout_marginBottom", this.getBottomMarginDp());
        }
    }

    private boolean supportsStartEnd() {
        AndroidFacet facet = AndroidDesignerUtils.getFacet(this.myContext.getArea());
        if (facet != null) {
            Module module = facet.getModule();
            return AndroidModuleInfo.getBuildSdkApiLevel(module) >= 17 && AndroidModuleInfo.getTargetSdkVersion(module).getApiLevel() >= 17;
        }
        return false;
    }

    private boolean requiresRightLeft() {
        AndroidFacet facet = AndroidDesignerUtils.getFacet(this.myContext.getArea());
        if (facet != null) {
            Module module = facet.getModule();
            return AndroidModuleInfo.getMinSdkVersion(module).getApiLevel() < 17;
        }
        return true;
    }

    private static void clearAttribute(RadViewComponent view, String uri, String attributeName) {
        XmlAttribute attribute = view.getTag().getAttribute(attributeName, uri);
        if (attribute != null) {
            attribute.delete();
        }
    }

    private static void applyConstraint(RadViewComponent n, String constraint) {
        assert (constraint.contains("=")) : constraint;
        String name = constraint.substring(0, constraint.indexOf(61));
        String value = constraint.substring(constraint.indexOf(61) + 1);
        n.getTag().setAttribute(name, "http://schemas.android.com/apk/res/android", value);
    }

    private static void applyMargin(RadViewComponent n, String marginAttribute, int marginDp) {
        if (marginDp > 0) {
            n.getTag().setAttribute(marginAttribute, "http://schemas.android.com/apk/res/android", String.format("%ddp", marginDp));
        } else {
            XmlAttribute attribute = n.getTag().getAttribute(marginAttribute, "http://schemas.android.com/apk/res/android");
            if (attribute != null) {
                attribute.delete();
            }
        }
    }

    private static void removeRelativeParams(RadViewComponent node) {
        for (ConstraintType type : ConstraintType.values()) {
            GuidelineHandler.clearAttribute(node, "http://schemas.android.com/apk/res/android", type.name);
        }
        GuidelineHandler.clearAttribute(node, "http://schemas.android.com/apk/res/android", "layout_marginLeft");
        GuidelineHandler.clearAttribute(node, "http://schemas.android.com/apk/res/android", "layout_marginRight");
        GuidelineHandler.clearAttribute(node, "http://schemas.android.com/apk/res/android", "layout_marginTop");
        GuidelineHandler.clearAttribute(node, "http://schemas.android.com/apk/res/android", "layout_marginBottom");
    }

    public void attachPrevious(RadViewComponent previous, RadViewComponent node) {
        GuidelineHandler.removeRelativeParams(node);
        String id = previous.getId();
        if (StringUtil.isEmpty((String)id)) {
            return;
        }
        if (this.myCurrentTopMatch != null || this.myCurrentBottomMatch != null) {
            node.getTag().setAttribute(this.myCurrentTopMatch != null ? "layout_below" : "layout_above", "http://schemas.android.com/apk/res/android", id);
            if (this.myCurrentLeftMatch != null) {
                GuidelineHandler.applyConstraint(node, this.myCurrentLeftMatch.getConstraint(true));
                GuidelineHandler.applyMargin(node, "layout_marginLeft", this.myLeftMargin);
            } else if (this.myCurrentRightMatch != null) {
                GuidelineHandler.applyConstraint(node, this.myCurrentRightMatch.getConstraint(true));
                GuidelineHandler.applyMargin(node, "layout_marginRight", this.myRightMargin);
            }
        } else if (this.myCurrentLeftMatch != null || this.myCurrentRightMatch != null) {
            node.getTag().setAttribute(this.myCurrentLeftMatch != null ? "layout_toRightOf" : "layout_toLeftOf", "http://schemas.android.com/apk/res/android", id);
            if (this.myCurrentTopMatch != null) {
                GuidelineHandler.applyConstraint(node, this.myCurrentTopMatch.getConstraint(true));
                GuidelineHandler.applyMargin(node, "layout_marginTop", this.getTopMarginDp());
            } else if (this.myCurrentBottomMatch != null) {
                GuidelineHandler.applyConstraint(node, this.myCurrentBottomMatch.getConstraint(true));
                GuidelineHandler.applyMargin(node, "layout_marginBottom", this.getBottomMarginDp());
            }
        }
    }

    public void removeCycles() {
        if (this.myHorizontalCycle != null) {
            this.removeCycles(this.myHorizontalDeps);
        }
        if (this.myVerticalCycle != null) {
            this.removeCycles(this.myVerticalDeps);
        }
    }

    private void removeCycles(Set<RadViewComponent> deps) {
        for (RadViewComponent node : this.myDraggedNodes) {
            DependencyGraph.ViewData view = this.myDependencyGraph.getView(node);
            if (view == null) continue;
            for (DependencyGraph.Constraint constraint : view.dependedOnBy) {
                GuidelineHandler.clearAttribute(constraint.from.node, "http://schemas.android.com/apk/res/android", constraint.type.name);
            }
        }
    }

    public Match getCurrentLeftMatch() {
        return this.myCurrentLeftMatch;
    }

    public Match getCurrentTopMatch() {
        return this.myCurrentTopMatch;
    }

    public Match getCurrentRightMatch() {
        return this.myCurrentRightMatch;
    }

    public Match getCurrentBottomMatch() {
        return this.myCurrentBottomMatch;
    }

    public int getLeftMarginDp() {
        if (this.myLeftMargin != 0) {
            FeedbackLayer target = this.myContext.getArea().getFeedbackLayer();
            int dpi = AndroidDesignerUtils.getDpi(this.myContext.getArea());
            return this.layout.toModelDp((int)dpi, (Component)target, (Dimension)new Dimension((int)this.myLeftMargin, (int)0)).width;
        }
        return this.myLeftMargin;
    }

    public int getRightMarginDp() {
        if (this.myRightMargin != 0) {
            FeedbackLayer target = this.myContext.getArea().getFeedbackLayer();
            int dpi = AndroidDesignerUtils.getDpi(this.myContext.getArea());
            return this.layout.toModelDp((int)dpi, (Component)target, (Dimension)new Dimension((int)this.myRightMargin, (int)0)).width;
        }
        return this.myRightMargin;
    }

    public int getTopMarginDp() {
        if (this.myTopMargin != 0) {
            FeedbackLayer target = this.myContext.getArea().getFeedbackLayer();
            int dpi = AndroidDesignerUtils.getDpi(this.myContext.getArea());
            return this.layout.toModelDp((int)dpi, (Component)target, (Dimension)new Dimension((int)0, (int)this.myTopMargin)).height;
        }
        return this.myTopMargin;
    }

    public int getBottomMarginDp() {
        if (this.myBottomMargin != 0) {
            FeedbackLayer target = this.myContext.getArea().getFeedbackLayer();
            int dpi = AndroidDesignerUtils.getDpi(this.myContext.getArea());
            return this.layout.toModelDp((int)dpi, (Component)target, (Dimension)new Dimension((int)0, (int)this.myBottomMargin)).height;
        }
        return this.myBottomMargin;
    }

    public OperationContext getContext() {
        return this.myContext;
    }

    static int centerX(Rectangle rectangle) {
        return rectangle.x + rectangle.width / 2;
    }

    static int centerY(Rectangle rectangle) {
        return rectangle.y + rectangle.height / 2;
    }

    static int x2(Rectangle rectangle) {
        return rectangle.x + rectangle.width;
    }

    static int y2(Rectangle rectangle) {
        return rectangle.y + rectangle.height;
    }

    private final class MatchComparator
    implements Comparator<Match> {
        private MatchComparator() {
        }

        @Override
        public int compare(Match m1, Match m2) {
            int edgeType2;
            int orientation2;
            int baseline2;
            int distance2;
            int distance1;
            int cycle2;
            int cycle1;
            int parent2;
            int parent1 = m1.edge.node == GuidelineHandler.this.layout ? -1 : 1;
            int n = parent2 = m2.edge.node == GuidelineHandler.this.layout ? -1 : 1;
            if (m1.edge.edgeType == SegmentType.CENTER_HORIZONTAL || m1.edge.edgeType == SegmentType.CENTER_VERTICAL) {
                parent1 = 2;
            }
            if (m2.edge.edgeType == SegmentType.CENTER_HORIZONTAL || m2.edge.edgeType == SegmentType.CENTER_VERTICAL) {
                parent2 = 2;
            }
            if (parent1 != parent2) {
                return parent1 - parent2;
            }
            if (m1.edge.edgeType.isHorizontal()) {
                cycle1 = GuidelineHandler.this.myHorizontalDeps.contains((Object)m1.edge.node) ? 1 : -1;
                int n2 = cycle2 = GuidelineHandler.this.myHorizontalDeps.contains((Object)m2.edge.node) ? 1 : -1;
                if (cycle1 != cycle2) {
                    return cycle1 - cycle2;
                }
            } else {
                cycle1 = GuidelineHandler.this.myVerticalDeps.contains((Object)m1.edge.node) ? 1 : -1;
                int n3 = cycle2 = GuidelineHandler.this.myVerticalDeps.contains((Object)m2.edge.node) ? 1 : -1;
                if (cycle1 != cycle2) {
                    return cycle1 - cycle2;
                }
            }
            if ((distance1 = m1.edge.to <= m1.with.from ? m1.with.from - m1.edge.to : (m1.edge.from >= m1.with.to ? m1.edge.from - m1.with.to : 0)) != (distance2 = m2.edge.to <= m2.with.from ? m2.with.from - m2.edge.to : (m2.edge.from >= m2.with.to ? m2.edge.from - m2.with.to : 0))) {
                return distance1 - distance2;
            }
            int baseline1 = m1.edge.edgeType == SegmentType.BASELINE ? -1 : 1;
            int n4 = baseline2 = m2.edge.edgeType == SegmentType.BASELINE ? -1 : 1;
            if (baseline1 != baseline2) {
                return baseline1 - baseline2;
            }
            int orientation1 = m1.with.edgeType == SegmentType.LEFT || m1.with.edgeType == SegmentType.TOP ? -1 : 1;
            int n5 = orientation2 = m2.with.edgeType == SegmentType.LEFT || m2.with.edgeType == SegmentType.TOP ? -1 : 1;
            if (orientation1 != orientation2) {
                return orientation1 - orientation2;
            }
            int edgeType1 = m1.edge.edgeType != m1.with.edgeType ? -1 : 1;
            int n6 = edgeType2 = m2.edge.edgeType != m2.with.edgeType ? -1 : 1;
            if (edgeType1 != edgeType2) {
                return edgeType1 - edgeType2;
            }
            return 0;
        }
    }
}

