/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.grid;

import com.android.ide.common.rendering.api.ViewInfo;
import com.intellij.android.designer.model.RadComponentOperations;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.RadViewContainer;
import com.intellij.android.designer.model.grid.GridInfo;
import com.intellij.android.designer.model.grid.IGridProvider;
import com.intellij.designer.componentTree.AttributeWrapper;
import com.intellij.designer.model.IComponentDecorator;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class RadGridLayoutComponent
extends RadViewContainer
implements IComponentDecorator,
IGridProvider {
    private GridInfo myGridInfo;
    private GridInfo myVirtualGridInfo;
    private static final int EMPTY_CELL = 5;

    @NotNull
    public static String getGridLayoutNamespace(@NotNull RadViewComponent component) {
        String fqcn;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/model/layout/grid/RadGridLayoutComponent", "getGridLayoutNamespace"));
        }
        RadComponent parent = component.getParent();
        if (parent instanceof RadViewComponent && (fqcn = ((RadViewComponent)parent).getTag().getName()).equals("android.support.v7.widget.GridLayout")) {
            if ("http://schemas.android.com/apk/res-auto" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/grid/RadGridLayoutComponent", "getGridLayoutNamespace"));
            }
            return "http://schemas.android.com/apk/res-auto";
        }
        fqcn = component.getTag().getName();
        if (fqcn.equals("android.support.v7.widget.GridLayout")) {
            if ("http://schemas.android.com/apk/res-auto" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/grid/RadGridLayoutComponent", "getGridLayoutNamespace"));
            }
            return "http://schemas.android.com/apk/res-auto";
        }
        if ("http://schemas.android.com/apk/res/android" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/grid/RadGridLayoutComponent", "getGridLayoutNamespace"));
        }
        return "http://schemas.android.com/apk/res/android";
    }

    @Override
    public void decorateTree(SimpleColoredComponent renderer, AttributeWrapper wrapper) {
        XmlTag tag = this.getTag();
        StringBuilder value = new StringBuilder(" (");
        String namespace = RadGridLayoutComponent.getGridLayoutNamespace(this);
        String rowCount = tag.getAttributeValue("rowCount", namespace);
        value.append(StringUtil.isEmpty((String)rowCount) ? "?" : rowCount).append(", ");
        String columnCount = tag.getAttributeValue("columnCount", namespace);
        value.append(StringUtil.isEmpty((String)columnCount) ? "?" : columnCount).append(", ");
        value.append(this.isHorizontal() ? "horizontal" : "vertical");
        renderer.append(value.append(")").toString(), wrapper.getAttribute(SimpleTextAttributes.REGULAR_ATTRIBUTES));
    }

    public boolean isHorizontal() {
        return !"vertical".equals(this.getTag().getAttributeValue("orientation", RadGridLayoutComponent.getGridLayoutNamespace(this)));
    }

    @Override
    public void setViewInfo(ViewInfo viewInfo) {
        super.setViewInfo(viewInfo);
        this.myGridInfo = null;
        this.myVirtualGridInfo = null;
    }

    @Override
    public GridInfo getGridInfo() {
        if (this.myGridInfo == null) {
            this.myGridInfo = new GridInfo(this);
            try {
                Field field_horizontalAxis;
                Object viewObject = this.myViewInfo.getViewObject();
                Class<?> viewClass = viewObject.getClass();
                this.myGridInfo.rowCount = (Integer)viewClass.getMethod("getRowCount", new Class[0]).invoke(viewObject, new Object[0]);
                this.myGridInfo.columnCount = (Integer)viewClass.getMethod("getColumnCount", new Class[0]).invoke(viewObject, new Object[0]);
                String verticalAxisName = "verticalAxis";
                try {
                    field_horizontalAxis = viewClass.getDeclaredField("horizontalAxis");
                }
                catch (NoSuchFieldException e) {
                    field_horizontalAxis = viewClass.getDeclaredField("mHorizontalAxis");
                    verticalAxisName = "mVerticalAxis";
                }
                field_horizontalAxis.setAccessible(true);
                Object horizontalAxis = field_horizontalAxis.get(viewObject);
                Class<?> class_Axis = horizontalAxis.getClass();
                Field field_locations = class_Axis.getField("locations");
                field_locations.setAccessible(true);
                this.myGridInfo.vLines = (int[])field_locations.get(horizontalAxis);
                this.myGridInfo.emptyColumns = RadGridLayoutComponent.configureEmptyLines(this.myGridInfo.vLines);
                Field field_verticalAxis = viewClass.getDeclaredField(verticalAxisName);
                field_verticalAxis.setAccessible(true);
                Object verticalAxis = field_verticalAxis.get(viewObject);
                this.myGridInfo.hLines = (int[])field_locations.get(verticalAxis);
                this.myGridInfo.emptyRows = RadGridLayoutComponent.configureEmptyLines(this.myGridInfo.hLines);
                Rectangle bounds = this.getBounds();
                for (RadComponent child : this.getChildren()) {
                    Rectangle childBounds = child.getBounds();
                    this.myGridInfo.width = Math.max(this.myGridInfo.width, childBounds.x + childBounds.width - bounds.x);
                    this.myGridInfo.height = Math.max(this.myGridInfo.height, childBounds.y + childBounds.height - bounds.y);
                }
                if (this.myGridInfo.vLines != null && this.myGridInfo.vLines.length > 0) {
                    this.myGridInfo.vLines[this.myGridInfo.vLines.length - 1] = this.myGridInfo.width;
                }
                if (this.myGridInfo.hLines != null && this.myGridInfo.hLines.length > 0) {
                    this.myGridInfo.hLines[this.myGridInfo.hLines.length - 1] = this.myGridInfo.height;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.myGridInfo;
    }

    private static boolean[] configureEmptyLines(int[] lines) {
        boolean[] empty = new boolean[lines.length - 1];
        int[] originalLines = Arrays.copyOf(lines, lines.length);
        for (int i = 0; i < empty.length; ++i) {
            int line_i = originalLines[i];
            int length = originalLines[i + 1] - line_i;
            boolean bl = empty[i] = length == 0;
            if (length != 0) continue;
            for (int startMove = i + 1; startMove < lines.length && line_i == lines[startMove]; ++startMove) {
            }
            int j = i + 1;
            while (j < lines.length) {
                int n = j++;
                lines[n] = lines[n] + 5;
            }
            for (j = startMove; j < lines.length; ++j) {
                if (lines[j - 1] >= lines[j] - 10) continue;
                int n = j;
                lines[n] = lines[n] - 10;
            }
        }
        return empty;
    }

    @Override
    public GridInfo getVirtualGridInfo() {
        if (this.myVirtualGridInfo == null) {
            this.myVirtualGridInfo = new GridInfo(this);
            GridInfo gridInfo = this.getGridInfo();
            Rectangle bounds = this.getBounds();
            this.myVirtualGridInfo.rowCount = gridInfo.rowCount;
            this.myVirtualGridInfo.columnCount = gridInfo.columnCount;
            this.myVirtualGridInfo.width = bounds.width;
            this.myVirtualGridInfo.height = bounds.height;
            int deltaWidth = bounds.width - gridInfo.width;
            this.myVirtualGridInfo.vLines = GridInfo.addLineInfo(gridInfo.vLines, deltaWidth);
            if (deltaWidth < 2) {
                this.myVirtualGridInfo.lastInsertColumn = gridInfo.columnCount - 1;
            }
            int deltaHeight = bounds.height - gridInfo.height;
            this.myVirtualGridInfo.hLines = GridInfo.addLineInfo(gridInfo.hLines, deltaHeight);
            if (deltaHeight < 2) {
                this.myVirtualGridInfo.lastInsertRow = gridInfo.rowCount - 1;
            }
            this.myVirtualGridInfo.components = this.getGridComponents(true);
        }
        return this.myVirtualGridInfo;
    }

    public RadComponent[][] getGridComponents(boolean fillSpans) {
        GridInfo gridInfo = this.getGridInfo();
        RadComponent[][] components = new RadComponent[gridInfo.rowCount][gridInfo.columnCount];
        for (RadComponent child : this.getChildren()) {
            Rectangle cellInfo = RadGridLayoutComponent.getCellInfo(child);
            if (fillSpans) {
                int rowEnd = Math.min(cellInfo.y + cellInfo.height, gridInfo.rowCount);
                int columnEnd = Math.min(cellInfo.x + cellInfo.width, gridInfo.columnCount);
                for (int row = cellInfo.y; row < rowEnd; ++row) {
                    for (int column = cellInfo.x; column < columnEnd; ++column) {
                        components[row][column] = child;
                    }
                }
                continue;
            }
            if (cellInfo.y >= gridInfo.rowCount || cellInfo.x >= gridInfo.columnCount) continue;
            components[cellInfo.y][cellInfo.x] = child;
        }
        return components;
    }

    public static Rectangle getCellInfo(RadComponent component) {
        Rectangle cellInfo = new Rectangle();
        try {
            Object layoutParams = ((RadViewComponent)component).getViewInfo().getLayoutParamsObject();
            Class<?> layoutParamsClass = layoutParams.getClass();
            Object columnSpec = layoutParamsClass.getField("columnSpec").get(layoutParams);
            Object rowSpec = layoutParamsClass.getField("rowSpec").get(layoutParams);
            Class<?> class_Spec = columnSpec.getClass();
            Field field_span = class_Spec.getDeclaredField("span");
            field_span.setAccessible(true);
            Object columnSpan = field_span.get(columnSpec);
            Object rowSpan = field_span.get(rowSpec);
            Class<?> class_Interval = columnSpan.getClass();
            Field field_min = class_Interval.getField("min");
            field_min.setAccessible(true);
            Field field_max = class_Interval.getField("max");
            field_max.setAccessible(true);
            cellInfo.x = field_min.getInt(columnSpan);
            cellInfo.y = field_min.getInt(rowSpan);
            cellInfo.width = field_max.getInt(columnSpan) - cellInfo.x;
            cellInfo.height = field_max.getInt(rowSpan) - cellInfo.y;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return cellInfo;
    }

    public static void setCellIndex(final RadComponent component, final int row, final int column, final boolean clearRowSpan, final boolean clearColumnSpan) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                int rows;
                int requiredRows;
                String rowCount;
                int columns;
                int requiredColumns;
                XmlTag layoutTag;
                String columnCount;
                XmlTag tag = ((RadViewComponent)component).getTag();
                String namespace = RadGridLayoutComponent.getGridLayoutNamespace((RadViewComponent)component);
                tag.setAttribute("layout_row", namespace, Integer.toString(row));
                tag.setAttribute("layout_column", namespace, Integer.toString(column));
                if (clearRowSpan) {
                    RadComponentOperations.deleteAttribute(tag, "layout_rowSpan", namespace);
                }
                if (clearColumnSpan) {
                    RadComponentOperations.deleteAttribute(tag, "layout_columnSpan", namespace);
                }
                if ((columnCount = (layoutTag = ((RadViewComponent)component.getParent()).getTag()).getAttributeValue("columnCount", namespace)) != null && (requiredColumns = column + (clearColumnSpan ? 1 : RadGridLayoutComponent.getSpan(component, false))) > (columns = Integer.parseInt(columnCount))) {
                    layoutTag.setAttribute("columnCount", namespace, Integer.toString(requiredColumns));
                }
                if ((rowCount = layoutTag.getAttributeValue("rowCount", namespace)) != null && (requiredRows = row + (clearRowSpan ? 1 : RadGridLayoutComponent.getSpan(component, true))) > (rows = Integer.parseInt(rowCount))) {
                    layoutTag.setAttribute("rowCount", namespace, Integer.toString(requiredRows));
                }
            }
        });
    }

    public static int getSpan(RadComponent component, boolean row) {
        try {
            String namespace = RadGridLayoutComponent.getGridLayoutNamespace((RadViewComponent)component);
            String span = ((RadViewComponent)component).getTag().getAttributeValue(row ? "layout_rowSpan" : "layout_columnSpan", namespace);
            return Integer.parseInt(span);
        }
        catch (Throwable e) {
            return 1;
        }
    }

    public static void setSpan(final RadComponent component, final int span, final boolean row) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                String namespace = RadGridLayoutComponent.getGridLayoutNamespace((RadViewComponent)component);
                XmlTag tag = ((RadViewComponent)component).getTag();
                tag.setAttribute(row ? "layout_rowSpan" : "layout_columnSpan", namespace, Integer.toString(span));
            }
        });
    }

    public static void clearCellSpans(final RadComponent component) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                String namespace = RadGridLayoutComponent.getGridLayoutNamespace((RadViewComponent)component);
                XmlTag tag = ((RadViewComponent)component).getTag();
                RadComponentOperations.deleteAttribute(tag, "layout_rowSpan", namespace);
                RadComponentOperations.deleteAttribute(tag, "layout_columnSpan", namespace);
            }
        });
    }
}

