/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.grid;

import com.intellij.android.designer.designSurface.layout.GridLayoutOperation;
import com.intellij.android.designer.model.grid.GridInfo;
import com.intellij.android.designer.model.grid.RadCaptionRow;
import com.intellij.android.designer.model.layout.grid.RadGridLayoutComponent;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.IGroupDeleteComponent;
import com.intellij.designer.model.RadComponent;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class RadCaptionGridRow
extends RadCaptionRow<RadGridLayoutComponent>
implements IGroupDeleteComponent {
    public RadCaptionGridRow(EditableArea mainArea, RadGridLayoutComponent container, int index, int offset, int width, boolean empty) {
        super(mainArea, container, index, offset, width, empty);
    }

    @Override
    public void delete(List<RadComponent> rows) throws Exception {
        ArrayList<RadComponent> deletedComponents = new ArrayList<RadComponent>();
        GridInfo gridInfo = ((RadGridLayoutComponent)this.myContainer).getVirtualGridInfo();
        RadComponent[][] components = ((RadGridLayoutComponent)this.myContainer).getGridComponents(false);
        for (RadComponent row : rows) {
            RadCaptionGridRow.delete(deletedComponents, gridInfo, components, (RadCaptionGridRow)row);
        }
        RadComponent[][] newComponents = new RadComponent[components.length - rows.size()][];
        int index = 0;
        for (int i = 0; i < components.length; ++i) {
            boolean add = true;
            for (RadComponent row : rows) {
                if (i != ((RadCaptionGridRow)row).myIndex) continue;
                add = false;
                break;
            }
            if (!add) continue;
            newComponents[index++] = components[i];
        }
        GridLayoutOperation.validateLayoutParams(newComponents);
        this.deselect(deletedComponents);
    }

    private static void delete(List<RadComponent> deletedComponents, GridInfo gridInfo, RadComponent[][] components, RadCaptionGridRow row) throws Exception {
        if (row.myIndex > 0) {
            GridLayoutOperation.shiftRowSpan(gridInfo, row.myIndex - 1, -1);
        }
        for (RadComponent component : components[row.myIndex]) {
            if (component == null) continue;
            Rectangle cellIndex = RadGridLayoutComponent.getCellInfo(component);
            GridInfo.setNull(components, gridInfo.components, cellIndex.y, cellIndex.y + cellIndex.height, cellIndex.x, cellIndex.x + cellIndex.width);
            component.delete();
            deletedComponents.add(component);
        }
    }
}

