/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.actions;

import com.android.utils.XmlUtils;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.RadLinearLayout;
import com.intellij.android.designer.model.layout.actions.LayoutAction;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import icons.AndroidDesignerIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DistributeWeightsAction
extends LayoutAction {
    private final RadViewComponent myLayout;
    private final List<? extends RadViewComponent> mySelectedChildren;

    public DistributeWeightsAction(@NotNull DesignerEditorPanel designer, @NotNull RadViewComponent layout, @NotNull List<? extends RadViewComponent> selectedChildren) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/model/layout/actions/DistributeWeightsAction", "<init>"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/android/designer/model/layout/actions/DistributeWeightsAction", "<init>"));
        }
        if (selectedChildren == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/android/designer/model/layout/actions/DistributeWeightsAction", "<init>"));
        }
        super(designer, "Distribute Weights Evenly", null, AndroidDesignerIcons.DistributeWeights);
        this.myLayout = layout;
        this.mySelectedChildren = selectedChildren;
    }

    @Override
    protected void performWriteAction() {
        DistributeWeightsAction.distributeWeights(this.myLayout, this.mySelectedChildren);
    }

    static void distributeWeights(RadViewComponent parentNode, List<? extends RadViewComponent> targets) {
        String weightSum = parentNode.getTag().getAttributeValue("weightSum", "http://schemas.android.com/apk/res/android");
        double sum = -1.0;
        if (weightSum != null && !weightSum.isEmpty()) {
            try {
                sum = Double.parseDouble(weightSum);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        int numTargets = targets.size();
        double share = sum <= 0.0 ? 1.0 : sum / (double)numTargets;
        String value = XmlUtils.formatFloatAttribute((double)((float)share));
        String sizeAttribute = ((RadLinearLayout)parentNode.getLayout()).isHorizontal() ? "layout_width" : "layout_height";
        for (RadViewComponent radViewComponent : targets) {
            radViewComponent.getTag().setAttribute("layout_weight", "http://schemas.android.com/apk/res/android", value);
            if (!"wrap_content".equals(radViewComponent.getTag().getAttributeValue(sizeAttribute, "http://schemas.android.com/apk/res/android"))) continue;
            radViewComponent.getTag().setAttribute(sizeAttribute, "http://schemas.android.com/apk/res/android", "0dp");
        }
    }
}

