/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout;

import com.android.tools.idea.designer.ResizeOperation;
import com.android.tools.idea.designer.ResizePolicy;
import com.intellij.android.designer.designSurface.TreeDropToOperation;
import com.intellij.android.designer.designSurface.graphics.DirectionResizePoint;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import com.intellij.android.designer.designSurface.graphics.ResizeSelectionDecorator;
import com.intellij.android.designer.designSurface.layout.FrameLayoutOperation;
import com.intellij.android.designer.designSurface.layout.actions.LayoutMarginOperation;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.RadViewLayoutWithData;
import com.intellij.android.designer.model.layout.Gravity;
import com.intellij.android.designer.model.layout.actions.AbstractGravityAction;
import com.intellij.designer.componentTree.TreeEditOperation;
import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.selection.ResizePoint;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.util.Pair;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class RadFrameLayout
extends RadViewLayoutWithData {
    private static final String[] LAYOUT_PARAMS = new String[]{"FrameLayout_Layout", "ViewGroup_MarginLayout"};
    private ResizeSelectionDecorator mySelectionDecorator;
    private static List<Pair<Boolean, Gravity>> ITEMS = Arrays.asList(Pair.create((Object)Boolean.FALSE, (Object)((Object)Gravity.top)), Pair.create((Object)Boolean.FALSE, (Object)((Object)Gravity.center)), Pair.create((Object)Boolean.FALSE, (Object)((Object)Gravity.bottom)), null, Pair.create((Object)Boolean.TRUE, (Object)((Object)Gravity.left)), Pair.create((Object)Boolean.TRUE, (Object)((Object)Gravity.center)), Pair.create((Object)Boolean.TRUE, (Object)((Object)Gravity.right)));

    @Override
    @NotNull
    public String[] getLayoutParams() {
        if (LAYOUT_PARAMS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/RadFrameLayout", "getLayoutParams"));
        }
        return LAYOUT_PARAMS;
    }

    @Override
    public EditOperation processChildOperation(OperationContext context) {
        if (context.isCreate() || context.isPaste() || context.isAdd() || context.isMove()) {
            if (context.isTree()) {
                if (TreeEditOperation.isTarget(this.myContainer, context)) {
                    return new TreeDropToOperation(this.myContainer, context);
                }
                return null;
            }
            return new FrameLayoutOperation(this.myContainer, context);
        }
        if (context.is("resize_children")) {
            return new ResizeOperation(context);
        }
        if (context.is("layout_margin")) {
            return new LayoutMarginOperation(context);
        }
        return null;
    }

    @Override
    public ComponentDecorator getChildSelectionDecorator(RadComponent component, List<RadComponent> selection) {
        if (this.mySelectionDecorator == null) {
            this.mySelectionDecorator = new ResizeSelectionDecorator(DrawingStyle.SELECTION){

                @Override
                protected boolean visible(RadComponent component, ResizePoint point) {
                    if (point.getType() == "resize_children" && component instanceof RadViewComponent) {
                        ResizePolicy policy = ResizePolicy.getResizePolicy((RadViewComponent)component);
                        return policy.applies((DirectionResizePoint)point);
                    }
                    if (point.getType() == "layout_margin") {
                        Pair<Gravity, Gravity> gravity = Gravity.getSides(component);
                        int direction = ((DirectionResizePoint)point).getDirection();
                        if (direction == 4) {
                            return gravity.first == Gravity.left || gravity.first == Gravity.center;
                        }
                        if (direction == 8) {
                            return gravity.first == Gravity.right || gravity.first == Gravity.center;
                        }
                        if (direction == 1) {
                            return gravity.second == Gravity.top || gravity.second == Gravity.center;
                        }
                        if (direction == 2) {
                            return gravity.second == Gravity.bottom || gravity.second == Gravity.center;
                        }
                    }
                    return true;
                }
            };
        }
        this.mySelectionDecorator.clear();
        if (selection.size() == 1) {
            ResizeOperation.addResizePoints(this.mySelectionDecorator, (RadViewComponent)selection.get(0));
        } else {
            ResizeOperation.addResizePoints(this.mySelectionDecorator);
        }
        return this.mySelectionDecorator;
    }

    @Override
    public void addContainerSelectionActions(DesignerEditorPanel designer, DefaultActionGroup actionGroup, List<? extends RadViewComponent> selection) {
        super.addContainerSelectionActions(designer, actionGroup, selection);
        if (selection.size() != 1) {
            return;
        }
        AbstractGravityAction<Pair<Boolean, Gravity>> action = new AbstractGravityAction<Pair<Boolean, Gravity>>(designer, selection){
            private Pair<Gravity, Gravity> myGravity;

            @Override
            protected boolean addSeparator(DefaultActionGroup actionGroup, Pair<Boolean, Gravity> item) {
                if (item == null) {
                    actionGroup.addSeparator();
                    return true;
                }
                return false;
            }

            @Override
            @NotNull
            protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                this.myGravity = Gravity.getSides((RadComponent)((Object)this.myComponents.get(0)));
                DefaultActionGroup defaultActionGroup = super.createPopupActionGroup(button);
                if (defaultActionGroup == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/RadFrameLayout$2", "createPopupActionGroup"));
                }
                return defaultActionGroup;
            }

            @Override
            protected void update(Pair<Boolean, Gravity> item, Presentation presentation, boolean popup) {
                if (popup) {
                    Gravity selection = (Boolean)item.first != false ? (Gravity)((Object)this.myGravity.first) : (Gravity)((Object)this.myGravity.second);
                    presentation.setIcon(selection == item.second ? CHECKED : null);
                    presentation.setText(((Gravity)((Object)item.second)).name());
                }
            }

            @Override
            protected boolean selectionChanged(Pair<Boolean, Gravity> item) {
                Gravity oldSelection;
                Gravity gravity = oldSelection = (Boolean)item.first != false ? (Gravity)((Object)this.myGravity.first) : (Gravity)((Object)this.myGravity.second);
                if (oldSelection != item.second) {
                    final String gravity2 = (Boolean)item.first != false ? Gravity.getValue((Gravity)((Object)item.second), (Gravity)((Object)this.myGravity.second)) : Gravity.getValue((Gravity)((Object)this.myGravity.first), (Gravity)((Object)item.second));
                    this.execute(new Runnable(){

                        @Override
                        public void run() {
                            ((RadViewComponent)((Object)myComponents.get(0))).getTag().setAttribute("layout_gravity", "http://schemas.android.com/apk/res/android", gravity2);
                        }
                    });
                }
                return false;
            }

            @Override
            public void setSelection(Pair<Boolean, Gravity> selection) {
            }
        };
        action.setItems(ITEMS, null);
        actionGroup.add((AnAction)action);
    }
}

