/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface.layout.caption;

import com.intellij.android.designer.designSurface.layout.AbstractFlowBaseOperation;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.feedbacks.LineInsertFeedback;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadVisualComponent;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class HorizontalCaptionFlowBaseOperation<T extends RadViewComponent>
extends AbstractFlowBaseOperation {
    protected final T myMainContainer;
    private final EditableArea myMainArea;
    private LineInsertFeedback myMainInsertFeedback;
    private int myMainYLocation;

    public HorizontalCaptionFlowBaseOperation(T mainContainer, RadComponent container, OperationContext context, EditableArea mainArea) {
        super(container, context, true);
        this.myMainContainer = mainContainer;
        this.myMainArea = mainArea;
    }

    @Override
    protected void createFeedback() {
        super.createFeedback();
        if (this.myMainInsertFeedback == null) {
            FeedbackLayer layer = this.myMainArea.getFeedbackLayer();
            Rectangle bounds = ((RadVisualComponent)((Object)this.myMainContainer)).getBounds(layer);
            this.myMainYLocation = bounds.y;
            this.myMainInsertFeedback = new LineInsertFeedback((Color)JBColor.GREEN, false);
            this.myMainInsertFeedback.size(0, this.getMainFeedbackHeight(layer, this.myMainYLocation));
            layer.add(this.myMainInsertFeedback);
            layer.repaint();
        }
    }

    protected int getMainFeedbackHeight(FeedbackLayer layer, int mainYLocation) {
        List<RadComponent> children = ((RadViewComponent)((Object)this.myMainContainer)).getChildren();
        Rectangle lastChildBounds = children.get(children.size() - 1).getBounds(layer);
        return lastChildBounds.y + lastChildBounds.height - mainYLocation;
    }

    @Override
    public void showFeedback() {
        super.showFeedback();
        Point location = SwingUtilities.convertPoint(this.myInsertFeedback.getParent(), this.myInsertFeedback.getLocation(), this.myMainArea.getFeedbackLayer());
        this.myMainInsertFeedback.setLocation(location.x, this.myMainYLocation);
    }

    @Override
    public void eraseFeedback() {
        super.eraseFeedback();
        if (this.myMainInsertFeedback != null) {
            FeedbackLayer layer = this.myMainArea.getFeedbackLayer();
            layer.remove(this.myMainInsertFeedback);
            layer.repaint();
            this.myMainInsertFeedback = null;
        }
    }
}

