/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface.layout.actions;

import com.intellij.android.designer.designSurface.layout.actions.LayoutSpanOperation;
import com.intellij.android.designer.designSurface.layout.grid.GridSelectionDecorator;
import com.intellij.android.designer.model.grid.GridInfo;
import com.intellij.android.designer.model.layout.table.RadTableLayoutComponent;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.util.ArrayUtil;
import java.awt.Point;

public class TableLayoutSpanOperation
extends LayoutSpanOperation {
    public TableLayoutSpanOperation(OperationContext context, GridSelectionDecorator decorator) {
        super(context, decorator);
    }

    @Override
    public void setComponent(RadComponent component) {
        super.setComponent(component);
        this.mySpan = RadTableLayoutComponent.getCellSpan(this.myComponent);
    }

    @Override
    protected String getColumnAttribute(boolean asName) {
        return asName ? "layout:column" : "layout_column";
    }

    @Override
    protected String getColumnSpanAttribute(boolean asName) {
        return asName ? "layout:span" : "layout_span";
    }

    @Override
    protected String getRowAttribute(boolean asName) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getRowSpanAttribute(boolean asName) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected RadComponent getContainer() {
        return this.myComponent.getParent().getParent();
    }

    @Override
    protected Point getCellInfo() {
        RadTableLayoutComponent tableComponent = (RadTableLayoutComponent)this.myComponent.getParent().getParent();
        GridInfo gridInfo = tableComponent.getVirtualGridInfo();
        int row = tableComponent.getChildren().indexOf((Object)this.myComponent.getParent());
        int column = ArrayUtil.indexOf((Object[])gridInfo.components[row], (Object)((Object)this.myComponent));
        return new Point(column, row);
    }

    public static void points(GridSelectionDecorator decorator) {
        decorator.addPoint(new LayoutSpanOperation.SpanPoint(4, "layout_span", "Change layout:column x layout:span", decorator));
        decorator.addPoint(new LayoutSpanOperation.SpanPoint(8, "layout_span", "Change layout:span", decorator));
    }
}

