/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface.layout.actions;

import com.intellij.android.designer.designSurface.feedbacks.TextFeedback;
import com.intellij.android.designer.designSurface.graphics.DirectionResizePoint;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import com.intellij.android.designer.designSurface.graphics.RectangleFeedback;
import com.intellij.android.designer.designSurface.layout.grid.GridSelectionDecorator;
import com.intellij.android.designer.model.RadComponentOperations;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.grid.GridInfo;
import com.intellij.android.designer.model.grid.IGridProvider;
import com.intellij.designer.designSurface.DecorationLayer;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.feedbacks.AlphaFeedback;
import com.intellij.designer.designSurface.feedbacks.LineMarginBorder;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.IntArrayList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class LayoutSpanOperation
implements EditOperation {
    public static final String TYPE = "layout_span";
    protected static final Color COLOR = JBColor.GREEN.darker();
    protected final OperationContext myContext;
    private final GridSelectionDecorator myDecorator;
    protected RadViewComponent myComponent;
    private RectangleFeedback myFeedback;
    private TextFeedback myTextFeedback;
    private ErrorFeedback myErrorFeedback;
    private Rectangle myBounds;
    private Rectangle myContainerBounds;
    private boolean myShowErrorFeedback;
    protected int mySpan;
    private int[] mySpans;
    private int[] myOffsets;
    private int[] myCells;
    private int myIndex = -1;

    public LayoutSpanOperation(OperationContext context, GridSelectionDecorator decorator) {
        this.myContext = context;
        this.myDecorator = decorator;
    }

    @Override
    public void setComponent(RadComponent component) {
        this.myComponent = (RadViewComponent)component;
        this.myBounds = this.myDecorator.getCellBounds(this.myContext.getArea().getFeedbackLayer(), this.myComponent);
    }

    @Override
    public void setComponents(List<RadComponent> components) {
    }

    protected void createFeedback() {
        if (this.myFeedback == null) {
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            this.myTextFeedback = new TextFeedback();
            this.myTextFeedback.setBorder(new LineMarginBorder(0, 5, 3, 0));
            layer.add((Component)((Object)this.myTextFeedback));
            this.myFeedback = new RectangleFeedback(DrawingStyle.RESIZE_PREVIEW);
            layer.add(this.myFeedback);
            this.myErrorFeedback = new ErrorFeedback();
            layer.add(this.myErrorFeedback);
            layer.repaint();
        }
    }

    @Override
    public void showFeedback() {
        this.createFeedback();
        int direction = this.myContext.getResizeDirection();
        if (direction == 4 || direction == 8) {
            this.handleColumns(direction == 8);
        } else {
            this.handleRows(direction == 2);
        }
    }

    @Override
    public void eraseFeedback() {
        if (this.myFeedback != null) {
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            layer.remove((Component)((Object)this.myTextFeedback));
            layer.remove(this.myFeedback);
            layer.remove(this.myErrorFeedback);
            layer.repaint();
            this.myTextFeedback = null;
            this.myFeedback = null;
            this.myErrorFeedback = null;
        }
    }

    protected abstract String getColumnAttribute(boolean var1);

    protected abstract String getColumnSpanAttribute(boolean var1);

    protected abstract String getRowAttribute(boolean var1);

    protected abstract String getRowSpanAttribute(boolean var1);

    private void handleRows(boolean bottom) {
        int location;
        this.calculateRows(bottom);
        Rectangle bounds = this.myContext.getTransformedRectangle(this.myBounds);
        int n = location = bottom ? bounds.y + bounds.height : bounds.y;
        if (location < this.myOffsets[0]) {
            this.myIndex = 0;
            this.myErrorFeedback.setVisible(!bottom && this.myShowErrorFeedback);
        } else {
            this.myIndex = -1;
            for (int i = 0; i < this.myOffsets.length - 1; ++i) {
                if (this.myOffsets[i] > location || location > this.myOffsets[i + 1]) continue;
                int delta2 = this.myOffsets[i + 1] - location;
                int delta1 = location - this.myOffsets[i];
                this.myIndex = delta2 >= delta1 ? i : i + 1;
                break;
            }
            if (this.myIndex == -1) {
                this.myIndex = this.myOffsets.length - 1;
                this.myErrorFeedback.setVisible(bottom && this.myShowErrorFeedback);
            } else {
                this.myErrorFeedback.setVisible(false);
            }
        }
        if (bottom) {
            this.myFeedback.setBounds(this.myBounds.x, this.myBounds.y, this.myBounds.width, this.myOffsets[this.myIndex] - this.myBounds.y);
        } else {
            this.myFeedback.setBounds(this.myBounds.x, this.myOffsets[this.myIndex], this.myBounds.width, this.myBounds.y + this.myBounds.height - this.myOffsets[this.myIndex]);
        }
        this.myTextFeedback.clear();
        if (!bottom) {
            this.myTextFeedback.append(this.getRowAttribute(true));
            this.myTextFeedback.append(" ");
            this.myTextFeedback.append(Integer.toString(this.myCells[this.myIndex]));
            this.myTextFeedback.append(", ");
        }
        this.myTextFeedback.append(this.getRowSpanAttribute(true));
        this.myTextFeedback.append(" ");
        this.myTextFeedback.append(Integer.toString(this.mySpans[this.myIndex]));
        this.myTextFeedback.centerTop(this.myContainerBounds);
    }

    private void handleColumns(boolean right) {
        int location;
        this.calculateColumns(right);
        Rectangle bounds = this.myContext.getTransformedRectangle(this.myBounds);
        int n = location = right ? bounds.x + bounds.width : bounds.x;
        if (location < this.myOffsets[0]) {
            this.myIndex = 0;
            this.myErrorFeedback.setVisible(!right && this.myShowErrorFeedback);
        } else {
            this.myIndex = -1;
            for (int i = 0; i < this.myOffsets.length - 1; ++i) {
                if (this.myOffsets[i] > location || location > this.myOffsets[i + 1]) continue;
                int delta2 = this.myOffsets[i + 1] - location;
                int delta1 = location - this.myOffsets[i];
                this.myIndex = delta2 >= delta1 ? i : i + 1;
                break;
            }
            if (this.myIndex == -1) {
                this.myIndex = this.myOffsets.length - 1;
                this.myErrorFeedback.setVisible(right && this.myShowErrorFeedback);
            } else {
                this.myErrorFeedback.setVisible(false);
            }
        }
        if (right) {
            this.myFeedback.setBounds(this.myBounds.x, this.myBounds.y, this.myOffsets[this.myIndex] - this.myBounds.x, this.myBounds.height);
        } else {
            this.myFeedback.setBounds(this.myOffsets[this.myIndex], this.myBounds.y, this.myBounds.x + this.myBounds.width - this.myOffsets[this.myIndex], this.myBounds.height);
        }
        this.myTextFeedback.clear();
        if (!right) {
            this.myTextFeedback.append(this.getColumnAttribute(true));
            this.myTextFeedback.append(" ");
            this.myTextFeedback.append(Integer.toString(this.myCells[this.myIndex]));
            this.myTextFeedback.append(", ");
        }
        this.myTextFeedback.append(this.getColumnSpanAttribute(true));
        this.myTextFeedback.append(" ");
        this.myTextFeedback.append(Integer.toString(this.mySpans[this.myIndex]));
        this.myTextFeedback.centerTop(this.myContainerBounds);
    }

    protected RadComponent getContainer() {
        return this.myComponent.getParent();
    }

    protected abstract Point getCellInfo();

    private void calculateRows(boolean bottom) {
        if (this.mySpans != null) {
            return;
        }
        RadComponent container = this.getContainer();
        GridInfo gridInfo = ((IGridProvider)((Object)container)).getVirtualGridInfo();
        RadComponent[][] components = gridInfo.components;
        Point cellInfo = this.getCellInfo();
        int row = cellInfo.y;
        FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
        this.myContainerBounds = container.getBounds(layer);
        IntArrayList spans = new IntArrayList();
        IntArrayList offsets = new IntArrayList();
        if (bottom) {
            int i;
            int span = 1;
            for (i = row; i < row + this.mySpan; ++i) {
                spans.add(span++);
                offsets.add(this.myContainerBounds.y + gridInfo.getCellPosition((Component)layer, (int)(i + 1), (int)0).y);
            }
            for (i = row + this.mySpan; i < components.length; ++i) {
                if (components[i][cellInfo.x] != null) {
                    this.myErrorFeedback.setBounds(this.myDecorator.getCellBounds(layer, components[i][cellInfo.x]));
                    this.myShowErrorFeedback = true;
                    break;
                }
                spans.add(span++);
                offsets.add(this.myContainerBounds.y + gridInfo.getCellPosition((Component)layer, (int)(i + 1), (int)0).y);
            }
        } else {
            int i;
            IntArrayList columns = new IntArrayList();
            int span = this.mySpan;
            for (i = row; i < row + this.mySpan; ++i) {
                spans.add(span--);
                offsets.add(this.myContainerBounds.y + gridInfo.getCellPosition((Component)layer, (int)i, (int)0).y);
                columns.add(i);
            }
            span = this.mySpan;
            for (i = row - 1; i >= 0; --i) {
                if (components[i][cellInfo.x] != null) {
                    this.myErrorFeedback.setBounds(this.myDecorator.getCellBounds(layer, components[i][cellInfo.x]));
                    this.myShowErrorFeedback = true;
                    break;
                }
                spans.add(0, ++span);
                offsets.add(0, this.myContainerBounds.y + gridInfo.getCellPosition((Component)layer, (int)i, (int)0).y);
                columns.add(0, i);
            }
            this.myCells = columns.toArray();
        }
        this.mySpans = spans.toArray();
        this.myOffsets = offsets.toArray();
    }

    private void calculateColumns(boolean right) {
        if (this.mySpans != null) {
            return;
        }
        RadComponent container = this.getContainer();
        GridInfo gridInfo = ((IGridProvider)((Object)container)).getVirtualGridInfo();
        Point cellInfo = this.getCellInfo();
        RadComponent[] rowComponents = gridInfo.components[cellInfo.y];
        int column = cellInfo.x;
        FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
        this.myContainerBounds = container.getBounds(layer);
        IntArrayList spans = new IntArrayList();
        IntArrayList offsets = new IntArrayList();
        if (right) {
            int i;
            int span = 1;
            for (i = column; i < column + this.mySpan; ++i) {
                spans.add(span++);
                offsets.add(this.myContainerBounds.x + gridInfo.getCellPosition((Component)layer, (int)0, (int)(i + 1)).x);
            }
            for (i = column + this.mySpan; i < rowComponents.length; ++i) {
                if (rowComponents[i] != null) {
                    this.myErrorFeedback.setBounds(this.myDecorator.getCellBounds(layer, rowComponents[i]));
                    this.myShowErrorFeedback = true;
                    break;
                }
                spans.add(span++);
                offsets.add(this.myContainerBounds.x + gridInfo.getCellPosition((Component)layer, (int)0, (int)(i + 1)).x);
            }
        } else {
            int i;
            IntArrayList columns = new IntArrayList();
            int span = this.mySpan;
            for (i = column; i < column + this.mySpan; ++i) {
                spans.add(span--);
                offsets.add(this.myContainerBounds.x + gridInfo.getCellPosition((Component)layer, (int)0, (int)i).x);
                columns.add(i);
            }
            span = this.mySpan;
            for (i = column - 1; i >= 0; --i) {
                if (rowComponents[i] != null) {
                    this.myErrorFeedback.setBounds(this.myDecorator.getCellBounds(layer, rowComponents[i]));
                    this.myShowErrorFeedback = true;
                    break;
                }
                spans.add(0, ++span);
                offsets.add(0, this.myContainerBounds.x + gridInfo.getCellPosition((Component)layer, (int)0, (int)i).x);
                columns.add(0, i);
            }
            this.myCells = columns.toArray();
        }
        this.mySpans = spans.toArray();
        this.myOffsets = offsets.toArray();
    }

    @Override
    public boolean canExecute() {
        return true;
    }

    @Override
    public void execute() throws Exception {
        if (this.mySpans[this.myIndex] == this.mySpan) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                int direction = LayoutSpanOperation.this.myContext.getResizeDirection();
                if (direction == 4 || direction == 8) {
                    LayoutSpanOperation.this.execute(LayoutSpanOperation.this.getColumnAttribute(false), LayoutSpanOperation.this.getColumnSpanAttribute(false), direction == 4);
                } else {
                    LayoutSpanOperation.this.execute(LayoutSpanOperation.this.getRowAttribute(false), LayoutSpanOperation.this.getRowSpanAttribute(false), direction == 1);
                }
            }
        });
    }

    private void execute(String cell, String span, boolean cellFix) {
        int spanValue;
        XmlTag tag = this.myComponent.getTag();
        if (cellFix) {
            tag.setAttribute(cell, "http://schemas.android.com/apk/res/android", Integer.toString(this.myCells[this.myIndex]));
        }
        if ((spanValue = this.mySpans[this.myIndex]) == 1) {
            RadComponentOperations.deleteAttribute(tag, span);
        } else {
            tag.setAttribute(span, "http://schemas.android.com/apk/res/android", Integer.toString(spanValue));
        }
    }

    protected static class SpanPoint
    extends DirectionResizePoint {
        private final GridSelectionDecorator myDecorator;

        public SpanPoint(int direction, Object type, @Nullable String description, GridSelectionDecorator decorator) {
            super(DrawingStyle.RESIZE_SPAN, direction, type, description);
            this.myDecorator = decorator;
        }

        @Override
        protected Rectangle getBounds(DecorationLayer layer, RadComponent component) {
            return this.myDecorator.getCellBounds(layer, component);
        }
    }

    private static class ErrorFeedback
    extends AlphaFeedback {
        public ErrorFeedback() {
            super((Color)JBColor.PINK);
        }

        @Override
        protected void paintOther1(Graphics2D g2d) {
        }

        @Override
        protected void paintOther2(Graphics2D g2d) {
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

