/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface.layout;

import com.intellij.android.designer.designSurface.layout.grid.GridOperation;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.grid.GridInfo;
import com.intellij.android.designer.model.grid.GridInsertType;
import com.intellij.android.designer.model.layout.grid.RadGridLayoutComponent;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.model.RadComponent;
import java.awt.Rectangle;
import org.jetbrains.annotations.Nullable;

public class GridLayoutOperation
extends GridOperation {
    public GridLayoutOperation(RadComponent container, OperationContext context) {
        super(container, context);
    }

    @Override
    protected int getMovedIndex(boolean row) {
        RadComponent movedComponent = this.myContext.getComponents().get(0);
        Rectangle movedCellInfo = RadGridLayoutComponent.getCellInfo(movedComponent);
        return row ? movedCellInfo.y : movedCellInfo.x;
    }

    @Override
    protected boolean isSingleMovedAxis(boolean row) {
        RadComponent movedComponent = this.myContext.getComponents().get(0);
        Rectangle movedCellInfo = RadGridLayoutComponent.getCellInfo(movedComponent);
        if (row) {
            for (int i = 0; i < movedCellInfo.height; ++i) {
                if (this.getSizeInRow(movedCellInfo.y + i, movedComponent) <= 0) continue;
                return false;
            }
        } else {
            GridInfo gridInfo = this.getGridInfo();
            for (int i = 0; i < movedCellInfo.width; ++i) {
                if (this.getSizeInColumn(movedCellInfo.x + i, gridInfo.columnCount, movedComponent) <= 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void execute() throws Exception {
        GridInfo gridInfo = this.getGridInfo();
        RadGridLayoutComponent container = (RadGridLayoutComponent)this.myContainer;
        RadComponent[][] components = container.getGridComponents(false);
        RadComponent editComponent = (RadComponent)((Object)this.myComponents.get(0));
        if (this.myInsertType == GridInsertType.in_cell && (this.myRow >= gridInfo.rowCount || this.myColumn >= gridInfo.columnCount)) {
            GridLayoutOperation.execute(this.myContext, container, this.myComponents, null);
            RadGridLayoutComponent.setCellIndex(editComponent, this.myRow, this.myColumn, true, true);
            return;
        }
        RadViewComponent nextComponent = GridLayoutOperation.getNextComponent(components, this.myRow, this.myColumn);
        if (this.myInsertType == GridInsertType.in_cell) {
            if (!this.myContext.isMove()) {
                GridLayoutOperation.execute(this.myContext, container, this.myComponents, nextComponent);
                RadGridLayoutComponent.setCellIndex(editComponent, this.myRow, this.myColumn, true, true);
                return;
            }
            components = this.insertComponent(components, nextComponent, false, false, false, false);
        } else {
            components = this.myInsertType == GridInsertType.before_h_cell || this.myInsertType == GridInsertType.after_h_cell ? this.insertComponent(components, nextComponent, true, this.myInsertType == GridInsertType.after_h_cell, false, false) : (this.myInsertType == GridInsertType.before_v_cell || this.myInsertType == GridInsertType.after_v_cell ? this.insertComponent(components, nextComponent, false, false, true, this.myInsertType == GridInsertType.after_v_cell) : this.insertComponent(components, nextComponent, true, this.myInsertType == GridInsertType.corner_bottom_left || this.myInsertType == GridInsertType.corner_bottom_right, true, this.myInsertType == GridInsertType.corner_top_right || this.myInsertType == GridInsertType.corner_bottom_right));
        }
        GridLayoutOperation.validateLayoutParams(components);
    }

    public static void validateLayoutParams(RadComponent[][] components) throws Exception {
        for (int i = 0; i < components.length; ++i) {
            RadComponent[] rowComponents = components[i];
            for (int j = 0; j < rowComponents.length; ++j) {
                RadComponent cellComponent = rowComponents[j];
                if (cellComponent == null) continue;
                RadGridLayoutComponent.setCellIndex(cellComponent, i, j, false, false);
            }
        }
    }

    private RadComponent[][] insertComponent(RadComponent[][] components, RadViewComponent nextComponent, boolean insertRow, boolean afterRow, boolean insertColumn, boolean afterColumn) throws Exception {
        RadComponent editComponent = (RadComponent)((Object)this.myComponents.get(0));
        if (this.myContext.isMove()) {
            Rectangle cellInfo = RadGridLayoutComponent.getCellInfo(editComponent);
            if (cellInfo.y < components.length && cellInfo.x < components[cellInfo.y].length) {
                components[cellInfo.y][cellInfo.x] = null;
            }
            RadGridLayoutComponent.clearCellSpans(editComponent);
        }
        int row = this.myRow;
        if (insertRow && afterRow) {
            ++row;
        }
        int column = this.myColumn;
        if (insertColumn && afterColumn) {
            ++column;
        }
        GridInfo gridInfo = this.getGridInfo();
        if (insertRow) {
            GridLayoutOperation.shiftRowSpan(gridInfo, row, 1);
        }
        if (insertColumn) {
            GridLayoutOperation.shiftColumnSpan(gridInfo, column, 1);
        }
        if (insertRow) {
            components = GridLayoutOperation.insertRow(components, row);
        }
        if (insertColumn) {
            GridLayoutOperation.insertColumn(components, column);
        }
        components[row][column] = editComponent;
        if (editComponent != nextComponent) {
            GridLayoutOperation.execute(this.myContext, (RadGridLayoutComponent)this.myContainer, this.myComponents, nextComponent);
        }
        return components;
    }

    public static void shiftRowSpan(GridInfo gridInfo, int row, int inc) {
        if (row >= gridInfo.rowCount - 1) {
            return;
        }
        RadComponent[] rowComponents = gridInfo.components[row];
        RadComponent[] rowComponents1 = gridInfo.components[row + 1];
        for (int i = 0; i < rowComponents.length; ++i) {
            RadComponent cellComponent = rowComponents[i];
            if (cellComponent == null) continue;
            if (cellComponent == rowComponents1[i]) {
                RadGridLayoutComponent.setSpan(cellComponent, RadGridLayoutComponent.getSpan(cellComponent, true) + inc, true);
            }
            while (i + 1 < rowComponents.length && cellComponent == rowComponents[i + 1]) {
                ++i;
            }
        }
    }

    private static RadComponent[][] insertRow(RadComponent[][] components, int row) {
        RadComponent[][] newComponents = new RadComponent[components.length + 1][];
        System.arraycopy(components, 0, newComponents, 0, row);
        System.arraycopy(components, row, newComponents, row + 1, components.length - row);
        newComponents[row] = new RadComponent[components[0].length];
        return newComponents;
    }

    public static void shiftColumnSpan(GridInfo gridInfo, int column, int inc) {
        if (column >= gridInfo.columnCount - 1) {
            return;
        }
        RadComponent[][] components = gridInfo.components;
        for (int i = 0; i < components.length; ++i) {
            RadComponent[] rowComponents = components[i];
            RadComponent cellComponent = rowComponents[column];
            if (cellComponent == null) continue;
            if (cellComponent == rowComponents[column + 1]) {
                RadGridLayoutComponent.setSpan(cellComponent, RadGridLayoutComponent.getSpan(cellComponent, false) + inc, false);
            }
            while (i + 1 < components.length && cellComponent == components[i + 1][column]) {
                ++i;
            }
        }
    }

    private static void insertColumn(RadComponent[][] components, int column) {
        for (int i = 0; i < components.length; ++i) {
            RadComponent[] rowComponents = components[i];
            RadComponent[] newRowComponents = new RadComponent[rowComponents.length + 1];
            System.arraycopy(rowComponents, 0, newRowComponents, 0, column);
            System.arraycopy(rowComponents, column, newRowComponents, column + 1, rowComponents.length - column);
            components[i] = newRowComponents;
        }
    }

    @Nullable
    public static RadViewComponent getNextComponent(RadComponent[][] components, int row, int column) {
        int i;
        RadComponent[] rowComponents = components[row];
        for (i = column + 1; i < rowComponents.length; ++i) {
            RadComponent component = rowComponents[i];
            if (component == null) continue;
            return (RadViewComponent)component;
        }
        for (i = row + 1; i < components.length; ++i) {
            for (RadComponent component : components[i]) {
                if (component == null) continue;
                return (RadViewComponent)component;
            }
        }
        return null;
    }
}

