/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.wizard.AndroidStudioWizardStep;
import com.android.tools.idea.wizard.TemplateWizardStep;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import icons.AndroidIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateWizard
extends AbstractWizard<ModuleWizardStep> {
    public static final String MAIN_FLAVOR_SOURCE_PATH = "src" + File.separator + "main";
    public static final String TEST_SOURCE_PATH = "src" + File.separator + "androidTest";
    public static final String JAVA_SOURCE_PATH = "java";
    public static final String RESOURCE_SOURCE_PATH = "res";
    public static final String AIDL_SOURCE_PATH = "aidl";
    public static final String MAVEN_URL_PROPERTY = "android.mavenRepoUrl";
    protected Project myProject;

    public TemplateWizard(@NotNull String title, @Nullable Project project) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/TemplateWizard", "<init>"));
        }
        super(title, project);
        this.myProject = project;
    }

    public void update() {
        this.updateButtons();
    }

    protected void init() {
        super.init();
        int currentStep = this.getCurrentStep();
        if (currentStep >= this.mySteps.size()) {
            return;
        }
        ModuleWizardStep step = (ModuleWizardStep)this.mySteps.get(currentStep);
        if (step instanceof TemplateWizardStep) {
            ((TemplateWizardStep)step).update();
        }
    }

    protected boolean canGoNext() {
        if (this.mySteps.isEmpty()) {
            return false;
        }
        ModuleWizardStep step = (ModuleWizardStep)this.mySteps.get(this.getCurrentStep());
        return !(step instanceof AndroidStudioWizardStep) || ((AndroidStudioWizardStep)step).isValid();
    }

    @Nullable
    protected String getHelpID() {
        return null;
    }

    protected final int getNextStep(int step) {
        for (int i = step + 1; i < this.mySteps.size(); ++i) {
            if (!this.isStepVisible((ModuleWizardStep)this.mySteps.get(i))) continue;
            return i;
        }
        return step;
    }

    protected boolean isStepVisible(ModuleWizardStep page) {
        return page.isStepVisible();
    }

    protected final int getPreviousStep(int step) {
        for (int i = step - 1; i >= 0; --i) {
            if (!this.isStepVisible((ModuleWizardStep)this.mySteps.get(i))) continue;
            return i;
        }
        return step;
    }

    public Icon getSidePanelIcon() {
        return AndroidIcons.Wizards.NewModuleSidePanel;
    }

    @Nullable
    protected static Sdk getSdk(int apiLevel) {
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            AndroidSdkData sdkData;
            IAndroidTarget target;
            AndroidPlatform androidPlatform = AndroidPlatform.parse(sdk);
            if (androidPlatform == null || (target = (sdkData = androidPlatform.getSdkData()).findTargetByApiLevel(Integer.toString(apiLevel))) == null) continue;
            return sdk;
        }
        return null;
    }

    protected void updateStep() {
        if (!this.mySteps.isEmpty()) {
            ((ModuleWizardStep)this.getCurrentStepObject()).updateStep();
        }
        super.updateStep();
    }
}

