/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.gradle.project.ModuleImporter;
import com.android.tools.idea.gradle.project.ModuleToImport;
import com.android.tools.idea.wizard.AndroidStudioWizardStep;
import com.android.tools.idea.wizard.AsyncValidator;
import com.android.tools.idea.wizard.ImportUIUtil;
import com.android.tools.idea.wizard.ModulesTable;
import com.android.tools.idea.wizard.NewModuleWizardState;
import com.android.tools.idea.wizard.TemplateWizardStep;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportSourceLocationStep
extends ModuleWizardStep
implements AndroidStudioWizardStep {
    private static final int VALIDATION_STATUS_DISPLAY_DELAY = 50;
    private final Logger LOG;
    private final NewModuleWizardState myState;
    private final Timer myDelayedValidationProgressDisplay;
    @NotNull
    private final TemplateWizardStep.UpdateListener myUpdateListener;
    @NotNull
    private final WizardContext myContext;
    private JPanel myPanel;
    private TextFieldWithBrowseButton mySourceLocation;
    private JBLabel myErrorWarning;
    private ModulesTable myModulesList;
    private JBLabel myModuleImportLabel;
    private AsyncProcessIcon myValidationProgress;
    private JBLabel myLocationLabel;
    private AsyncValidator<?> validator;
    private PathValidationResult myPageValidationResult;
    private boolean myValidating;
    private PageStatus myStatus;
    private Icon mySidePanelIcon;

    public ImportSourceLocationStep(@NotNull WizardContext context, @Nullable VirtualFile importSource, @NotNull NewModuleWizardState state, @Nullable Icon sidePanelIcon, @Nullable TemplateWizardStep.UpdateListener listener) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ImportSourceLocationStep", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/wizard/ImportSourceLocationStep", "<init>"));
        }
        this.$$$setupUI$$$();
        this.LOG = Logger.getInstance(ImportSourceLocationStep.class);
        this.myValidating = false;
        this.myContext = context;
        this.mySidePanelIcon = sidePanelIcon;
        this.myUpdateListener = listener == null ? new TemplateWizardStep.UpdateListener(){

            @Override
            public void update() {
            }
        } : listener;
        this.myState = state;
        PropertyChangeListener modulesListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedModules".equals(evt.getPropertyName())) {
                    ImportSourceLocationStep.this.updateStepStatus(ImportSourceLocationStep.this.myPageValidationResult);
                }
            }
        };
        this.myModulesList.addPropertyChangeListener("selectedModules", modulesListener);
        this.validator = new AsyncValidator<PathValidationResult>(ApplicationManager.getApplication()){

            @Override
            protected void showValidationResult(PathValidationResult result) {
                ImportSourceLocationStep.this.applyBackgroundOperationResult(result);
            }

            @Override
            @NotNull
            protected PathValidationResult validate() {
                PathValidationResult pathValidationResult = ImportSourceLocationStep.this.checkPath(ImportSourceLocationStep.this.mySourceLocation.getText());
                if (pathValidationResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ImportSourceLocationStep$3", "validate"));
                }
                return pathValidationResult;
            }
        };
        this.myErrorWarning.setText("");
        this.myErrorWarning.setIcon(null);
        this.setupSourceLocationControls(importSource);
        this.myDelayedValidationProgressDisplay = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ImportSourceLocationStep.this.myValidating) {
                    ImportSourceLocationStep.this.updateStatusDisplay(PageStatus.VALIDATING, null);
                }
            }
        });
    }

    private static String multiLineJLabelText(String ... messages) {
        StringBuilder builder = new StringBuilder("<html><body><p>");
        Joiner.on((String)"<br>").appendTo(builder, (Object[])messages);
        builder.append("</p></body></html>");
        return builder.toString();
    }

    public Icon getIcon() {
        return this.mySidePanelIcon;
    }

    private void setupSourceLocationControls(@Nullable VirtualFile importSource) {
        if (importSource == null) {
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor();
            descriptor.setTitle("Select Source Location");
            descriptor.setDescription("Select existing ADT or Gradle project to import as a new subproject");
            this.mySourceLocation.addBrowseFolderListener(new TextBrowseFolderListener(descriptor));
            this.mySourceLocation.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    ImportSourceLocationStep.this.invalidate();
                }
            });
        } else {
            this.mySourceLocation.setVisible(false);
            this.myLocationLabel.setVisible(false);
            this.mySourceLocation.setText(importSource.getPath());
        }
        this.applyBackgroundOperationResult(this.checkPath(this.mySourceLocation.getText()));
    }

    private void updateStatusDisplay(@NotNull PageStatus status, @Nullable Object details) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ImportSourceLocationStep", "updateStatusDisplay"));
        }
        this.myValidationProgress.setVisible(status.isSpinnerVisible());
        this.myErrorWarning.setText(status.getMessage(details));
        this.myErrorWarning.setIcon(status.getIcon());
        this.myModulesList.setEnabled(!status.isSpinnerVisible());
        this.myUpdateListener.update();
    }

    private void invalidate() {
        if (!this.myDelayedValidationProgressDisplay.isRunning()) {
            this.myDelayedValidationProgressDisplay.start();
        }
        this.myValidating = true;
        this.validator.invalidate();
    }

    private void applyBackgroundOperationResult(@NotNull PathValidationResult result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ImportSourceLocationStep", "applyBackgroundOperationResult"));
        }
        assert (EventQueue.isDispatchThread());
        Set<ModuleToImport> modules = null;
        try {
            if (result.myStatus == PageStatus.OK) {
                assert (result.myVfile != null && this.myContext.getProject() != null && result.myImporter != null);
                modules = result.myImporter.findModules(result.myVfile);
                TreeSet<String> missingSourceModuleNames = new TreeSet<String>();
                for (ModuleToImport module : modules) {
                    if (module.location != null && module.location.exists()) continue;
                    missingSourceModuleNames.add(module.name);
                }
                if (!missingSourceModuleNames.isEmpty()) {
                    result = new PathValidationResult(PageStatus.MISSING_SUBPROJECTS, result.myVfile, result.myImporter, missingSourceModuleNames);
                }
            }
        }
        catch (IOException e) {
            this.LOG.error((Throwable)e);
            result = PageStatus.INTERNAL_ERROR.result();
        }
        this.myValidating = false;
        this.refreshModulesList(result.myVfile, modules);
        ModuleImporter.setImporter(this.myContext, result.myImporter);
        this.updateStepStatus(result);
    }

    private void updateStepStatus(PathValidationResult result) {
        Object validationDetails = result.myDetails;
        PageStatus status = result.myStatus;
        Map<String, VirtualFile> selectedModules = Collections.emptyMap();
        if (!MessageType.ERROR.equals(status.severity)) {
            List<ModuleToImport> modules = this.myModulesList.getSelectedModules();
            if (modules.isEmpty()) {
                status = PageStatus.NO_MODULES_SELECTED;
                validationDetails = null;
            } else {
                selectedModules = new HashMap<String, VirtualFile>(modules.size());
                for (ModuleToImport module : modules) {
                    selectedModules.put(module.name, module.location);
                }
            }
        }
        this.myState.setModulesToImport(selectedModules);
        this.myPageValidationResult = result;
        this.updateStatusDisplay(status, validationDetails);
        this.myStatus = status;
        this.myUpdateListener.update();
    }

    private void refreshModulesList(@Nullable VirtualFile vfile, @Nullable Iterable<ModuleToImport> modules) {
        boolean hasModules = modules != null && Iterables.size(modules) > 1;
        this.myModulesList.setVisible(hasModules);
        this.myModuleImportLabel.setVisible(hasModules);
        this.myModulesList.setModules(this.myContext.getProject(), vfile, modules);
    }

    private void createUIComponents() {
        this.myValidationProgress = new AsyncProcessIcon("validation");
        this.myValidationProgress.setVisible(false);
    }

    public boolean validate() {
        return this.myStatus.severity != MessageType.ERROR && !this.myValidating;
    }

    @Override
    public boolean isValid() {
        return this.validate();
    }

    @NotNull
    protected PathValidationResult checkPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ImportSourceLocationStep", "checkPath"));
        }
        if (Strings.isNullOrEmpty((String)(path = path.trim()))) {
            PathValidationResult pathValidationResult = PageStatus.EMPTY_PATH.result();
            if (pathValidationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ImportSourceLocationStep", "checkPath"));
            }
            return pathValidationResult;
        }
        VirtualFile vfile = VfsUtil.findFileByIoFile((File)new File(path), (boolean)false);
        if (vfile == null || !vfile.exists()) {
            PathValidationResult pathValidationResult = PageStatus.DOES_NOT_EXIST.result();
            if (pathValidationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ImportSourceLocationStep", "checkPath"));
            }
            return pathValidationResult;
        }
        if (this.isProjectOrModule(vfile)) {
            PathValidationResult pathValidationResult = PageStatus.IS_PROJECT_OR_MODULE.result();
            if (pathValidationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ImportSourceLocationStep", "checkPath"));
            }
            return pathValidationResult;
        }
        ModuleImporter kind = ModuleImporter.importerForLocation(this.myContext, vfile);
        if (!kind.isValid()) {
            PathValidationResult pathValidationResult = PageStatus.NOT_ADT_OR_GRADLE.result();
            if (pathValidationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ImportSourceLocationStep", "checkPath"));
            }
            return pathValidationResult;
        }
        PathValidationResult pathValidationResult = new PathValidationResult(PageStatus.OK, vfile, kind, null);
        if (pathValidationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ImportSourceLocationStep", "checkPath"));
        }
        return pathValidationResult;
    }

    private boolean isProjectOrModule(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ImportSourceLocationStep", "isProjectOrModule"));
        }
        Project project = this.myContext.getProject();
        if (project != null) {
            if (dir.equals(project.getBaseDir())) {
                return true;
            }
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                VirtualFile moduleFile = module.getModuleFile();
                if (moduleFile == null || !dir.equals(moduleFile.getParent())) continue;
                return true;
            }
        }
        return false;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void updateDataModel() {
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySourceLocation.getTextField();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ModulesTable modulesTable;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel3;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myLocationLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Source directory:");
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        this.mySourceLocation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 1, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myErrorWarning = jBLabel2 = new JBLabel();
        jBLabel2.setText("An error or warning");
        jPanel.add((Component)jBLabel2, new GridConstraints(4, 2, 1, 1, 0, 1, 6, 0, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myValidationProgress;
        jPanel.add((Component)asyncProcessIcon, new GridConstraints(4, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myModuleImportLabel = jBLabel = new JBLabel();
        jBLabel.setText("Modules found:");
        jPanel.add((Component)jBLabel, new GridConstraints(2, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myModulesList = modulesTable = new ModulesTable();
        jPanel.add((Component)((Object)modulesTable), new GridConstraints(3, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText(" ");
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    static final class PathValidationResult {
        @NotNull
        public final PageStatus myStatus;
        @Nullable
        public final VirtualFile myVfile;
        @Nullable
        public final ModuleImporter myImporter;
        @Nullable
        public final Object myDetails;

        private PathValidationResult(@NotNull PageStatus status, @Nullable VirtualFile vfile, @Nullable ModuleImporter importer, @Nullable Object details) {
            if (status == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ImportSourceLocationStep$PathValidationResult", "<init>"));
            }
            this.myStatus = status;
            this.myVfile = vfile;
            this.myImporter = importer;
            this.myDetails = details;
        }
    }

    static enum PageStatus {
        OK(null, null),
        EMPTY_PATH("Path is empty", MessageType.ERROR),
        DOES_NOT_EXIST("Path does not exist", MessageType.ERROR),
        IS_PROJECT_OR_MODULE("This location is already imported", MessageType.ERROR),
        MISSING_SUBPROJECTS("Some projects were not found", MessageType.WARNING),
        NO_MODULES_SELECTED("Select modules to import", MessageType.ERROR),
        NOT_ADT_OR_GRADLE("Specify location of the Gradle or Android Eclipse project", MessageType.ERROR),
        INTERNAL_ERROR("Internal error, please check the IDE log", MessageType.ERROR),
        VALIDATING("Validating", null);

        @Nullable
        public final MessageType severity;
        @Nullable
        private final String message;

        private PageStatus(String message, MessageType severity) {
            this.message = message;
            this.severity = severity;
        }

        public PathValidationResult result() {
            return new PathValidationResult(this, null, null, null);
        }

        @Nullable
        public Icon getIcon() {
            return this.severity == null ? null : this.severity.getDefaultIcon();
        }

        public boolean isSpinnerVisible() {
            return this == VALIDATING;
        }

        public String getMessage(@Nullable Object details) {
            if (this == MISSING_SUBPROJECTS && details instanceof Collection) {
                String message = ImportUIUtil.formatElementListString((Collection)details, "Unable to find sources for subproject %1$s.", "Unable to find sources for subprojects %1$s and %2$s.", "Unable to find sources for %1$s and %2$d more subprojects.");
                return ImportSourceLocationStep.multiLineJLabelText(new String[]{message, "This may result in missing dependencies."});
            }
            return Strings.nullToEmpty((String)this.message);
        }
    }
}

