/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.sdk.DefaultSdks;
import com.android.tools.idea.wizard.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.platform.templates.github.Outcome;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.concurrent.Callable;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GetSdkStep
extends DynamicWizardStepWithHeaderAndDescription {
    private static final Logger LOG = Logger.getInstance(GetSdkStep.class);
    private static final String MAC_SDK_URL = "http://dl.google.com/android/android-sdk_r22.6.2-macosx.zip";
    private static final String LINUX_SDK_URL = "http://dl.google.com/android/android-sdk_r22.6.2-linux.tgz";
    private static final String WINDOWS_SDK_URL = "http://dl.google.com/android/android-sdk_r22.6.2-windows.zip";
    private TextFieldWithBrowseButton mySdkLocationField;
    private JPanel myPanel;
    private JButton myDownloadANewSDKButton;
    private static final ScopedStateStore.Key<String> SDK_PATH_KEY = ScopedStateStore.createKey("sdkPath", ScopedStateStore.Scope.STEP, String.class);

    public GetSdkStep(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/GetSdkStep", "<init>"));
        }
        super("SDK Setup", "You may use an existing SDK or download a new one", null, parentDisposable);
        this.$$$setupUI$$$();
        this.setBodyComponent(this.myPanel);
    }

    @Override
    public void init() {
        this.register(SDK_PATH_KEY, this.mySdkLocationField);
        File androidHome = DefaultSdks.getDefaultAndroidHome();
        if (androidHome != null) {
            this.myState.put(SDK_PATH_KEY, androidHome.getPath());
        }
        this.mySdkLocationField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String path = GetSdkStep.this.getSdkPath(GetSdkStep.this.mySdkLocationField.getText());
                GetSdkStep.this.mySdkLocationField.setText(path == null ? "" : path);
            }
        });
        this.myDownloadANewSDKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String sdkPath = GetSdkStep.this.getSaveLocation((String)GetSdkStep.this.myState.get(SDK_PATH_KEY));
                if (sdkPath != null) {
                    boolean success = GetSdkStep.this.downloadSdkToPath(sdkPath);
                    if (success) {
                        GetSdkStep.this.myState.put(SDK_PATH_KEY, sdkPath);
                    } else {
                        GetSdkStep.this.setErrorHtml("Download failed, please try again.");
                    }
                }
            }
        });
        super.init();
    }

    private boolean downloadSdkToPath(@NotNull String sdkPath) {
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/GetSdkStep", "downloadSdkToPath"));
        }
        File outputFile = new File(sdkPath);
        File parentDir = outputFile.getParentFile();
        if (parentDir == null) {
            this.setErrorHtml("You may not choose an empty (or root) path as an output directory");
            return false;
        }
        final File tempZipFile = new File(parentDir, outputFile.getName() + ".zip");
        Outcome outcome = DownloadUtil.provideDataWithProgressSynchronously(null, (String)"Installing SDK", (String)"Downloading SDK Archive${content-length} ...", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                String downloadUrl = GetSdkStep.this.getDownloadUrl();
                if (downloadUrl == null) {
                    GetSdkStep.this.setErrorHtml("We cannot recognize your OS. Please visit http://developer.android.com/sdk/index.html and selectthe appropriate SDK bundle.");
                    return tempZipFile;
                }
                DownloadUtil.downloadAtomically((ProgressIndicator)progress, (String)downloadUrl, (File)tempZipFile);
                return tempZipFile;
            }
        }, null);
        Exception e = outcome.getException();
        if (e != null) {
            this.setErrorHtml("Could not download SDK: " + e.getMessage());
            return false;
        }
        try {
            ZipUtil.unzipWithProgressSynchronously(null, (String)"Extracting SDK", (File)tempZipFile, (File)outputFile, (boolean)true);
            FileUtil.delete((File)tempZipFile);
        }
        catch (Exception e2) {
            this.setErrorHtml("Installing SDK failed: " + e2.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean commitStep() {
        String sdkPath = this.myState.get(SDK_PATH_KEY);
        if (sdkPath == null) {
            return false;
        }
        final File sdkFile = new File(sdkPath);
        if (!sdkFile.exists() || !((Boolean)AndroidSdkType.validateAndroidSdk(sdkPath).getFirst()).booleanValue()) {
            return false;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                DefaultSdks.setDefaultAndroidHome(sdkFile);
            }
        });
        return true;
    }

    @Override
    public boolean validate() {
        this.setErrorHtml("");
        String path = this.myState.get(SDK_PATH_KEY);
        if (path == null || StringUtil.isEmpty((String)path)) {
            this.setErrorHtml("Android SDK path not specified.");
            return false;
        }
        Pair<Boolean, String> validationResult = AndroidSdkType.validateAndroidSdk(path);
        String error = (String)validationResult.getSecond();
        if (!((Boolean)validationResult.getFirst()).booleanValue()) {
            this.setErrorHtml(String.format("Invalid Android SDK (%1$s): %2$s", path, error));
            return false;
        }
        return true;
    }

    @Override
    public boolean isStepVisible() {
        return DefaultSdks.getDefaultAndroidHome() == null;
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("Find or download SDK" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/GetSdkStep", "getStepName"));
        }
        return "Find or download SDK";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySdkLocationField;
    }

    @Nullable
    private String getSdkPath(@Nullable String currentPath) {
        FileChooserDescriptor chooserDescriptor;
        FileChooserDialogImpl chooser;
        VirtualFile[] files;
        VirtualFile currentFile = null;
        if (currentPath != null && !currentPath.isEmpty()) {
            currentFile = VfsUtil.findFileByIoFile((File)new File(currentPath), (boolean)false);
        }
        if ((files = (chooser = new FileChooserDialogImpl(chooserDescriptor = AndroidSdkType.getInstance().getHomeChooserDescriptor(), (Project)null)).choose(currentFile, null)).length == 0) {
            return null;
        }
        return files[0].getPath();
    }

    @Nullable
    private String getSaveLocation(@Nullable String currentPath) {
        VirtualFile currentFile = null;
        if (currentPath != null && !currentPath.isEmpty()) {
            currentFile = VfsUtil.findFileByIoFile((File)new File(currentPath), (boolean)false);
        }
        FileSaverDescriptor fileSaverDescriptor = new FileSaverDescriptor("SDK location", "Please choose an installation location for your SDK", new String[0]);
        VirtualFileWrapper fileWrapper = FileChooserFactory.getInstance().createSaveFileDialog(fileSaverDescriptor, (Project)null).save(currentFile, "android_sdk");
        if (fileWrapper != null) {
            return fileWrapper.getFile().getPath();
        }
        return null;
    }

    @Nullable
    private String getDownloadUrl() {
        if (SystemInfo.isLinux) {
            return LINUX_SDK_URL;
        }
        if (SystemInfo.isWindows) {
            return WINDOWS_SDK_URL;
        }
        if (SystemInfo.isMac) {
            return MAC_SDK_URL;
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(4, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(2, 3, 1, 1, 0, 1, 7, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("<html>Android Studio requires an installed Android SDK. The SDK contains code libraries and a number of system images for different API levels and form factors. If you have an existing SDK from a previous installation of ADT or Android Studio, you can use that SDK or you can choose to download an SDK bundle that contains the most-used components. You can always use the SDK manager later to add additional components and system images to your SDK installation.</html>");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 4, 0, 0, 1, 0, null, new Dimension(800, -1), new Dimension(800, -1)));
        this.mySdkLocationField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setEnabled(true);
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 2, 1, 1, 8, 0, 6, 0, null, new Dimension(500, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("SDK Location");
        jPanel.add((Component)jBLabel2, new GridConstraints(3, 1, 1, 1, 0, 0, 0, 0, null, null, null, 3));
        this.myDownloadANewSDKButton = jButton = new JButton();
        jButton.setText("Download a new SDK");
        jPanel.add((Component)jButton, new GridConstraints(2, 2, 1, 1, 8, 0, 3, 0, null, new Dimension(500, -1), null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

