/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.wizard.DynamicWizardPath;
import com.android.tools.idea.wizard.ScopedDataBinder;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicWizardStep
extends ScopedDataBinder
implements Step {
    protected DynamicWizardPath myPath;
    private boolean myUpdateInProgress;
    private boolean myIsValid;
    private boolean myInitialized;

    public DynamicWizardStep() {
        this.myState = new ScopedStateStore(ScopedStateStore.Scope.STEP, null, this);
    }

    public final void attachToPath(@NotNull DynamicWizardPath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/DynamicWizardStep", "attachToPath"));
        }
        this.myPath = path;
        Map<String, Object> myCurrentValues = this.myState.flatten();
        this.myState = new ScopedStateStore(ScopedStateStore.Scope.STEP, this.myPath.getState(), this);
        for (String keyName : myCurrentValues.keySet()) {
            this.myState.put(this.myState.createKey(keyName, Object.class), myCurrentValues.get(keyName));
        }
    }

    public abstract void init();

    @Nullable
    protected final Project getProject() {
        return this.myPath != null ? this.myPath.getProject() : null;
    }

    @Nullable
    protected final Module getModule() {
        return this.myPath != null ? this.myPath.getModule() : null;
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Deprecated
    public final void _init() {
        this.onEnterStep();
    }

    @Deprecated
    public final void _commit(boolean finishChosen) throws CommitStepException {
        this.commitStep();
    }

    public void onEnterStep() {
        if (!this.myInitialized) {
            this.init();
            this.myInitialized = true;
        }
        this.invokeUpdate(null);
    }

    public boolean commitStep() {
        return true;
    }

    public boolean isStepVisible() {
        return true;
    }

    @Override
    public <T> void invokeUpdate(@Nullable ScopedStateStore.Key<T> changedKey) {
        super.invokeUpdate(changedKey);
        this.update();
        if (this.myPath != null) {
            this.myPath.updateButtons();
        }
    }

    private void update() {
        if (!this.myUpdateInProgress) {
            this.myUpdateInProgress = true;
            this.updateModelFromUI();
            this.deriveValues(this.myState.getRecentUpdates());
            this.myIsValid = this.validate();
            this.myState.clearRecentUpdates();
            this.myUpdateInProgress = false;
        }
    }

    public void updateModelFromUI() {
    }

    public void deriveValues(Set<ScopedStateStore.Key> modified) {
    }

    public boolean validate() {
        return true;
    }

    public boolean canGoNext() {
        return this.myIsValid;
    }

    public boolean canGoPrevious() {
        return true;
    }

    public final void setErrorHtml(@Nullable String errorMessage) {
        if (errorMessage != null && !errorMessage.startsWith("<html>")) {
            errorMessage = "<html>" + errorMessage + "</html>";
        }
        this.getMessageLabel().setText(errorMessage);
    }

    public String toString() {
        return this.getStepName();
    }

    @NotNull
    public abstract JComponent getComponent();

    @NotNull
    public abstract JLabel getMessageLabel();

    @NotNull
    public abstract String getStepName();
}

