/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.wizard.ChooseApiLevelDialog;
import com.android.tools.idea.wizard.ComboBoxItem;
import com.android.tools.idea.wizard.ConfigureAndroidProjectPath;
import com.android.tools.idea.wizard.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.FormFactorUtils;
import com.android.tools.idea.wizard.ScopedDataBinder;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureFormFactorStep
extends DynamicWizardStepWithHeaderAndDescription {
    public static final String MIN_SDK_STRING = "Minimum SDK";
    private static final ScopedStateStore.Key<String> API_FEEDBACK_KEY = ScopedStateStore.createKey("API Feedback", ScopedStateStore.Scope.STEP, String.class);
    public static final ScopedStateStore.Key<Integer> NUM_ENABLED_FORM_FACTORS_KEY = ScopedStateStore.createKey("NumberOfEnabledFormFactors", ScopedStateStore.Scope.WIZARD, Integer.class);
    private JPanel myPanel;
    private JPanel myFormFactorPanel;
    private JBLabel myHelpMeChooseLabel;
    private List<AndroidTargetComboBoxItem> myTargets;
    private Set<AndroidVersion> myInstalledVersions;
    private List<FormFactorUtils.FormFactor> myFormFactors;
    private ChooseApiLevelDialog myChooseApiLevelDialog;
    private Disposable myDisposable;
    private Map<FormFactorUtils.FormFactor, FormFactorSdkControls> myFormFactorApiSelectors;
    private IAndroidTarget myHighestInstalledApiTarget;
    private Map<FormFactorUtils.FormFactor, IPkgDesc> myInstallRequests;
    private static final ScopedDataBinder.ComponentBinding<AndroidTargetComboBoxItem, JComboBox> TARGET_COMBO_BINDING = new ScopedDataBinder.ComponentBinding<AndroidTargetComboBoxItem, JComboBox>(){

        @Override
        public void setValue(@Nullable AndroidTargetComboBoxItem newValue, @NotNull JComboBox component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/wizard/ConfigureFormFactorStep$4", "setValue"));
            }
            component.setSelectedItem(newValue);
        }

        @Override
        @Nullable
        public AndroidTargetComboBoxItem getValue(@NotNull JComboBox component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ConfigureFormFactorStep$4", "getValue"));
            }
            return (AndroidTargetComboBoxItem)component.getItemAt(component.getSelectedIndex());
        }

        @Override
        public void addActionListener(@NotNull ActionListener listener, @NotNull JComboBox component) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ConfigureFormFactorStep$4", "addActionListener"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/wizard/ConfigureFormFactorStep$4", "addActionListener"));
            }
            component.addActionListener(listener);
        }
    };

    public ConfigureFormFactorStep(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ConfigureFormFactorStep", "<init>"));
        }
        super("Select the form factors your app will run on", "Different platforms require separate SDKs", null, disposable);
        this.$$$setupUI$$$();
        this.myHelpMeChooseLabel = new JBLabel("Help Me Choose");
        this.myTargets = Lists.newArrayList();
        this.myInstalledVersions = Sets.newHashSet();
        this.myFormFactors = Lists.newArrayList();
        this.myChooseApiLevelDialog = new ChooseApiLevelDialog(null, -1);
        this.myFormFactorApiSelectors = Maps.newHashMap();
        this.myInstallRequests = Maps.newHashMap();
        this.myDisposable = disposable;
        Disposer.register((Disposable)disposable, (Disposable)this.myChooseApiLevelDialog.getDisposable());
        this.setBodyComponent(this.myPanel);
    }

    @Override
    public void init() {
        super.init();
        this.initializeTargets();
        this.myHelpMeChooseLabel.addMouseListener((MouseListener)new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ConfigureFormFactorStep.this.myChooseApiLevelDialog = new ChooseApiLevelDialog(null, ConfigureFormFactorStep.this.myState.get(FormFactorUtils.getMinApiLevelKey(FormFactorUtils.FormFactor.MOBILE)));
                Disposer.register((Disposable)ConfigureFormFactorStep.this.myDisposable, (Disposable)ConfigureFormFactorStep.this.myChooseApiLevelDialog.getDisposable());
                ConfigureFormFactorStep.this.myChooseApiLevelDialog.show();
                if (ConfigureFormFactorStep.this.myChooseApiLevelDialog.isOK()) {
                    int minApiLevel = ConfigureFormFactorStep.this.myChooseApiLevelDialog.getSelectedApiLevel();
                    ((FormFactorSdkControls)ConfigureFormFactorStep.this.myFormFactorApiSelectors.get(FormFactorUtils.FormFactor.MOBILE)).setSelectedItem(Integer.toString(minApiLevel));
                }
            }
        });
        this.myHelpMeChooseLabel.setMaximumSize(new Dimension(250, 200));
        this.register(API_FEEDBACK_KEY, this.myHelpMeChooseLabel, new ScopedDataBinder.ComponentBinding<String, JBLabel>(){

            @Override
            public void setValue(@Nullable String newValue, @NotNull JBLabel label) {
                if (label == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/wizard/ConfigureFormFactorStep$2", "setValue"));
                }
                final JBLabel referenceLabel = label;
                final String referenceString = newValue;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        referenceLabel.setText(referenceString);
                    }
                });
            }
        });
        this.registerValueDeriver(API_FEEDBACK_KEY, new ScopedDataBinder.ValueDeriver<String>(){

            @Override
            @Nullable
            public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
                return 3.makeSetOf(FormFactorUtils.getTargetComboBoxKey(FormFactorUtils.FormFactor.MOBILE));
            }

            @Override
            @Nullable
            public String deriveValue(ScopedStateStore state, ScopedStateStore.Key changedKey, @Nullable String currentValue) {
                AndroidTargetComboBoxItem selectedItem = state.get(FormFactorUtils.getTargetComboBoxKey(FormFactorUtils.FormFactor.MOBILE));
                if (selectedItem == null) {
                    return currentValue;
                }
                Integer selectedApi = selectedItem.apiLevel;
                return String.format(Locale.getDefault(), "<html>Lower API levels target more devices, but have fewer features available. By targeting API %d and later, your app will run on approximately <b>%.1f%%</b> of the devices that are active on the Google Play Store. <span color=\"#%s\">Help me choose.</span></html>", selectedApi, ConfigureFormFactorStep.this.myChooseApiLevelDialog.getSupportedDistributionForApiLevel(selectedApi) * 100.0, Integer.toHexString(JBColor.blue.getRGB()).substring(2));
            }
        });
        this.populateAdditionalFormFactors();
    }

    private void populateAdditionalFormFactors() {
        TemplateManager manager = TemplateManager.getInstance();
        List<File> applicationTemplates = manager.getTemplatesInCategory("Application");
        GridLayoutManager gridLayoutManager = new GridLayoutManager(applicationTemplates.size() * 2 + 1, 2);
        gridLayoutManager.setVGap(5);
        gridLayoutManager.setHGap(10);
        this.myFormFactorPanel.setLayout((LayoutManager)gridLayoutManager);
        GridConstraints c = new GridConstraints();
        c.setVSizePolicy(0);
        int row = 0;
        for (File templateFile : applicationTemplates) {
            FormFactorUtils.FormFactor formFactor;
            TemplateMetadata metadata = manager.getTemplate(templateFile);
            if (metadata == null || metadata.getFormFactor() == null || (formFactor = FormFactorUtils.FormFactor.get(metadata.getFormFactor())) == null) continue;
            this.myFormFactors.add(formFactor);
            c.setRow(row);
            c.setColumn(0);
            c.setFill(0);
            c.setAnchor(8);
            JCheckBox inclusionCheckBox = new JCheckBox(formFactor.toString());
            if (row == 0) {
                this.myState.put(FormFactorUtils.getInclusionKey(formFactor), true);
            }
            this.myFormFactorPanel.add((Component)inclusionCheckBox, c);
            this.register(FormFactorUtils.getInclusionKey(formFactor), inclusionCheckBox);
            FormFactorSdkControls controls = new FormFactorSdkControls();
            JComboBox minSdkComboBox = controls.getMinSdkCombo();
            minSdkComboBox.setName(formFactor.id + ".minSdk");
            controls.layout(this.myFormFactorPanel, ++row, inclusionCheckBox.getIconTextGap());
            ScopedStateStore.Key<String> minApiKey = FormFactorUtils.getMinApiKey(formFactor);
            String savedApiLevel = PropertiesComponent.getInstance().getValue(FormFactorUtils.getPropertiesComponentMinSdkKey(formFactor), Integer.toString(formFactor.defaultApi));
            controls.populateComboBox(this.myTargets, formFactor, metadata.getMinSdk());
            this.myState.put(minApiKey, savedApiLevel);
            this.register(FormFactorUtils.getTargetComboBoxKey(formFactor), minSdkComboBox, TARGET_COMBO_BINDING);
            ConfigureFormFactorStep.setSelectedItem(minSdkComboBox, savedApiLevel);
            if (minSdkComboBox.getSelectedIndex() < 0 && minSdkComboBox.getItemCount() > 0) {
                minSdkComboBox.setSelectedIndex(0);
            }
            if (minSdkComboBox.getItemCount() == 0) {
                inclusionCheckBox.setSelected(false);
                inclusionCheckBox.setEnabled(false);
                inclusionCheckBox.setText(inclusionCheckBox.getText() + " (Not Installed)");
            }
            this.myFormFactorApiSelectors.put(formFactor, controls);
            if (formFactor.equals(FormFactorUtils.FormFactor.MOBILE)) {
                c.setRow(++row);
                c.setColumn(1);
                c.setAnchor(9);
                c.setFill(0);
                this.myFormFactorPanel.add((Component)this.myHelpMeChooseLabel, c);
            }
            ++row;
        }
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        if (this.myState.containsKey(WizardConstants.NEWLY_INSTALLED_API_KEY)) {
            this.initializeTargets();
        }
    }

    private void initializeTargets() {
        IAndroidTarget[] targets = this.getCompilationTargets();
        if (AndroidSdkUtils.isAndroidSdkAvailable()) {
            String[] knownVersions = TemplateUtils.getKnownVersions();
            for (int i = 0; i < knownVersions.length; ++i) {
                AndroidTargetComboBoxItem targetInfo = new AndroidTargetComboBoxItem(knownVersions[i], i + 1);
                this.myTargets.add(targetInfo);
            }
        }
        this.myHighestInstalledApiTarget = null;
        for (IAndroidTarget target : targets) {
            if (this.myHighestInstalledApiTarget == null || target.getVersion().getFeatureLevel() > this.myHighestInstalledApiTarget.getVersion().getFeatureLevel() && !target.getVersion().isPreview()) {
                this.myHighestInstalledApiTarget = target;
            }
            if (target.getVersion().isPreview() || target.getOptionalLibraries() != null && target.getOptionalLibraries().length > 0) {
                AndroidTargetComboBoxItem targetInfo = new AndroidTargetComboBoxItem(target);
                this.myTargets.add(targetInfo);
            }
            this.myInstalledVersions.add(target.getVersion());
        }
    }

    private void populateApiLevels(@NotNull FormFactorUtils.FormFactor formFactor, int apiLevel, @Nullable IAndroidTarget apiTarget) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ConfigureFormFactorStep", "populateApiLevels"));
        }
        ScopedStateStore.Key<String> buildApiKey = FormFactorUtils.getBuildApiKey(formFactor);
        ScopedStateStore.Key<Integer> buildApiLevelKey = FormFactorUtils.getBuildApiLevelKey(formFactor);
        ScopedStateStore.Key<Integer> targetApiLevelKey = FormFactorUtils.getTargetApiLevelKey(formFactor);
        ScopedStateStore.Key<String> targetApiStringKey = FormFactorUtils.getTargetApiStringKey(formFactor);
        if (apiLevel >= 1) {
            if (apiTarget == null) {
                this.myState.put(buildApiKey, Integer.toString(apiLevel));
            } else if (apiTarget.getOptionalLibraries() != null) {
                this.myState.put(buildApiKey, AndroidTargetHash.getTargetHashString((IAndroidTarget)apiTarget));
            } else {
                this.myState.put(buildApiKey, TemplateMetadata.getBuildApiString(apiTarget.getVersion()));
            }
            this.myState.put(buildApiLevelKey, apiLevel);
            if (apiLevel >= 21 || apiTarget != null && apiTarget.getVersion().isPreview()) {
                this.myState.put(targetApiLevelKey, apiLevel);
                if (apiTarget != null) {
                    this.myState.put(targetApiStringKey, apiTarget.getVersion().getApiString());
                } else {
                    this.myState.put(targetApiStringKey, Integer.toString(apiLevel));
                }
            } else if (this.myHighestInstalledApiTarget != null) {
                this.myState.put(targetApiLevelKey, this.myHighestInstalledApiTarget.getVersion().getApiLevel());
                this.myState.put(targetApiStringKey, this.myHighestInstalledApiTarget.getVersion().getApiString());
            }
        }
    }

    @Override
    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        super.deriveValues(modified);
        int enabledFormFactors = 0;
        for (FormFactorUtils.FormFactor formFactor : this.myFormFactors) {
            Boolean included;
            ScopedStateStore.Key<AndroidTargetComboBoxItem> key = FormFactorUtils.getTargetComboBoxKey(formFactor);
            if (modified.contains(key)) {
                AndroidTargetComboBoxItem targetItem = this.myState.get(key);
                if (targetItem == null) continue;
                this.myState.put(FormFactorUtils.getMinApiKey(formFactor), targetItem.id.toString());
                this.myState.put(FormFactorUtils.getMinApiLevelKey(formFactor), targetItem.apiLevel);
                IAndroidTarget target = targetItem.target;
                if (target != null && (target.getVersion().isPreview() || !target.isPlatform())) {
                    this.populateApiLevels(formFactor, targetItem.apiLevel, target);
                } else {
                    int targetApiLevel = this.myHighestInstalledApiTarget != null ? this.myHighestInstalledApiTarget.getVersion().getFeatureLevel() : 0;
                    this.populateApiLevels(formFactor, targetApiLevel, this.myHighestInstalledApiTarget);
                }
                if (this.myInstallRequests.containsKey(formFactor)) {
                    this.myState.listRemove(WizardConstants.INSTALL_REQUESTS_KEY, this.myInstallRequests.get(formFactor));
                }
                if (target == null) {
                    AndroidVersion androidVersion = new AndroidVersion(targetItem.apiLevel, null);
                    if (this.myHighestInstalledApiTarget == null || androidVersion.getApiLevel() > this.myHighestInstalledApiTarget.getVersion().getApiLevel() && !this.myInstalledVersions.contains(androidVersion) && this.myState.get(FormFactorUtils.getInclusionKey(formFactor)).booleanValue()) {
                        IPkgDesc platformDescription = PkgDesc.Builder.newPlatform((AndroidVersion)androidVersion, (MajorRevision)new MajorRevision(1), (FullRevision)FullRevision.NOT_SPECIFIED).create();
                        this.myState.listPush(WizardConstants.INSTALL_REQUESTS_KEY, platformDescription);
                        this.myInstallRequests.put(formFactor, platformDescription);
                        this.populateApiLevels(formFactor, androidVersion.getApiLevel(), this.myHighestInstalledApiTarget);
                    }
                } else if (!this.myInstalledVersions.contains(target.getVersion())) {
                    IPkgDesc platformDescription = PkgDesc.Builder.newPlatform((AndroidVersion)target.getVersion(), (MajorRevision)new MajorRevision(target.getRevision()), (FullRevision)target.getBuildToolInfo().getRevision()).create();
                    this.myState.listPush(WizardConstants.INSTALL_REQUESTS_KEY, platformDescription);
                    this.myInstallRequests.put(formFactor, platformDescription);
                }
                PropertiesComponent.getInstance().setValue(FormFactorUtils.getPropertiesComponentMinSdkKey(formFactor), targetItem.id.toString());
            }
            if ((included = this.myState.get(FormFactorUtils.getInclusionKey(formFactor))) == null) continue;
            if (this.myFormFactorApiSelectors.containsKey(formFactor)) {
                this.myFormFactorApiSelectors.get(formFactor).setEnabled(included);
            }
            if (!included.booleanValue()) continue;
            ++enabledFormFactors;
        }
        this.myState.put(NUM_ENABLED_FORM_FACTORS_KEY, enabledFormFactors);
    }

    @Override
    public boolean validate() {
        this.setErrorHtml("");
        Integer enabledFormFactors = this.myState.get(NUM_ENABLED_FORM_FACTORS_KEY);
        if (enabledFormFactors == null || enabledFormFactors < 1) {
            this.setErrorHtml("At least one form factor must be selected.");
            return false;
        }
        for (FormFactorUtils.FormFactor formFactor : this.myFormFactors) {
            Boolean included = this.myState.get(FormFactorUtils.getInclusionKey(formFactor));
            if (included == null || !included.booleanValue() || this.myState.get(FormFactorUtils.getMinApiKey(formFactor)) != null) continue;
            this.setErrorHtml("Each form factor must have a Minimum SDK level selected.");
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("Configure Form Factors" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureFormFactorStep", "getStepName"));
        }
        return "Configure Form Factors";
    }

    @NotNull
    IAndroidTarget[] getCompilationTargets() {
        AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (sdkData == null) {
            IAndroidTarget[] iAndroidTargetArray = new IAndroidTarget[]{};
            if (iAndroidTargetArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureFormFactorStep", "getCompilationTargets"));
            }
            return iAndroidTargetArray;
        }
        sdkData.getLocalSdk().clearLocalPkg(PkgType.PKG_ALL);
        IAndroidTarget[] iAndroidTargetArray = ConfigureFormFactorStep.getCompilationTargets(sdkData);
        if (iAndroidTargetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureFormFactorStep", "getCompilationTargets"));
        }
        return iAndroidTargetArray;
    }

    @NotNull
    public static IAndroidTarget[] getCompilationTargets(@NotNull AndroidSdkData sdkData) {
        if (sdkData == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ConfigureFormFactorStep", "getCompilationTargets"));
        }
        IAndroidTarget[] targets = sdkData.getTargets();
        ArrayList<IAndroidTarget> list = new ArrayList<IAndroidTarget>();
        for (IAndroidTarget target : targets) {
            if (!target.isPlatform() && (target.getOptionalLibraries() == null || target.getOptionalLibraries().length == 0)) continue;
            list.add(target);
        }
        IAndroidTarget[] iAndroidTargetArray = list.toArray(new IAndroidTarget[list.size()]);
        if (iAndroidTargetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureFormFactorStep", "getCompilationTargets"));
        }
        return iAndroidTargetArray;
    }

    @Nullable
    public String getHelpText(@NotNull String param) {
        if (param == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ConfigureFormFactorStep", "getHelpText"));
        }
        if (param.equals("minApi")) {
            return "Choose the lowest version of Android that your application will support. Lower API levels target more devices, but means fewer features are available. By targeting API 8 and later, you reach approximately 95% of the market.";
        }
        if (param.equals("targetApi")) {
            return "Choose the highest API level that the application is known to work with. This attribute informs the system that you have tested against the target version and the system should not enable any compatibility behaviors to maintain your app's forward-compatibility with the target version. The application is still able to run on older versions (down to minSdkVersion). Your application may look dated if you are not targeting the current version.";
        }
        if (param.equals("buildApi")) {
            return "Choose a target API to compile your code against, from your installed SDKs. This is typically the most recent version, or the first version that supports all the APIs you want to directly access without reflection.";
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel;
    }

    @Override
    @Nullable
    protected JComponent getHeader() {
        return ConfigureAndroidProjectPath.buildConfigurationHeader();
    }

    @Override
    @Nullable
    protected JBColor getTitleTextColor() {
        return WizardConstants.ANDROID_NPW_TITLE_COLOR;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 5, 5, 5), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myFormFactorPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, new Dimension(750, -1), new Dimension(750, -1)));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel2.add((Component)spacer4, new GridConstraints(1, 2, 1, 1, 0, 1, 7, 1, null, null, null));
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static final class FormFactorSdkControls {
        private final JLabel myLabel = new JLabel("Minimum SDK");
        private final JComboBox myMinSdkCombobox = new ComboBox();

        public void setEnabled(boolean enabled) {
            for (JComponent component : ImmutableSet.of((Object)this.myLabel, (Object)this.myMinSdkCombobox)) {
                component.setEnabled(enabled);
            }
        }

        public void setSelectedItem(String item) {
            ScopedDataBinder.setSelectedItem(this.myMinSdkCombobox, item);
        }

        public JLabel getLabel() {
            return this.myLabel;
        }

        public JComboBox getMinSdkCombo() {
            return this.myMinSdkCombobox;
        }

        private void layout(JPanel panel, int row, int ident) {
            GridConstraints c = new GridConstraints();
            c.setVSizePolicy(0);
            c.setRow(row);
            c.setColumn(0);
            c.setFill(0);
            c.setAnchor(8);
            c.setRow(row);
            c.setIndent(ident);
            panel.add((Component)this.myLabel, c);
            c.setIndent(0);
            c.setColumn(1);
            c.setFill(1);
            panel.add((Component)this.myMinSdkCombobox, c);
        }

        private void populateComboBox(List<AndroidTargetComboBoxItem> myTargets, @NotNull FormFactorUtils.FormFactor formFactor, int minSdk) {
            if (formFactor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/wizard/ConfigureFormFactorStep$FormFactorSdkControls", "populateComboBox"));
            }
            for (AndroidTargetComboBoxItem target : Iterables.filter(myTargets, FormFactorUtils.getMinSdkComboBoxFilter(formFactor, minSdk))) {
                if (target.apiLevel < minSdk && (target.target == null || !target.target.getVersion().isPreview())) continue;
                this.myMinSdkCombobox.addItem(target);
            }
        }
    }

    public static class AndroidTargetComboBoxItem
    extends ComboBoxItem {
        public int apiLevel;
        public IAndroidTarget target;

        public AndroidTargetComboBoxItem(@NotNull String label, int apiLevel) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ConfigureFormFactorStep$AndroidTargetComboBoxItem", "<init>"));
            }
            super(Integer.toString(apiLevel), label, 1, 1);
            this.apiLevel = -1;
            this.target = null;
            this.apiLevel = apiLevel;
        }

        public AndroidTargetComboBoxItem(@NotNull IAndroidTarget target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ConfigureFormFactorStep$AndroidTargetComboBoxItem", "<init>"));
            }
            super(AndroidTargetComboBoxItem.getId(target), AndroidTargetComboBoxItem.getLabel(target), 1, 1);
            this.apiLevel = -1;
            this.target = null;
            this.target = target;
            this.apiLevel = target.getVersion().getFeatureLevel();
        }

        @NotNull
        static String getLabel(@NotNull IAndroidTarget target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ConfigureFormFactorStep$AndroidTargetComboBoxItem", "getLabel"));
            }
            if (target.isPlatform() && target.getVersion().getApiLevel() <= 21) {
                if (target.getVersion().isPreview()) {
                    String string = "API " + Integer.toString(target.getVersion().getApiLevel()) + "+: " + target.getName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureFormFactorStep$AndroidTargetComboBoxItem", "getLabel"));
                    }
                    return string;
                }
                String name = SdkVersionInfo.getAndroidName((int)target.getVersion().getApiLevel());
                if (name == null) {
                    String string = "API " + Integer.toString(target.getVersion().getApiLevel());
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureFormFactorStep$AndroidTargetComboBoxItem", "getLabel"));
                    }
                    return string;
                }
                String string = name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureFormFactorStep$AndroidTargetComboBoxItem", "getLabel"));
                }
                return string;
            }
            String string = TemplateUtils.getTargetLabel(target);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureFormFactorStep$AndroidTargetComboBoxItem", "getLabel"));
            }
            return string;
        }

        @NotNull
        private static String getId(@NotNull IAndroidTarget target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ConfigureFormFactorStep$AndroidTargetComboBoxItem", "getId"));
            }
            String string = target.getVersion().getApiString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureFormFactorStep$AndroidTargetComboBoxItem", "getId"));
            }
            return string;
        }

        @Override
        public String toString() {
            return this.label;
        }
    }
}

