/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.wizard.TemplateWizardState;
import com.android.tools.idea.wizard.TemplateWizardStep;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseGithubRepositoryStep
extends TemplateWizardStep {
    private JTextField myUrlField;
    private JBLabel myDescription;
    private JPanel myPanel;
    public static final String GITHUB_TEMPLATE_KEY = "githubUrl";
    private String myBranch;

    public ChooseGithubRepositoryStep(@NotNull TemplateWizardState state, @Nullable Project project, @Nullable Module module, TemplateWizardStep.UpdateListener updateListener) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ChooseGithubRepositoryStep", "<init>"));
        }
        super(state, project, module, null, updateListener);
        this.myBranch = null;
        this.$$$setupUI$$$();
        this.register(GITHUB_TEMPLATE_KEY, this.myUrlField);
    }

    @Override
    public boolean validate() {
        URL url;
        if (!super.validate()) {
            return false;
        }
        String urlText = this.myUrlField.getText();
        if (urlText.isEmpty()) {
            this.setErrorHtml("URL field may not be empty");
            return false;
        }
        try {
            url = new URL(urlText);
        }
        catch (MalformedURLException e) {
            this.setErrorHtml("Malformed URL");
            return false;
        }
        if (!url.getProtocol().equalsIgnoreCase("https")) {
            this.setErrorHtml("GitHub URLs must be HTTPS");
            return false;
        }
        if (!url.getHost().equalsIgnoreCase("github.com")) {
            this.setErrorHtml("That is not a GitHub URL");
            return false;
        }
        return true;
    }

    @Override
    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myUrlField;
    }

    @Override
    @NotNull
    protected JLabel getDescription() {
        JBLabel jBLabel = this.myDescription;
        if (jBLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ChooseGithubRepositoryStep", "getDescription"));
        }
        return jBLabel;
    }

    @Override
    @NotNull
    protected JLabel getError() {
        JBLabel jBLabel = this.myDescription;
        if (jBLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ChooseGithubRepositoryStep", "getError"));
        }
        return jBLabel;
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrlField.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ChooseGithubRepositoryStep", "getUrl"));
        }
        return string;
    }

    @Nullable
    public String getBranch() {
        return this.myBranch;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JBLabel jBLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDescription = jBLabel = new JBLabel();
        jBLabel.setText("Label");
        jPanel.add((Component)jBLabel, new GridConstraints(4, 0, 1, 1, 0, 1, 6, 0, new Dimension(-1, 200), new Dimension(-1, 200), null));
        this.myUrlField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Github URL:");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 6, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

