/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.ArrayUtil;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseFromFileListDialog
extends DialogWrapper {
    private final List<File> myFiles;
    private FileListItem myChosenFile;

    public ChooseFromFileListDialog(@Nullable Project project, @NotNull List<File> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/wizard/ChooseFromFileListDialog", "<init>"));
        }
        super(project);
        this.myFiles = files;
        Window window = this.getWindow();
        if (window != null) {
            this.getWindow().setMinimumSize(new Dimension(600, 480));
        } else assert (ApplicationManager.getApplication().isUnitTestMode());
        this.init();
    }

    @Nullable
    public File getChosenFile() {
        return this.myChosenFile.myFile;
    }

    public boolean isOKActionEnabled() {
        return this.myChosenFile != null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        final JBList list = new JBList();
        list.setModel(ChooseFromFileListDialog.getListModel(this.myFiles));
        list.setSelectionMode(0);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ChooseFromFileListDialog.this.myChosenFile = (FileListItem)list.getSelectedValue();
            }
        });
        return ListWithFilter.wrap((JList)list);
    }

    private static ListModel getListModel(List<File> files) {
        ArrayList items = Lists.newArrayListWithExpectedSize((int)files.size());
        for (File f : files) {
            items.add(new FileListItem(f));
        }
        Collections.sort(items);
        return JBList.createDefaultListModel((Object[])ArrayUtil.toObjectArray((Collection)items));
    }

    private static class FileListItem
    implements Comparable<FileListItem> {
        private final File myFile;

        public FileListItem(@NotNull File file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ChooseFromFileListDialog$FileListItem", "<init>"));
            }
            this.myFile = file;
        }

        public String toString() {
            return this.myFile.getName();
        }

        @Override
        public int compareTo(@NotNull FileListItem o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/wizard/ChooseFromFileListDialog$FileListItem", "compareTo"));
            }
            return this.toString().compareTo(o.toString());
        }
    }
}

