/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public class TypedVariable {
    private static final Logger LOG = Logger.getInstance(TypedVariable.class);

    @Nullable
    public static Object parseGlobal(@NotNull Attributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/templates/TypedVariable", "parseGlobal"));
        }
        String value = attributes.getValue("value");
        Type type = Type.get(attributes.getValue("type"));
        switch (type) {
            case STRING: {
                return value;
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(value);
            }
            case INTEGER: {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    if (!ApplicationManager.getApplication().isUnitTestMode()) {
                        LOG.error("NumberFormatException while evaluating " + value);
                    }
                    return value;
                }
            }
        }
        return value;
    }

    public static enum Type {
        STRING,
        BOOLEAN,
        INTEGER;


        @NotNull
        public static Type get(@Nullable String name) {
            Type type;
            if (name == null) {
                Type type2 = STRING;
                if (type2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TypedVariable$Type", "get"));
                }
                return type2;
            }
            try {
                type = Type.valueOf(name.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException e) {
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.error("Unexpected global type '" + name + "'");
                    LOG.error("Expected one of :");
                    for (Type s : Type.values()) {
                        LOG.error("  " + s.name().toLowerCase(Locale.US));
                    }
                }
                Type type3 = STRING;
                if (type3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TypedVariable$Type", "get"));
                }
                return type3;
            }
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TypedVariable$Type", "get"));
            }
            return type;
        }
    }
}

