/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.utils.SparseArray;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.ide.impl.ProjectPaneSelectInTarget;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateUtils {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.templates.DomUtilities");

    @Nullable
    public static String extractClassName(@NotNull String string) {
        char c;
        int i;
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/templates/TemplateUtils", "extractClassName"));
        }
        StringBuilder sb = new StringBuilder(string.length());
        int n = string.length();
        for (i = 0; i < n; ++i) {
            c = Character.toUpperCase(string.charAt(i));
            if (!Character.isJavaIdentifierStart(c)) continue;
            sb.append(c);
            ++i;
            break;
        }
        if (sb.length() > 0) {
            while (i < n) {
                c = string.charAt(i);
                if (Character.isJavaIdentifierPart(c)) {
                    sb.append(c);
                }
                ++i;
            }
            return sb.toString();
        }
        return null;
    }

    public static String stripSuffix(@NotNull String string, @NotNull String suffix) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/templates/TemplateUtils", "stripSuffix"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/templates/TemplateUtils", "stripSuffix"));
        }
        if (string.endsWith(suffix)) {
            return string.substring(0, string.length() - suffix.length());
        }
        return string;
    }

    public static File stripSuffix(@NotNull File file, @NotNull String suffix) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/templates/TemplateUtils", "stripSuffix"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/templates/TemplateUtils", "stripSuffix"));
        }
        if (file.getName().endsWith(suffix)) {
            String name = file.getName();
            name = name.substring(0, name.length() - suffix.length());
            File parent = file.getParentFile();
            if (parent != null) {
                return new File(parent, name);
            }
            return new File(name);
        }
        return file;
    }

    public static String camelCaseToUnderlines(String string) {
        if (string.isEmpty()) {
            return string;
        }
        StringBuilder sb = new StringBuilder(2 * string.length());
        int n = string.length();
        boolean lastWasUpperCase = Character.isUpperCase(string.charAt(0));
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            boolean isUpperCase = Character.isUpperCase(c);
            if (isUpperCase && !lastWasUpperCase) {
                sb.append('_');
            }
            lastWasUpperCase = isUpperCase;
            c = Character.toLowerCase(c);
            sb.append(c);
        }
        return sb.toString();
    }

    public static String underlinesToCamelCase(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        int n = string.length();
        boolean upcaseNext = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '_') {
                upcaseNext = true;
                continue;
            }
            if (upcaseNext) {
                c = Character.toUpperCase(c);
            }
            upcaseNext = false;
            sb.append(c);
        }
        return sb.toString();
    }

    @NotNull
    public static String getTargetLabel(@NotNull IAndroidTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/templates/TemplateUtils", "getTargetLabel"));
        }
        if (target.isPlatform()) {
            AndroidVersion version = target.getVersion();
            String codename = target.getProperty("Platform.CodeName");
            String release = target.getProperty("ro.build.version.release");
            if (codename != null) {
                String string = String.format("API %1$d: Android %2$s (%3$s)", version.getApiLevel(), release, codename);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TemplateUtils", "getTargetLabel"));
                }
                return string;
            }
            String string = String.format("API %1$d: Android %2$s", version.getApiLevel(), release);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TemplateUtils", "getTargetLabel"));
            }
            return string;
        }
        String string = String.format("%1$s (API %2$s)", target.getFullName(), target.getVersion().getApiString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TemplateUtils", "getTargetLabel"));
        }
        return string;
    }

    public static String[] getKnownVersions() {
        AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        assert (sdkData != null);
        int max = 20;
        IAndroidTarget[] targets = sdkData.getTargets();
        SparseArray apiTargets = null;
        for (IAndroidTarget target : targets) {
            AndroidVersion version;
            if (!target.isPlatform() || (version = target.getVersion()).isPreview()) continue;
            int apiLevel = version.getApiLevel();
            max = Math.max(max, apiLevel);
            if (apiLevel <= 21) continue;
            if (apiTargets == null) {
                apiTargets = new SparseArray();
            }
            apiTargets.put(apiLevel, (Object)target);
        }
        String[] versions = new String[max];
        for (int api = 1; api <= max; ++api) {
            String name = SdkVersionInfo.getAndroidName((int)api);
            if (name == null) {
                IAndroidTarget target;
                if (apiTargets != null && (target = (IAndroidTarget)apiTargets.get(api)) != null) {
                    name = TemplateUtils.getTargetLabel(target);
                }
                if (name == null) {
                    name = String.format("API %1$d", api);
                }
            }
            versions[api - 1] = name;
        }
        return versions;
    }

    @NotNull
    public static File[] listFiles(@Nullable File dir) {
        File[] files;
        if (dir != null && (files = dir.listFiles()) != null) {
            if (files == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TemplateUtils", "listFiles"));
            }
            return files;
        }
        if (ArrayUtil.EMPTY_FILE_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TemplateUtils", "listFiles"));
        }
        return ArrayUtil.EMPTY_FILE_ARRAY;
    }

    @NotNull
    public static List<Element> getChildren(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/templates/TemplateUtils", "getChildren"));
        }
        NodeList children = element.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>(children.getLength());
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            Element child = (Element)node;
            result.add(child);
        }
        ArrayList<Element> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TemplateUtils", "getChildren"));
        }
        return arrayList;
    }

    public static boolean openEditors(@NotNull Project project, @NotNull List<File> files, boolean select) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/templates/TemplateUtils", "openEditors"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/templates/TemplateUtils", "openEditors"));
        }
        if (files.size() > 0) {
            boolean result = true;
            VirtualFile last = null;
            for (File file : files) {
                if (!file.exists()) continue;
                VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
                if (vFile != null) {
                    result &= TemplateUtils.openEditor(project, vFile);
                    last = vFile;
                    continue;
                }
                result = false;
            }
            if (select && last != null) {
                TemplateUtils.selectEditor(project, last);
            }
            return result;
        }
        return false;
    }

    public static boolean openEditor(@NotNull Project project, @NotNull VirtualFile vFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/templates/TemplateUtils", "openEditor"));
        }
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/templates/TemplateUtils", "openEditor"));
        }
        OpenFileDescriptor descriptor = vFile.getFileType() == StdFileTypes.XML ? new OpenFileDescriptor(project, vFile, 0) : new OpenFileDescriptor(project, vFile);
        return !FileEditorManager.getInstance((Project)project).openEditor(descriptor, true).isEmpty();
    }

    public static void selectEditor(Project project, VirtualFile file) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile != null) {
            ProjectPaneSelectInTarget selectAction = new ProjectPaneSelectInTarget(project);
            selectAction.select((PsiElement)psiFile, false);
        }
    }

    @Nullable
    public static String readTextFile(@NotNull File file, boolean warnIfNotExists) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/templates/TemplateUtils", "readTextFile"));
        }
        assert (file.isAbsolute());
        try {
            return Files.toString((File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            if (warnIfNotExists) {
                LOG.warn((Throwable)e);
            }
            return null;
        }
    }

    @Nullable
    public static String readTextFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/templates/TemplateUtils", "readTextFile"));
        }
        return TemplateUtils.readTextFile(file, true);
    }

    @Nullable
    public static String readTextFile(final @NotNull Project project, final @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/templates/TemplateUtils", "readTextFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/templates/TemplateUtils", "readTextFile"));
        }
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            @Nullable
            public String compute() {
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (psiFile == null) {
                    return null;
                }
                return psiFile.getText();
            }
        });
    }
}

