/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.structure.BuildFilePanel;
import com.android.tools.idea.structure.KeyValuePane;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public class SingleObjectPanel
extends BuildFilePanel {
    protected final GrClosableBlock myRoot;
    protected final Map<BuildFileKey, Object> myValues;
    protected final List<BuildFileKey> myProperties;
    protected final KeyValuePane myDetailPane;

    public SingleObjectPanel(@NotNull Project project, @NotNull String moduleName, @Nullable GrClosableBlock root, @NotNull List<BuildFileKey> properties) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/structure/SingleObjectPanel", "<init>"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/structure/SingleObjectPanel", "<init>"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/android/tools/idea/structure/SingleObjectPanel", "<init>"));
        }
        super(project, moduleName);
        this.myValues = Maps.newHashMap();
        this.myRoot = root;
        this.myProperties = properties;
        this.myDetailPane = new KeyValuePane(project);
        if (this.myGradleBuildFile != null) {
            for (BuildFileKey key : properties) {
                Object value = this.myGradleBuildFile.getValue((GrStatementOwner)this.myRoot, key);
                if (value == null) continue;
                this.myValues.put(key, value);
            }
        }
    }

    @Override
    protected void addItems(@NotNull JPanel parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/structure/SingleObjectPanel", "addItems"));
        }
        if (this.myGradleBuildFile == null) {
            return;
        }
        this.myDetailPane.init(this.myGradleBuildFile, this.myProperties);
        this.myDetailPane.setCurrentBuildFileObject(this.myValues);
        this.myDetailPane.updateUiFromCurrentObject();
        this.myDetailPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.myDetailPane, "North");
    }

    @Override
    public void apply() {
        if (this.myGradleBuildFile == null) {
            return;
        }
        for (BuildFileKey key : this.myProperties) {
            Object value = this.myValues.get((Object)key);
            if (value != null) {
                this.myGradleBuildFile.setValue((GrStatementOwner)this.myRoot, key, value);
                continue;
            }
            this.myGradleBuildFile.removeValue((GrStatementOwner)this.myRoot, key);
        }
        this.myDetailPane.clearModified();
    }

    @Override
    public boolean isModified() {
        return this.myDetailPane.isModified();
    }
}

