/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure;

import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalBuildToolPkgInfo;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileKeyType;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyValuePane
extends JPanel
implements DocumentListener,
ItemListener {
    private final BiMap<BuildFileKey, JComponent> myProperties = HashBiMap.create();
    private boolean myIsUpdating;
    private Map<BuildFileKey, Object> myCurrentBuildFileObject;
    private Map<BuildFileKey, Object> myCurrentModelObject;
    private boolean myModified;
    private final Project myProject;
    private final Set<String> myInstalledApis = Sets.newLinkedHashSetWithExpectedSize((int)21);
    private final Set<String> myInstalledCompileApis = Sets.newLinkedHashSetWithExpectedSize((int)21);
    private final Set<String> myInstalledBuildTools = new LinkedHashSet<String>();
    private final List<String> myJavaCompatibility = ImmutableList.of((Object)"JavaVersion.VERSION_1_6", (Object)"JavaVersion.VERSION_1_7");
    private final Map<BuildFileKey, Iterable<String>> myKeysWithKnownValues = ImmutableMap.builder().put((Object)BuildFileKey.MIN_SDK_VERSION, this.myInstalledApis).put((Object)BuildFileKey.TARGET_SDK_VERSION, this.myInstalledApis).put((Object)BuildFileKey.COMPILE_SDK_VERSION, this.myInstalledCompileApis).put((Object)BuildFileKey.BUILD_TOOLS_VERSION, this.myInstalledBuildTools).put((Object)BuildFileKey.SOURCE_COMPATIBILITY, this.myJavaCompatibility).put((Object)BuildFileKey.TARGET_COMPATIBILITY, this.myJavaCompatibility).build();

    public KeyValuePane(Project project) {
        this.myProject = project;
        LocalSdk sdk = null;
        AndroidSdkData androidSdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (androidSdkData != null) {
            sdk = androidSdkData.getLocalSdk();
        }
        if (sdk != null) {
            LocalPkgInfo[] buildToolsPackages;
            for (LocalPkgInfo buildToolsPackage : buildToolsPackages = sdk.getPkgsInfos(PkgType.PKG_BUILD_TOOLS)) {
                BuildToolInfo buildToolInfo;
                if (!(buildToolsPackage instanceof LocalBuildToolPkgInfo) || (buildToolInfo = ((LocalBuildToolPkgInfo)buildToolsPackage).getBuildToolInfo()) == null) continue;
                this.myInstalledBuildTools.add(buildToolInfo.getRevision().toString());
            }
        }
    }

    public void setCurrentBuildFileObject(@Nullable Map<BuildFileKey, Object> currentBuildFileObject) {
        this.myCurrentBuildFileObject = currentBuildFileObject;
    }

    public void setCurrentModelObject(@Nullable Map<BuildFileKey, Object> currentModelObject) {
        this.myCurrentModelObject = currentModelObject;
    }

    public void init(GradleBuildFile gradleBuildFile, Collection<BuildFileKey> properties) {
        GridLayoutManager layout = new GridLayoutManager(properties.size() + 1, 2);
        this.setLayout((LayoutManager)layout);
        GridConstraints constraints = new GridConstraints();
        constraints.setAnchor(8);
        constraints.setVSizePolicy(0);
        for (BuildFileKey property : properties) {
            ComboBox component;
            constraints.setColumn(0);
            constraints.setFill(0);
            constraints.setHSizePolicy(0);
            this.add((Component)new JBLabel(property.getDisplayName()), constraints);
            constraints.setColumn(1);
            constraints.setFill(1);
            constraints.setHSizePolicy(4);
            switch (property.getType()) {
                case BOOLEAN: {
                    constraints.setFill(0);
                    ComboBox comboBox = this.getComboBox(false);
                    comboBox.addItem((Object)"");
                    comboBox.addItem((Object)"true");
                    comboBox.addItem((Object)"false");
                    comboBox.setPrototypeDisplayValue((Object)"(false) ");
                    component = comboBox;
                    break;
                }
                case FILE: 
                case FILE_AS_STRING: {
                    JBTextField textField = new JBTextField();
                    TextFieldWithBrowseButton fileField = new TextFieldWithBrowseButton((JTextField)textField);
                    FileChooserDescriptor d = new FileChooserDescriptor(true, false, false, true, false, false);
                    d.setShowFileSystemRoots(true);
                    fileField.addBrowseFolderListener(new TextBrowseFolderListener(d));
                    fileField.getTextField().getDocument().addDocumentListener(this);
                    component = fileField;
                    break;
                }
                case REFERENCE: {
                    constraints.setFill(0);
                    component = this.getComboBox(true);
                    break;
                }
                default: {
                    ComboBox comboBox;
                    if (this.hasKnownValues(property)) {
                        constraints.setFill(0);
                        comboBox = this.getComboBox(true);
                        for (String s : this.myKeysWithKnownValues.get((Object)property)) {
                            comboBox.addItem((Object)s);
                        }
                        component = comboBox;
                        break;
                    }
                    JBTextField textField = new JBTextField();
                    textField.getDocument().addDocumentListener(this);
                    component = textField;
                }
            }
            this.add((Component)component, constraints);
            this.myProperties.put((Object)property, (Object)component);
            constraints.setRow(constraints.getRow() + 1);
        }
        constraints.setColumn(0);
        constraints.setVSizePolicy(2);
        constraints.setHSizePolicy(0);
        this.add((Component)new JBLabel(""), constraints);
        this.updateUiFromCurrentObject();
    }

    public void updateReferenceValues(@NotNull BuildFileKey containerProperty, @NotNull Iterable<String> values) {
        if (containerProperty == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/structure/KeyValuePane", "updateReferenceValues"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/structure/KeyValuePane", "updateReferenceValues"));
        }
        BuildFileKey itemType = containerProperty.getItemType();
        if (itemType == null) {
            return;
        }
        ComboBox comboBox = (ComboBox)this.myProperties.get((Object)itemType);
        if (comboBox == null) {
            return;
        }
        String currentValue = comboBox.getEditor().getItem().toString();
        comboBox.removeAllItems();
        for (String value : values) {
            comboBox.addItem((Object)value);
        }
        comboBox.setSelectedItem((Object)currentValue);
    }

    private ComboBox getComboBox(boolean editable) {
        ComboBox comboBox = new ComboBox();
        comboBox.addItemListener((ItemListener)this);
        comboBox.setEditor(new ComboBoxEditor(){
            private final JBTextField myTextField = new JBTextField();

            @Override
            public Component getEditorComponent() {
                return this.myTextField;
            }

            @Override
            public void setItem(Object o) {
                this.myTextField.setText(o != null ? o.toString() : "");
            }

            @Override
            public Object getItem() {
                return this.myTextField.getText();
            }

            @Override
            public void selectAll() {
                this.myTextField.selectAll();
            }

            @Override
            public void addActionListener(ActionListener actionListener) {
            }

            @Override
            public void removeActionListener(ActionListener actionListener) {
            }
        });
        comboBox.setEditable(true);
        JBTextField editorComponent = (JBTextField)comboBox.getEditor().getEditorComponent();
        editorComponent.setEditable(editable);
        editorComponent.getDocument().addDocumentListener(this);
        return comboBox;
    }

    private void updateCurrentObjectFromUi() {
        if (this.myIsUpdating || this.myCurrentBuildFileObject == null) {
            return;
        }
        for (Map.Entry entry : this.myProperties.entrySet()) {
            Object newValue;
            BuildFileKey key = (BuildFileKey)((Object)entry.getKey());
            JComponent component = (JComponent)entry.getValue();
            Object currentValue = this.myCurrentBuildFileObject.get((Object)key);
            BuildFileKeyType type = key.getType();
            switch (type) {
                case BOOLEAN: {
                    ComboBox comboBox = (ComboBox)component;
                    JBTextField editorComponent = (JBTextField)comboBox.getEditor().getEditorComponent();
                    int index = comboBox.getSelectedIndex();
                    if (index == 2) {
                        newValue = Boolean.FALSE;
                        editorComponent.setForeground((Color)JBColor.BLACK);
                        break;
                    }
                    if (index == 1) {
                        newValue = Boolean.TRUE;
                        editorComponent.setForeground((Color)JBColor.BLACK);
                        break;
                    }
                    newValue = null;
                    editorComponent.setForeground((Color)JBColor.GRAY);
                    break;
                }
                case FILE: 
                case FILE_AS_STRING: {
                    newValue = ((TextFieldWithBrowseButton)component).getText();
                    if ("".equals(newValue)) {
                        newValue = null;
                    }
                    if (newValue == null) break;
                    newValue = new File(newValue.toString());
                    break;
                }
                case INTEGER: {
                    try {
                        if (this.hasKnownValues(key)) {
                            newValue = Integer.valueOf(((ComboBox)component).getEditor().getItem().toString());
                            break;
                        }
                        newValue = Integer.valueOf(((JBTextField)component).getText());
                    }
                    catch (Exception e) {
                        newValue = null;
                    }
                    break;
                }
                case REFERENCE: {
                    newValue = ((ComboBox)component).getEditor().getItem();
                    String newStringValue = (String)newValue;
                    if (newStringValue != null && newStringValue.isEmpty()) {
                        newStringValue = null;
                    }
                    String prefix = KeyValuePane.getReferencePrefix(key);
                    if (newStringValue != null && !newStringValue.startsWith(prefix)) {
                        newStringValue = prefix + newStringValue;
                    }
                    newValue = newStringValue;
                    break;
                }
                default: {
                    if (this.hasKnownValues(key)) {
                        newValue = ((ComboBox)component).getEditor().getItem();
                        if ("".equals(newValue)) {
                            newValue = null;
                        }
                    } else {
                        newValue = ((JBTextField)component).getText();
                        if ("".equals(newValue)) {
                            newValue = null;
                        }
                    }
                    if (type != BuildFileKeyType.CLOSURE || newValue == null) break;
                    ArrayList newListValue = new ArrayList();
                    for (String o : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)((String)newValue))) {
                        newListValue.add(key.getValueFactory().parse(o, this.myProject));
                    }
                    newValue = newListValue;
                }
            }
            if (Objects.equal((Object)currentValue, (Object)newValue)) continue;
            if (newValue == null) {
                this.myCurrentBuildFileObject.remove((Object)key);
            } else {
                this.myCurrentBuildFileObject.put(key, newValue);
            }
            this.myModified = true;
        }
    }

    public void updateUiFromCurrentObject() {
        this.myIsUpdating = true;
        for (Map.Entry entry : this.myProperties.entrySet()) {
            BuildFileKey key = (BuildFileKey)((Object)entry.getKey());
            JComponent component = (JComponent)entry.getValue();
            Object value = this.myCurrentBuildFileObject != null ? this.myCurrentBuildFileObject.get((Object)key) : null;
            Object modelValue = this.myCurrentModelObject != null ? this.myCurrentModelObject.get((Object)key) : null;
            switch (key.getType()) {
                case BOOLEAN: {
                    ComboBox comboBox = (ComboBox)component;
                    String text = KeyValuePane.formatDefaultValue(modelValue);
                    comboBox.removeItemAt(0);
                    comboBox.insertItemAt((Object)text, 0);
                    JBTextField editorComponent = (JBTextField)comboBox.getEditor().getEditorComponent();
                    if (Boolean.FALSE.equals(value)) {
                        comboBox.setSelectedIndex(2);
                        editorComponent.setForeground((Color)JBColor.BLACK);
                        break;
                    }
                    if (Boolean.TRUE.equals(value)) {
                        comboBox.setSelectedIndex(1);
                        editorComponent.setForeground((Color)JBColor.BLACK);
                        break;
                    }
                    comboBox.setSelectedIndex(0);
                    editorComponent.setForeground((Color)JBColor.GRAY);
                    break;
                }
                case FILE: 
                case FILE_AS_STRING: {
                    TextFieldWithBrowseButton fieldWithButton = (TextFieldWithBrowseButton)component;
                    fieldWithButton.setText(value != null ? value.toString() : "");
                    JBTextField textField = (JBTextField)fieldWithButton.getTextField();
                    textField.getEmptyText().setText(KeyValuePane.formatDefaultValue(modelValue));
                    break;
                }
                case REFERENCE: {
                    String stringValue = (String)value;
                    String prefix = KeyValuePane.getReferencePrefix(key);
                    if (stringValue == null) {
                        stringValue = "";
                    } else if (stringValue.startsWith(prefix)) {
                        stringValue = stringValue.substring(prefix.length());
                    }
                    ComboBox comboBox = (ComboBox)component;
                    JBTextField textField = (JBTextField)comboBox.getEditor().getEditorComponent();
                    textField.getEmptyText().setText(KeyValuePane.formatDefaultValue(modelValue));
                    comboBox.setSelectedItem((Object)stringValue);
                    break;
                }
                case CLOSURE: {
                    if (value instanceof List) {
                        value = Joiner.on((String)", ").join((Iterable)((List)value));
                    }
                }
                default: {
                    JBTextField textField;
                    ComboBox comboBox;
                    if (this.hasKnownValues(key)) {
                        comboBox = (ComboBox)component;
                        comboBox.setSelectedItem((Object)(value != null ? value.toString() : ""));
                        textField = (JBTextField)comboBox.getEditor().getEditorComponent();
                        textField.getEmptyText().setText(KeyValuePane.formatDefaultValue(modelValue));
                        break;
                    }
                    JBTextField textField2 = (JBTextField)component;
                    textField2.setText(value != null ? value.toString() : "");
                    textField2.getEmptyText().setText(KeyValuePane.formatDefaultValue(modelValue));
                }
            }
            component.setEnabled(this.myCurrentBuildFileObject != null);
        }
        this.myIsUpdating = false;
    }

    @NotNull
    private static String formatDefaultValue(@Nullable Object modelValue) {
        if (modelValue == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/KeyValuePane", "formatDefaultValue"));
            }
            return "";
        }
        String s = modelValue.toString();
        String string = !s.isEmpty() ? "(" + s + ")" : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/KeyValuePane", "formatDefaultValue"));
        }
        return string;
    }

    private boolean hasKnownValues(BuildFileKey key) {
        return this.myKeysWithKnownValues.containsKey((Object)key);
    }

    @Override
    public void insertUpdate(@NotNull DocumentEvent documentEvent) {
        if (documentEvent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/structure/KeyValuePane", "insertUpdate"));
        }
        this.updateCurrentObjectFromUi();
    }

    @Override
    public void removeUpdate(@NotNull DocumentEvent documentEvent) {
        if (documentEvent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/structure/KeyValuePane", "removeUpdate"));
        }
        this.updateCurrentObjectFromUi();
    }

    @Override
    public void changedUpdate(@NotNull DocumentEvent documentEvent) {
        if (documentEvent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/structure/KeyValuePane", "changedUpdate"));
        }
        this.updateCurrentObjectFromUi();
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.updateCurrentObjectFromUi();
        }
    }

    @NotNull
    private static String getReferencePrefix(@NotNull BuildFileKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/structure/KeyValuePane", "getReferencePrefix"));
        }
        BuildFileKey containerType = key.getContainerType();
        if (containerType != null) {
            String path = containerType.getPath();
            String lastLeaf = path.substring(path.lastIndexOf(47) + 1);
            String string = lastLeaf + ".";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/KeyValuePane", "getReferencePrefix"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/KeyValuePane", "getReferencePrefix"));
        }
        return "";
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void clearModified() {
        this.myModified = false;
    }
}

