/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.structure.AndroidModuleEditor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Disposer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleConfigurable
extends NamedConfigurable {
    private final String myDisplayName;
    private final AndroidModuleEditor myModuleEditor;
    private final Module myModule;

    public AndroidModuleConfigurable(Project project, Module module, String modulePath) {
        String moduleName = modulePath.substring(modulePath.lastIndexOf(":") + 1);
        this.myDisplayName = moduleName.isEmpty() ? project.getName() : moduleName;
        this.myModuleEditor = new AndroidModuleEditor(project, modulePath);
        this.myModule = module;
    }

    public void setDisplayName(String name) {
    }

    public Object getEditableObject() {
        return this.myModule;
    }

    public String getBannerSlogan() {
        return "Module '" + this.myDisplayName + "'";
    }

    public JComponent createOptionsPanel() {
        return this.myModuleEditor.getPanel();
    }

    @Nls
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    public boolean isModified() {
        return this.myModuleEditor.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myModuleEditor.apply();
    }

    public void reset() {
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myModuleEditor);
    }

    @Nullable
    public Icon getIcon(boolean expanded) {
        return AllIcons.Nodes.Module;
    }

    public void selectDependency(@NotNull GradleCoordinate dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/structure/AndroidModuleConfigurable", "selectDependency"));
        }
        this.myModuleEditor.selectDependency(dependency);
    }
}

