/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class ExternalAnnotationsSupport {
    private static final Logger LOG = Logger.getInstance(ExternalAnnotationsSupport.class);

    private static void checkAnnotationsJarAttached(@NotNull PsiFile file, @NotNull ProblemsHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/startup/ExternalAnnotationsSupport", "checkAnnotationsJarAttached"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/startup/ExternalAnnotationsSupport", "checkAnnotationsJarAttached"));
        }
    }

    public static void attachJdkAnnotations(@NotNull SdkModificator modificator) {
        if (modificator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/startup/ExternalAnnotationsSupport", "attachJdkAnnotations"));
        }
        String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        String releaseLocation = homePath + "/plugins/android/lib/androidAnnotations.jar";
        VirtualFile root = fileManager.findFileByUrl("jar://" + releaseLocation + "!/");
        if (root == null) {
            String developmentLocation = homePath + "/../adt/idea/android/annotations";
            root = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)developmentLocation));
        }
        if (root == null) {
            String jetbrainsDevelopmentLocation = homePath + "/android/android/annotations";
            root = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)jetbrainsDevelopmentLocation));
        }
        if (root == null) {
            LOG.error("jdk annotations not found in: " + releaseLocation);
            return;
        }
        OrderRootType annoType = AnnotationOrderRootType.getInstance();
        modificator.removeRoot(root, annoType);
        modificator.addRoot(root, annoType);
    }

    public static void addAnnotations(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/startup/ExternalAnnotationsSupport", "addAnnotations"));
        }
        SdkModificator modifier = sdk.getSdkModificator();
        ExternalAnnotationsSupport.attachJdkAnnotations(modifier);
        modifier.commitChanges();
    }

    public static void addAnnotationsIfNecessary(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/startup/ExternalAnnotationsSupport", "addAnnotationsIfNecessary"));
        }
        VirtualFile[] roots = sdk.getRootProvider().getFiles(AnnotationOrderRootType.getInstance());
        if (roots.length > 0) {
            return;
        }
        SdkModificator modifier = sdk.getSdkModificator();
        ExternalAnnotationsSupport.attachJdkAnnotations(modifier);
        modifier.commitChanges();
    }
}

