/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.sdk.wizard.SmwOldApiDirectInstall;
import com.android.tools.idea.wizard.DynamicWizard;
import com.android.tools.idea.wizard.DynamicWizardPath;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkQuickfixWizard
extends DynamicWizard {
    private final List<IPkgDesc> myRequestedPackages;

    public SdkQuickfixWizard(@Nullable Project project, @Nullable Module module, List<IPkgDesc> requestedPackages) {
        super(project, module, "SDK Quickfix Installation");
        this.myRequestedPackages = requestedPackages;
    }

    @Override
    public void init() {
        ScopedStateStore state = this.getState();
        for (IPkgDesc desc : this.myRequestedPackages) {
            state.listPush(WizardConstants.INSTALL_REQUESTS_KEY, desc);
        }
        this.addPath(new SdkQuickfixPath(this.getDisposable()));
        super.init();
    }

    @Override
    public void performFinishingActions() {
    }

    @Override
    protected String getWizardActionDescription() {
        return "Provides a method for handling quickfix SDK installation actions";
    }

    private class SdkQuickfixPath
    extends DynamicWizardPath {
        private Disposable myDisposable;

        public SdkQuickfixPath(Disposable disposable) {
            this.myDisposable = disposable;
        }

        @Override
        protected void init() {
            this.addStep(new LicenseAgreementStep(this.myDisposable));
            this.addStep(new SmwOldApiDirectInstall(this.myDisposable));
        }

        @Override
        @NotNull
        public String getPathName() {
            if ("SDK Installation Quickfix" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/SdkQuickfixWizard$SdkQuickfixPath", "getPathName"));
            }
            return "SDK Installation Quickfix";
        }

        @Override
        public boolean performFinishingActions() {
            return true;
        }
    }

    public static class LaunchMe
    extends AnAction {
        public LaunchMe() {
            super("Launch SDK Quickfix Wizard");
        }

        public void actionPerformed(AnActionEvent e) {
            ArrayList requestedPackages = Lists.newArrayListWithCapacity((int)3);
            FullRevision minBuildToolsRev = FullRevision.parseRevision((String)"19.1.0");
            requestedPackages.add(PkgDesc.Builder.newBuildTool((FullRevision)minBuildToolsRev).create());
            requestedPackages.add(PkgDesc.Builder.newPlatform((AndroidVersion)new AndroidVersion(19, null), (MajorRevision)new MajorRevision(1), (FullRevision)minBuildToolsRev).create());
            SdkQuickfixWizard sdkQuickfixWizard = new SdkQuickfixWizard(null, null, requestedPackages);
            sdkQuickfixWizard.init();
            sdkQuickfixWizard.show();
        }
    }
}

