/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.sdklib.repository.local.UpdateResult;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.service.notification.NotificationHyperlink;
import com.android.tools.idea.sdk.SdkState;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import org.jetbrains.android.actions.RunAndroidSdkManagerAction;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public abstract class CheckAndroidSdkUpdates {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.sdk.CheckAndroidSdkUpdates");
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Android SDK Notification Group");

    public static void checkNow(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/sdk/CheckAndroidSdkUpdates", "checkNow"));
        }
        if (!"1".equals(System.getenv("STUDIO_SDK_CHECK"))) {
            LOG.debug("SDK check disabled by default, export STUDIO_SDK_CHECK=1 to enable it.");
            return;
        }
        final AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (sdkData == null) {
            LOG.info("Android SDK Data == null");
            return;
        }
        final SdkState state = SdkState.getInstance(sdkData);
        Runnable onSuccess = new Runnable(){

            @Override
            public void run() {
                UpdateResult updates = state.getUpdates();
                if (updates != null && !updates.getUpdatedPkgs().isEmpty()) {
                    ApplicationEx app = ApplicationManagerEx.getApplicationEx();
                    app.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CheckAndroidSdkUpdates.displayHasUpdateNotification(project, sdkData);
                        }
                    });
                }
                int n = updates == null ? 0 : updates.getUpdatedPkgs().size();
                LOG.info("Android SDK: " + n + " updates found");
            }
        };
        state.loadAsync(86400000L, true, onSuccess, null);
    }

    private static void displayHasUpdateNotification(@NotNull Project project, final @NotNull AndroidSdkData sdkData) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/sdk/CheckAndroidSdkUpdates", "displayHasUpdateNotification"));
        }
        if (sdkData == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/sdk/CheckAndroidSdkUpdates", "displayHasUpdateNotification"));
        }
        final AndroidGradleNotification notification = AndroidGradleNotification.getInstance(project);
        NotificationHyperlink sdkManagerHyperlink = new NotificationHyperlink("sdk.man.show", "Open SDK Manager"){

            @Override
            protected void execute(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/sdk/CheckAndroidSdkUpdates$2", "execute"));
                }
                RunAndroidSdkManagerAction.runSpecificSdkManager(project, sdkData.getLocalSdk().getLocation());
                Notification n = notification.getNotification();
                if (n != null) {
                    n.expire();
                }
            }
        };
        String msg = "Updates are available for the Android SDK.";
        notification.showBalloon("Android SDK", msg, NotificationType.INFORMATION, NOTIFICATION_GROUP, sdkManagerHyperlink);
    }
}

