/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.multi;

import com.google.common.collect.Sets;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum RenderPreviewMode {
    DEFAULT,
    LOCALES,
    SCREENS,
    INCLUDES,
    VARIATIONS,
    RTL,
    CUSTOM,
    API_LEVELS,
    NONE;

    private static Collection<String> ourDeletedIds;
    private static RenderPreviewMode ourCurrent;

    @NotNull
    public static RenderPreviewMode getCurrent() {
        RenderPreviewMode renderPreviewMode = ourCurrent;
        if (renderPreviewMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/multi/RenderPreviewMode", "getCurrent"));
        }
        return renderPreviewMode;
    }

    public static void setCurrent(@NotNull RenderPreviewMode current) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/multi/RenderPreviewMode", "setCurrent"));
        }
        if (ourCurrent != current) {
            ourCurrent = current;
            ourDeletedIds = null;
        }
    }

    public static boolean isDeletedId(@Nullable String id) {
        return ourDeletedIds != null && id != null && ourDeletedIds.contains(id);
    }

    public static void deleteId(@Nullable String id) {
        if (id != null) {
            if (ourDeletedIds == null) {
                ourDeletedIds = Sets.newHashSet();
            }
            ourDeletedIds.add(id);
        }
    }

    public boolean showsDeviceFrames() {
        return this == SCREENS;
    }

    static {
        ourCurrent = NONE;
    }
}

