/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.rendering.api.ViewType;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.rendering.ActionBarHandler;
import com.android.tools.idea.rendering.RenderErrorPanel;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderedImage;
import com.android.tools.idea.rendering.RenderedView;
import com.android.tools.idea.rendering.RenderedViewHierarchy;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.idea.rendering.multi.RenderPreviewManager;
import com.android.tools.idea.rendering.multi.RenderPreviewMode;
import com.google.common.base.Objects;
import com.intellij.android.designer.designSurface.graphics.DesignerGraphics;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderedPanel
extends JPanel
implements Disposable {
    private static final Integer LAYER_PROGRESS = JLayeredPane.POPUP_LAYER + 100;
    private static final boolean DEBUG_SHOW_VIEWS = false;
    protected RenderResult myRenderResult;
    protected RenderPreviewManager myPreviewManager;
    protected List<RenderedView> mySelectedViews;
    protected RenderContext myContext;
    private boolean myZoomToFit = true;
    private final List<ProgressIndicator> myProgressIndicators = new ArrayList<ProgressIndicator>();
    private final JComponent myImagePanel = new JComponent(){};
    private MyProgressPanel myProgressPanel;
    private RenderErrorPanel myErrorPanel;
    private int myErrorPanelHeight = -1;
    private boolean myShowDeviceFrames = true;

    public RenderedPanel(boolean installSelectionListeners) {
        super((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, true));
        this.updateBackgroundColor();
        this.myImagePanel.setBackground(null);
        MyImagePanelWrapper previewPanel = new MyImagePanelWrapper();
        if (installSelectionListeners) {
            previewPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (RenderedPanel.this.myRenderResult == null) {
                        return;
                    }
                    if (RenderedPanel.this.myRenderResult.getImage() != null) {
                        int x1 = mouseEvent.getX();
                        int y1 = mouseEvent.getY();
                        Point p = RenderedPanel.this.fromScreenToModel(x1 -= RenderedPanel.this.myImagePanel.getX(), y1 -= RenderedPanel.this.myImagePanel.getY());
                        if (p == null) {
                            return;
                        }
                        RenderedPanel.this.selectViewAt(p.x, p.y);
                    }
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (RenderedPanel.this.myRenderResult == null) {
                        return;
                    }
                    if (mouseEvent.getClickCount() == 2) {
                        RenderedPanel.this.switchToLayoutEditor();
                    }
                }
            });
        }
        this.add((Component)((Object)previewPanel));
        this.myErrorPanel = new RenderErrorPanel();
        this.myErrorPanel.setVisible(false);
        previewPanel.add(this.myErrorPanel, JLayeredPane.POPUP_LAYER);
        this.myProgressPanel = new MyProgressPanel();
        previewPanel.add(this.myProgressPanel, LAYER_PROGRESS);
    }

    public void setRenderContext(@Nullable RenderContext context) {
        this.myContext = context;
    }

    public Component getPaintComponent() {
        return this.myImagePanel;
    }

    private void switchToLayoutEditor() {
        if (this.myRenderResult != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    VirtualFile file = RenderedPanel.this.myRenderResult.getFile().getVirtualFile();
                    if (file != null) {
                        Project project = RenderedPanel.this.myRenderResult.getModule().getProject();
                        FileEditorManager.getInstance((Project)project).setSelectedEditor(file, "android-designer");
                    }
                }
            }, ModalityState.NON_MODAL);
        }
    }

    protected void selectViewAt(int x, int y) {
        RenderedView leaf = this.findLeaf(x, y, false);
        if (this.handleMenu(leaf)) {
            return;
        }
        while (leaf != null && leaf.tag == null) {
            leaf = leaf.getParent();
        }
        this.selectView(leaf);
    }

    private boolean handleMenu(@Nullable RenderedView leaf) {
        ViewType viewType;
        ViewInfo view;
        boolean showMenu = false;
        if (leaf != null && (view = leaf.view) != null && (viewType = view.getViewType()) != ViewType.USER) {
            XmlFile xmlFile = this.myContext.getXmlFile();
            if (ResourceHelper.getFolderType((PsiFile)xmlFile) == ResourceFolderType.MENU) {
                showMenu = true;
            }
            if (viewType == ViewType.ACTION_BAR_OVERFLOW) {
                showMenu = !ActionBarHandler.isShowingMenu(this.myContext);
            } else if (ActionBarHandler.isShowingMenu(this.myContext)) {
                for (RenderedView v = leaf.getParent(); v != null; v = v.getParent()) {
                    VirtualFile virtualFile;
                    PsiFile file;
                    if (v.tag == null) continue;
                    showMenu = true;
                    if (!"item".equals(v.tag.getName()) || (file = v.tag.getContainingFile()) == null || file == xmlFile || (virtualFile = file.getVirtualFile()) == null) break;
                    Project project = file.getProject();
                    int offset = v.tag.getTextOffset();
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile, offset);
                    FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
                    return true;
                }
            }
        }
        ActionBarHandler.showMenu(showMenu, this.myContext, true);
        return false;
    }

    @Nullable
    protected RenderedView findLeaf(int x, int y, boolean requireTag) {
        RenderedView leaf;
        RenderedViewHierarchy hierarchy = this.myRenderResult.getHierarchy();
        assert (hierarchy != null);
        if (requireTag) {
            for (leaf = hierarchy.findLeafAt(x, y); leaf != null && leaf.tag == null; leaf = leaf.getParent()) {
            }
        }
        return leaf;
    }

    protected void selectView(@Nullable RenderedView leaf) {
    }

    @Nullable
    public Point fromScreenToModel(int x, int y) {
        if (this.myRenderResult == null) {
            return null;
        }
        RenderedImage image = this.myRenderResult.getImage();
        if (image != null) {
            double zoomFactor = image.getScale();
            Rectangle imageBounds = image.getImageBounds();
            if (imageBounds != null) {
                x -= imageBounds.x;
                y -= imageBounds.y;
                double deviceFrameFactor = imageBounds.getWidth() / (double)image.getScaledWidth();
                zoomFactor *= deviceFrameFactor;
            }
            x = (int)((double)x / zoomFactor);
            y = (int)((double)y / zoomFactor);
            return new Point(x, y);
        }
        return null;
    }

    @Nullable
    public Rectangle fromScreenToModel(int x, int y, int width, int height) {
        if (this.myRenderResult == null) {
            return null;
        }
        RenderedImage image = this.myRenderResult.getImage();
        if (image != null) {
            double zoomFactor = image.getScale();
            Rectangle imageBounds = image.getImageBounds();
            if (imageBounds != null) {
                x -= imageBounds.x;
                y -= imageBounds.y;
                double deviceFrameFactor = imageBounds.getWidth() / (double)image.getScaledWidth();
                zoomFactor *= deviceFrameFactor;
            }
            x = (int)((double)x / zoomFactor);
            y = (int)((double)y / zoomFactor);
            width = (int)((double)width / zoomFactor);
            height = (int)((double)height / zoomFactor);
            return new Rectangle(x, y, width, height);
        }
        return null;
    }

    @Nullable
    public Rectangle fromModelToScreen(int x, int y, int width, int height) {
        if (this.myRenderResult == null) {
            return null;
        }
        RenderedImage image = this.myRenderResult.getImage();
        if (image != null) {
            double zoomFactor = image.getScale();
            Rectangle imageBounds = image.getImageBounds();
            if (imageBounds != null) {
                double deviceFrameFactor = imageBounds.getWidth() / (double)image.getScaledWidth();
                zoomFactor *= deviceFrameFactor;
            }
            x = (int)((double)x * zoomFactor);
            y = (int)((double)y * zoomFactor);
            width = (int)((double)width * zoomFactor);
            height = (int)((double)height * zoomFactor);
            if (imageBounds != null) {
                x += imageBounds.x;
                y += imageBounds.y;
            }
            return new Rectangle(x, y, width, height);
        }
        return null;
    }

    protected boolean paintRenderedImage(Component component, Graphics g, int px, int py) {
        if (this.myRenderResult == null) {
            return false;
        }
        RenderedImage image = this.myRenderResult.getImage();
        if (image != null) {
            image.paint(g, px, py);
            List<RenderedView> selectedViews = this.mySelectedViews;
            if (selectedViews != null && !selectedViews.isEmpty() && !this.myErrorPanel.isVisible()) {
                int height;
                Screen screen;
                int width;
                Rectangle m;
                Device device;
                Shape prevClip = g.getClip();
                Shape clip = null;
                Configuration configuration = this.myContext.getConfiguration();
                if (configuration != null && (device = configuration.getDevice()) != null && HardwareConfigHelper.isRound((Device)device) && (m = this.fromModelToScreen(0, 0, width = (screen = device.getDefaultHardware().getScreen()).getXDimension(), height = screen.getYDimension())) != null && (clip = RenderedImage.getClip(device, m.x + px, m.y + py, m.width, m.height)) != null) {
                    g.setClip(clip);
                }
                for (RenderedView selected : selectedViews) {
                    Rectangle r = this.fromModelToScreen(selected.x, selected.y, selected.w, selected.h);
                    if (r == null) continue;
                    int x = r.x + px;
                    int y = r.y + py;
                    int w = r.width;
                    int h = r.height;
                    DesignerGraphics.drawFilledRect(DrawingStyle.SELECTION, g, x, y, w, h);
                }
                if (clip != null) {
                    g.setClip(prevClip);
                }
            }
            return true;
        }
        return false;
    }

    private void paintViews(Graphics g, int px, int py) {
    }

    private void paintView(Graphics g, int px, int py, RenderedView view) {
    }

    public void setRenderResult(@NotNull RenderResult renderResult) {
        if (renderResult == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderedPanel", "setRenderResult"));
        }
        double prevScale = this.myRenderResult != null && this.myRenderResult.getImage() != null ? this.myRenderResult.getImage().getScale() : 1.0;
        this.myRenderResult = renderResult;
        RenderedImage image = this.myRenderResult.getImage();
        if (image != null) {
            Dimension fixedRenderSize;
            image.setDeviceFrameEnabled(this.myShowDeviceFrames && this.myRenderResult.getRenderService() != null && this.myRenderResult.getRenderService().getRenderingMode() == SessionParams.RenderingMode.NORMAL && this.myRenderResult.getRenderService().getShowDecorations());
            if (this.myPreviewManager != null && RenderPreviewMode.getCurrent() != RenderPreviewMode.NONE && (fixedRenderSize = this.myPreviewManager.getFixedRenderSize()) != null) {
                image.setMaxSize(fixedRenderSize.width, fixedRenderSize.height);
                image.setUseLargeShadows(false);
            }
            image.setScale(prevScale);
        }
        this.mySelectedViews = null;
        RenderLogger logger = this.myRenderResult.getLogger();
        if (logger.hasProblems()) {
            if (!this.myErrorPanel.isVisible()) {
                this.myErrorPanelHeight = -1;
            }
            this.myErrorPanel.showErrors(this.myRenderResult);
            this.myErrorPanel.setVisible(true);
        } else {
            this.myErrorPanel.setVisible(false);
        }
        this.repaint();
        if (this.myPreviewManager != null && this.myPreviewManager.hasPreviews()) {
            this.myPreviewManager.renderPreviews();
        }
    }

    public RenderResult getRenderResult() {
        return this.myRenderResult;
    }

    public void setSelectedViews(@Nullable List<RenderedView> views) {
        if (!Objects.equal(views, this.mySelectedViews)) {
            this.mySelectedViews = views;
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderedPanel", "registerIndicator"));
        }
        List<ProgressIndicator> list = this.myProgressIndicators;
        synchronized (list) {
            this.myProgressIndicators.add(indicator);
            this.myProgressPanel.showProgressIcon();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderedPanel", "unregisterIndicator"));
        }
        List<ProgressIndicator> list = this.myProgressIndicators;
        synchronized (list) {
            this.myProgressIndicators.remove(indicator);
            if (this.myProgressIndicators.size() == 0) {
                this.myProgressPanel.hideProgressIcon();
            }
        }
    }

    protected void doRevalidate() {
        this.revalidate();
        this.updateImageSize();
        this.repaint();
    }

    public void update() {
        this.revalidate();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                RenderedPanel.this.doRevalidate();
            }
        });
    }

    public void updateImageSize() {
        if (this.myRenderResult == null) {
            return;
        }
        this.updateBackgroundColor();
        RenderedImage image = this.myRenderResult.getImage();
        if (image == null) {
            this.myImagePanel.setSize(0, 0);
        } else {
            if (this.myZoomToFit) {
                double availableHeight = this.getPanelHeight();
                double availableWidth = this.getPanelWidth();
                int MIN_SIZE = 200;
                if (this.myPreviewManager != null && availableWidth > 200.0) {
                    int previewWidth = this.myPreviewManager.computePreviewWidth();
                    availableWidth = Math.max(200.0, availableWidth - (double)previewWidth);
                }
                image.zoomToFit((int)availableWidth, (int)availableHeight, false, 0, 0);
            }
            this.myImagePanel.setSize(this.getScaledImageSize());
            this.repaint();
        }
    }

    private void updateBackgroundColor() {
        Gray background;
        RenderedImage image;
        boolean useGray = false;
        if (!this.myShowDeviceFrames) {
            useGray = true;
        } else if (this.myPreviewManager != null && RenderPreviewMode.getCurrent() != RenderPreviewMode.NONE) {
            useGray = !RenderPreviewMode.getCurrent().showsDeviceFrames();
        } else if (this.myRenderResult != null && (image = this.myRenderResult.getImage()) != null) {
            Boolean framed = image.isFramed();
            if (framed == null) {
                return;
            }
            useGray = framed == false;
        }
        Object object = background = useGray ? DrawingStyle.DESIGNER_BACKGROUND_COLOR : JBColor.WHITE;
        if (this.getBackground() != background) {
            this.setBackground((Color)background);
        }
    }

    protected double getPanelHeight() {
        return this.getSize().getHeight() - 5.0;
    }

    protected double getPanelWidth() {
        return this.getSize().getWidth() - 5.0;
    }

    public void zoomOut() {
        this.myZoomToFit = false;
        if (this.myRenderResult.getImage() != null) {
            this.myRenderResult.getImage().zoomOut();
        }
        this.doRevalidate();
    }

    public void zoomIn() {
        this.myZoomToFit = false;
        if (this.myRenderResult.getImage() != null) {
            this.myRenderResult.getImage().zoomIn();
        }
        this.doRevalidate();
    }

    public void zoomActual() {
        this.myZoomToFit = false;
        if (this.myRenderResult.getImage() != null) {
            this.myRenderResult.getImage().zoomActual();
        }
        this.doRevalidate();
    }

    public void setZoomToFit(boolean zoomToFit) {
        this.myZoomToFit = zoomToFit;
        this.doRevalidate();
    }

    public boolean isZoomToFit() {
        return this.myZoomToFit;
    }

    public void dispose() {
        if (this.myPreviewManager != null) {
            this.myPreviewManager.dispose();
            this.myPreviewManager = null;
        }
        this.myErrorPanel.dispose();
        this.myErrorPanel = null;
    }

    @Nullable
    public Module getModule() {
        return this.myRenderResult != null ? this.myRenderResult.getModule() : null;
    }

    @Nullable
    public XmlFile getXmlFile() {
        return this.myRenderResult != null ? (XmlFile)this.myRenderResult.getFile() : null;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myRenderResult != null ? this.myRenderResult.getFile().getVirtualFile() : null;
    }

    public boolean hasAlphaChannel() {
        return this.myRenderResult.getImage() != null && !this.myRenderResult.getImage().hasAlphaChannel();
    }

    @NotNull
    public Component getComponent() {
        RenderedPanel renderedPanel = this;
        if (renderedPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderedPanel", "getComponent"));
        }
        return renderedPanel;
    }

    @NotNull
    public Dimension getFullImageSize() {
        RenderedImage scaledImage;
        if (this.myRenderResult != null && (scaledImage = this.myRenderResult.getImage()) != null) {
            Dimension dimension = new Dimension(scaledImage.getOriginalWidth(), scaledImage.getOriginalHeight());
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderedPanel", "getFullImageSize"));
            }
            return dimension;
        }
        Dimension dimension = RenderContext.NO_SIZE;
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderedPanel", "getFullImageSize"));
        }
        return dimension;
    }

    @NotNull
    public Dimension getScaledImageSize() {
        RenderedImage scaledImage;
        if (this.myRenderResult != null && (scaledImage = this.myRenderResult.getImage()) != null) {
            Dimension dimension = new Dimension(scaledImage.getScaledWidth(), scaledImage.getScaledHeight());
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderedPanel", "getScaledImageSize"));
            }
            return dimension;
        }
        Dimension dimension = RenderContext.NO_SIZE;
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderedPanel", "getScaledImageSize"));
        }
        return dimension;
    }

    public Component getRenderComponent() {
        return this.myImagePanel.getParent();
    }

    public void setPreviewManager(@Nullable RenderPreviewManager manager) {
        if (manager == this.myPreviewManager) {
            return;
        }
        Component renderComponent = this.getRenderComponent();
        if (this.myPreviewManager != null) {
            this.myPreviewManager.unregisterMouseListener(renderComponent);
            this.myPreviewManager.dispose();
        }
        this.myPreviewManager = manager;
        if (this.myPreviewManager != null) {
            this.myPreviewManager.registerMouseListener(renderComponent);
        }
    }

    @Nullable
    public RenderPreviewManager getPreviewManager(@Nullable RenderContext context, boolean createIfNecessary) {
        if (this.myPreviewManager == null && createIfNecessary && context != null) {
            this.setPreviewManager(new RenderPreviewManager(context));
        }
        return this.myPreviewManager;
    }

    public void setMaxSize(int width, int height) {
        RenderedImage scaledImage = this.myRenderResult.getImage();
        if (scaledImage != null) {
            scaledImage.setMaxSize(width, height);
            scaledImage.setUseLargeShadows(width <= 0);
            this.myImagePanel.revalidate();
        }
    }

    public void setDeviceFramesEnabled(boolean on) {
        RenderedImage image;
        this.myShowDeviceFrames = on;
        if (this.myRenderResult != null && (image = this.myRenderResult.getImage()) != null) {
            image.setDeviceFrameEnabled(on);
        }
    }

    private class MyProgressPanel
    extends JPanel {
        private AsyncProcessIcon mySmallProgressIcon;
        private AsyncProcessIcon myLargeProgressIcon;
        private boolean mySmall;
        private boolean myProgressVisible;

        private MyProgressPanel() {
            super(new BorderLayout());
            this.setOpaque(false);
        }

        private void setSmallIcon(boolean small) {
            if (small != this.mySmall) {
                if (this.myProgressVisible && this.getComponentCount() != 0) {
                    AsyncProcessIcon oldIcon = this.getProgressIcon();
                    oldIcon.suspend();
                }
                this.mySmall = true;
                this.removeAll();
                AsyncProcessIcon icon = this.getProgressIcon();
                this.add((Component)icon, "Center");
                if (this.myProgressVisible) {
                    icon.setVisible(true);
                    icon.resume();
                }
            }
        }

        public void showProgressIcon() {
            if (!this.myProgressVisible) {
                this.setSmallIcon(RenderedPanel.this.myRenderResult != null && RenderedPanel.this.myRenderResult.getImage() != null);
                this.myProgressVisible = true;
                this.setVisible(true);
                AsyncProcessIcon icon = this.getProgressIcon();
                if (this.getComponentCount() == 0) {
                    this.add((Component)this.getProgressIcon(), "Center");
                } else {
                    icon.setVisible(true);
                }
                icon.resume();
            }
        }

        public void hideProgressIcon() {
            if (this.myProgressVisible) {
                this.myProgressVisible = false;
                this.setVisible(false);
                AsyncProcessIcon icon = this.getProgressIcon();
                icon.setVisible(false);
                icon.suspend();
            }
        }

        @Override
        public void doLayout() {
            super.doLayout();
            if (!this.myProgressVisible) {
                return;
            }
            AsyncProcessIcon icon = this.getProgressIcon();
            Dimension size = icon.getPreferredSize();
            if (this.mySmall) {
                icon.setBounds(this.getWidth() - size.width - 1, 1, size.width, size.height);
            } else {
                icon.setBounds(this.getWidth() / 2 - size.width / 2, this.getHeight() / 2 - size.height / 2, size.width, size.height);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getProgressIcon().getPreferredSize();
        }

        @NotNull
        private AsyncProcessIcon getProgressIcon() {
            AsyncProcessIcon asyncProcessIcon = this.getProgressIcon(this.mySmall);
            if (asyncProcessIcon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderedPanel$MyProgressPanel", "getProgressIcon"));
            }
            return asyncProcessIcon;
        }

        @NotNull
        private AsyncProcessIcon getProgressIcon(boolean small) {
            if (small) {
                if (this.mySmallProgressIcon == null) {
                    this.mySmallProgressIcon = new AsyncProcessIcon("Android layout rendering");
                    Disposer.register((Disposable)RenderedPanel.this, (Disposable)this.mySmallProgressIcon);
                }
                AsyncProcessIcon asyncProcessIcon = this.mySmallProgressIcon;
                if (asyncProcessIcon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderedPanel$MyProgressPanel", "getProgressIcon"));
                }
                return asyncProcessIcon;
            }
            if (this.myLargeProgressIcon == null) {
                this.myLargeProgressIcon = new AsyncProcessIcon.Big("Android layout rendering");
                Disposer.register((Disposable)RenderedPanel.this, (Disposable)this.myLargeProgressIcon);
            }
            AsyncProcessIcon asyncProcessIcon = this.myLargeProgressIcon;
            if (asyncProcessIcon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderedPanel$MyProgressPanel", "getProgressIcon"));
            }
            return asyncProcessIcon;
        }
    }

    private class MyImagePanelWrapper
    extends JBLayeredPane {
        public MyImagePanelWrapper() {
            this.add(RenderedPanel.this.myImagePanel);
            this.setBackground(null);
            this.setOpaque(true);
        }

        public void doLayout() {
            super.doLayout();
            this.positionErrorPanel();
            RenderedPanel.this.myProgressPanel.setBounds(0, 0, this.getWidth(), this.getHeight());
            if (RenderedPanel.this.myPreviewManager == null || !RenderedPanel.this.myPreviewManager.hasPreviews()) {
                this.centerComponents();
            } else {
                RenderedImage image;
                if (RenderedPanel.this.myRenderResult != null && (image = RenderedPanel.this.myRenderResult.getImage()) != null) {
                    int fixedWidth = image.getMaxWidth();
                    int fixedHeight = image.getMaxHeight();
                    if (fixedWidth > 0) {
                        RenderedPanel.this.myImagePanel.setLocation(Math.max(0, (fixedWidth - image.getScaledWidth()) / 2), 2 + Math.max(0, (fixedHeight - image.getScaledHeight()) / 2));
                        return;
                    }
                }
                RenderedPanel.this.myImagePanel.setLocation(0, 0);
            }
        }

        private void centerComponents() {
            Rectangle bounds = this.getBounds();
            Point point = RenderedPanel.this.myImagePanel.getLocation();
            point.x = (bounds.width - RenderedPanel.this.myImagePanel.getWidth()) / 2;
            point.y = (bounds.height - RenderedPanel.this.myImagePanel.getHeight()) / 2;
            if (RenderedPanel.this.myRenderResult != null) {
                RenderedImage image;
                if (point.x <= 2 && (image = RenderedPanel.this.myRenderResult.getImage()) != null && image.hasDropShadow()) {
                    point.x += 6;
                }
                if (point.y <= 2 && (image = RenderedPanel.this.myRenderResult.getImage()) != null && image.hasDropShadow()) {
                    point.y += 6;
                }
            }
            RenderedPanel.this.myImagePanel.setLocation(point);
        }

        private void positionErrorPanel() {
            int size;
            int height = this.getHeight();
            int width = this.getWidth();
            if (RenderedPanel.this.myErrorPanelHeight == -1) {
                size = height * 3 / 4;
                int preferredHeight = RenderedPanel.this.myErrorPanel.getPreferredHeight(width) + 8;
                if (preferredHeight < size) {
                    size = Math.max(preferredHeight, Math.min(height / 4, size));
                    RenderedPanel.this.myErrorPanelHeight = size;
                }
            } else {
                size = RenderedPanel.this.myErrorPanelHeight;
            }
            RenderedPanel.this.myErrorPanel.setSize(width, size);
            RenderedPanel.this.myErrorPanel.setLocation(0, height - size);
        }

        protected void paintComponent(Graphics graphics) {
            RenderedPanel.this.paintRenderedImage((Component)((Object)this), graphics, RenderedPanel.this.myImagePanel.getX(), RenderedPanel.this.myImagePanel.getY());
            if (RenderedPanel.this.myPreviewManager != null) {
                RenderedPanel.this.myPreviewManager.paint((Graphics2D)graphics);
            }
            super.paintComponent(graphics);
        }

        public Dimension getPreferredSize() {
            return RenderedPanel.this.myImagePanel.getSize();
        }
    }
}

