/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.IncludeReference;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderedImage;
import com.android.tools.idea.rendering.RenderedViewHierarchy;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderResult {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final RenderLogger myLogger;
    @Nullable
    private final List<ViewInfo> myRootViews;
    @Nullable
    private final RenderedImage myImage;
    @Nullable
    private RenderedViewHierarchy myHierarchy;
    @Nullable
    private final RenderService myRenderService;
    @Nullable
    private final RenderSession mySession;
    @Nullable
    private IncludeReference myIncludedWithin;

    public RenderResult(@Nullable RenderService renderService, @Nullable RenderSession session, @NotNull PsiFile file, @NotNull RenderLogger logger) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/rendering/RenderResult", "<init>"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/android/tools/idea/rendering/RenderResult", "<init>"));
        }
        this.myIncludedWithin = IncludeReference.NONE;
        this.myRenderService = renderService;
        this.mySession = session;
        this.myFile = file;
        this.myLogger = logger;
        if (session != null && session.getResult().isSuccess() && renderService != null) {
            RenderedImage.ShadowType shadowType;
            List systemRootViews = session.getSystemRootViews();
            this.myRootViews = systemRootViews != null ? systemRootViews : session.getRootViews();
            Configuration configuration = renderService.getConfiguration();
            BufferedImage image = session.getImage();
            boolean alphaChannelImage = session.isAlphaChannelImage() || renderService.requiresTransparency();
            RenderedImage.ShadowType shadowType2 = shadowType = alphaChannelImage ? RenderedImage.ShadowType.NONE : RenderedImage.ShadowType.RECTANGULAR;
            if (shadowType == RenderedImage.ShadowType.NONE && renderService.isNonRectangular()) {
                shadowType = RenderedImage.ShadowType.ARBITRARY;
            } else if (HardwareConfigHelper.isRound((Device)renderService.getConfiguration().getDevice())) {
                shadowType = RenderedImage.ShadowType.ARBITRARY;
            }
            this.myImage = new RenderedImage(configuration, image, alphaChannelImage, shadowType);
        } else {
            this.myRootViews = null;
            this.myImage = null;
        }
    }

    @NotNull
    public static RenderResult createBlank(@NotNull PsiFile file, @Nullable RenderLogger logger) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderResult", "createBlank"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        RenderResult renderResult = new RenderResult(null, null, file, logger != null ? logger : new RenderLogger(null, module));
        if (renderResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderResult", "createBlank"));
        }
        return renderResult;
    }

    @Nullable
    public RenderSession getSession() {
        return this.mySession;
    }

    @NotNull
    public RenderLogger getLogger() {
        RenderLogger renderLogger = this.myLogger;
        if (renderLogger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderResult", "getLogger"));
        }
        return renderLogger;
    }

    @Nullable
    public RenderedViewHierarchy getHierarchy() {
        if (this.myHierarchy == null && this.myRootViews != null) {
            this.myHierarchy = RenderedViewHierarchy.create(this.myFile, this.myRootViews, this.myIncludedWithin != IncludeReference.NONE);
        }
        return this.myHierarchy;
    }

    @Nullable
    public RenderedImage getImage() {
        return this.myImage;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderResult", "getFile"));
        }
        return psiFile;
    }

    @Nullable
    public RenderService getRenderService() {
        return this.myRenderService;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myLogger.getModule();
        assert (module != null);
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderResult", "getModule"));
        }
        return module2;
    }

    @Nullable
    public IncludeReference getIncludedWithin() {
        return this.myIncludedWithin;
    }

    public void setIncludedWithin(@Nullable IncludeReference includedWithin) {
        this.myIncludedWithin = includedWithin;
    }
}

