/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.tools.idea.rendering.ShowExceptionFix;
import com.android.utils.HtmlBuilder;
import com.android.utils.XmlUtils;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RenderProblem
implements Comparable<RenderProblem> {
    public static final int PRIORITY_UNEXPECTED = 10;
    public static final int PRIORITY_MISSING_CLASSES = 20;
    public static final int PRIORITY_BROKEN_CLASSES = 30;
    public static final int PRIORITY_MISSING_ATTRIBUTE = 40;
    public static final int PRIORITY_MISSING_STYLE = 50;
    public static final int PRIORITY_NINEPATCH_RENDER_ERROR = 60;
    public static final int PRIORITY_RENDERING_FIDELITY = 1000;
    @NotNull
    private final HighlightSeverity mySeverity;
    private final int myOrdinal;
    private int myPriority;
    @Nullable
    private Throwable myThrowable;
    @Nullable
    private Object myClientData;
    @Nullable
    private String myTag;
    private static int ourNextOrdinal;

    @NotNull
    public static RenderProblem createPlain(@NotNull HighlightSeverity severity, @Nullable String message) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderProblem", "createPlain"));
        }
        Plain plain = new Plain(severity, ourNextOrdinal++, message != null ? XmlUtils.toXmlTextValue((String)message) : "");
        if (plain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderProblem", "createPlain"));
        }
        return plain;
    }

    @NotNull
    public static RenderProblem createPlain(@NotNull HighlightSeverity severity, @NotNull String message, @NotNull Project project, @NotNull HtmlLinkManager linkManager, @Nullable Throwable throwable) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderProblem", "createPlain"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/rendering/RenderProblem", "createPlain"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/rendering/RenderProblem", "createPlain"));
        }
        if (linkManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/android/tools/idea/rendering/RenderProblem", "createPlain"));
        }
        Html problem = new Html(severity, ourNextOrdinal++);
        HtmlBuilder builder = problem.getHtmlBuilder();
        builder.add(message);
        if (throwable != null) {
            String url = linkManager.createRunnableLink(new ShowExceptionFix(project, throwable));
            builder.add(" (").addLink("Details", url).add(")");
        }
        Html html = problem;
        if (html == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderProblem", "createPlain"));
        }
        return html;
    }

    @NotNull
    public static Html create(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderProblem", "create"));
        }
        Html html = new Html(severity, ourNextOrdinal++);
        if (html == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderProblem", "create"));
        }
        return html;
    }

    @NotNull
    public static RenderProblem createDeferred(@NotNull HighlightSeverity severity, @Nullable String tag, @NotNull String text, @Nullable Throwable throwable) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderProblem", "createDeferred"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/rendering/RenderProblem", "createDeferred"));
        }
        Deferred deferred = new Deferred(severity, tag, text, throwable);
        if (deferred == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderProblem", "createDeferred"));
        }
        return deferred;
    }

    private RenderProblem(@NotNull HighlightSeverity severity, int ordinal) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderProblem", "<init>"));
        }
        this.myPriority = 10;
        this.mySeverity = severity;
        this.myOrdinal = ordinal;
    }

    public RenderProblem throwable(@Nullable Throwable throwable) {
        this.myThrowable = throwable;
        return this;
    }

    public RenderProblem priority(int priority) {
        this.myPriority = priority;
        return this;
    }

    public RenderProblem tag(@Nullable String tag) {
        this.myTag = tag;
        return this;
    }

    @Nullable
    public String getTag() {
        return this.myTag;
    }

    @NotNull
    public abstract String getHtml();

    public void appendHtml(@NotNull StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderProblem", "appendHtml"));
        }
        stringBuilder.append(this.getHtml());
    }

    @Override
    public int compareTo(RenderProblem other) {
        if (this.mySeverity != other.mySeverity) {
            return this.mySeverity.compareTo(other.mySeverity);
        }
        if (this.myPriority != other.myPriority) {
            return this.myPriority - other.myPriority;
        }
        return this.myOrdinal - other.myOrdinal;
    }

    @NotNull
    public static String format(List<RenderProblem> messages) {
        StringBuilder sb = new StringBuilder();
        for (RenderProblem message : messages) {
            sb.append(message.getHtml());
            sb.append("<br/>\n");
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderProblem", "format"));
        }
        return string;
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = this.mySeverity;
        if (highlightSeverity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderProblem", "getSeverity"));
        }
        return highlightSeverity;
    }

    @Nullable
    public Throwable getThrowable() {
        return this.myThrowable;
    }

    public Object getClientData() {
        return this.myClientData;
    }

    public void setClientData(Object clientData) {
        this.myClientData = clientData;
    }

    public static class Deferred
    extends RenderProblem {
        protected final String myTag;
        protected final String myText;

        protected Deferred(@NotNull HighlightSeverity severity, @Nullable String tag, @NotNull String text, @Nullable Throwable throwable) {
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderProblem$Deferred", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/rendering/RenderProblem$Deferred", "<init>"));
            }
            super(severity, ourNextOrdinal++);
            this.myTag = tag;
            this.myText = text;
            this.throwable(throwable);
        }

        @Override
        @NotNull
        public String getHtml() {
            String string = new HtmlBuilder().add(this.myText).getHtml();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderProblem$Deferred", "getHtml"));
            }
            return string;
        }
    }

    public static class Html
    extends RenderProblem {
        @NotNull
        private final HtmlBuilder myBuilder;

        private Html(@NotNull HighlightSeverity severity, int ordinal) {
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderProblem$Html", "<init>"));
            }
            super(severity, ordinal);
            this.myBuilder = new HtmlBuilder();
        }

        @Override
        @NotNull
        public String getHtml() {
            String string = this.myBuilder.getHtml();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderProblem$Html", "getHtml"));
            }
            return string;
        }

        @NotNull
        public HtmlBuilder getHtmlBuilder() {
            HtmlBuilder htmlBuilder = this.myBuilder;
            if (htmlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderProblem$Html", "getHtmlBuilder"));
            }
            return htmlBuilder;
        }
    }

    public static class Plain
    extends RenderProblem {
        @NotNull
        private final String myHtml;

        private Plain(@NotNull HighlightSeverity severity, int ordinal, @NotNull String text) {
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderProblem$Plain", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/rendering/RenderProblem$Plain", "<init>"));
            }
            super(severity, ordinal);
            this.myHtml = text;
        }

        @Override
        @NotNull
        public String getHtml() {
            String string = this.myHtml;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderProblem$Plain", "getHtml"));
            }
            return string;
        }
    }
}

