/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.LayoutLog;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.ShowExceptionFix;
import com.android.utils.HtmlBuilder;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParserException;

public class RenderLogger
extends LayoutLog {
    static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.rendering.RenderLogger");
    private static final boolean LOG_ALL = Boolean.getBoolean("adt.renderLog");
    public static final String TAG_MISSING_DIMENSION = "missing.dimension";
    public static final String TAG_MISSING_FRAGMENT = "missing.fragment";
    private static Set<String> ourIgnoredFidelityWarnings;
    private static boolean ourIgnoreAllFidelityWarnings;
    private static boolean ourIgnoreFragments;
    private final Module myModule;
    private final String myName;
    private Set<String> myFidelityWarningStrings;
    private boolean myHaveExceptions;
    private Map<String, Integer> myTags;
    private List<Throwable> myTraces;
    private List<RenderProblem> myMessages;
    private List<RenderProblem> myFidelityWarnings;
    private Set<String> myMissingClasses;
    private Map<String, Throwable> myBrokenClasses;
    private Map<String, Throwable> myClassesWithIncorrectFormat;
    private String myResourceClass;
    private boolean myMissingResourceClass;
    private boolean myHasLoadedClasses;
    private HtmlLinkManager myLinkManager;
    private boolean myMissingSize;
    private List<String> myMissingFragments;
    private Object myCredential;

    public RenderLogger(@Nullable String name, @Nullable Module module) {
        this.myName = name;
        this.myModule = module;
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    public void addMessage(@NotNull RenderProblem message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderLogger", "addMessage"));
        }
        if (this.myMessages == null) {
            this.myMessages = Lists.newArrayList();
        }
        this.myMessages.add(message);
    }

    @Nullable
    public List<RenderProblem> getMessages() {
        return this.myMessages;
    }

    public boolean hasProblems() {
        return this.myHaveExceptions || this.myFidelityWarnings != null || this.myMessages != null || this.myClassesWithIncorrectFormat != null || this.myBrokenClasses != null || this.myMissingClasses != null || this.myMissingSize || this.myMissingFragments != null;
    }

    @NotNull
    public List<Throwable> getTraces() {
        List<Throwable> list = this.myTraces != null ? this.myTraces : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderLogger", "getTraces"));
        }
        return list;
    }

    @Nullable
    public List<RenderProblem> getFidelityWarnings() {
        return this.myFidelityWarnings;
    }

    public void error(@Nullable String tag, @Nullable String message, @Nullable Object data) {
        AndroidFacet facet;
        String description = RenderLogger.describe(message);
        if (LOG_ALL) {
            LOG.error(String.format("%1$s: %2$s", this.myName, description));
        }
        if (tag == null && message != null && (message.startsWith("Failed to find style ") || message.startsWith("Unable to resolve parent style name: "))) {
            tag = "resources.resolve.theme";
        }
        this.addTag(tag);
        if ("resources.resolve.theme".equals(tag) && this.myModule != null && BuildSettings.getInstance(this.myModule.getProject()).getBuildMode() == BuildMode.SOURCE_GEN && (facet = AndroidFacet.getInstance(this.myModule)) != null && facet.isGradleProject()) {
            description = "Still building project; theme resources from libraries may be missing. Layout should refresh when the build is complete.\n\n" + description;
        }
        this.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, description).tag(tag));
    }

    public void error(@Nullable String tag, @Nullable String message, @Nullable Throwable throwable, @Nullable Object data) {
        String description = RenderLogger.describe(message);
        if (LOG_ALL) {
            LOG.error(String.format("%1$s: %2$s", this.myName, description), throwable);
        }
        if (throwable != null) {
            if (throwable instanceof ClassNotFoundException) {
                return;
            }
            if (description.equals(throwable.getLocalizedMessage()) || description.equals(throwable.getMessage())) {
                description = "Exception raised during rendering: " + description;
            } else if (message == null) {
                StackTraceElement[] stackTrace = throwable.getStackTrace();
                if (stackTrace.length >= 2 && stackTrace[0].getClassName().equals("android.text.format.DateUtils") && stackTrace[1].getClassName().equals("android.widget.CalendarView")) {
                    RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                    problem.tag("59732");
                    problem.throwable(throwable);
                    HtmlBuilder builder = problem.getHtmlBuilder();
                    builder.add("<CalendarView> and <DatePicker> are broken in this version of the rendering library. Try updating your SDK in the SDK Manager when issue 59732 is fixed.");
                    builder.add(" (");
                    builder.addLink("Open Issue 59732", "http://b.android.com/59732");
                    builder.add(", ");
                    ShowExceptionFix detailsFix = new ShowExceptionFix(this.getModule().getProject(), throwable);
                    builder.addLink("Show Exception", this.getLinkManager().createRunnableLink(detailsFix));
                    builder.add(")");
                    this.addMessage(problem);
                    return;
                }
                if (stackTrace.length >= 2 && stackTrace[0].getClassName().equals("android.support.v7.widget.RecyclerView") && stackTrace[0].getMethodName().equals("onMeasure") && stackTrace[1].getClassName().equals("android.view.View") && throwable.toString().equals("java.lang.NullPointerException")) {
                    RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                    String issue = "72117";
                    problem.tag(issue);
                    problem.throwable(throwable);
                    HtmlBuilder builder = problem.getHtmlBuilder();
                    builder.add("The new RecyclerView does not yet work in Studio. We are working on a fix. ");
                    builder.add(" (");
                    builder.addLink("Open Issue " + issue, "http://b.android.com/" + issue);
                    builder.add(", ");
                    ShowExceptionFix detailsFix = new ShowExceptionFix(this.myModule.getProject(), throwable);
                    builder.addLink("Show Exception", this.getLinkManager().createRunnableLink(detailsFix));
                    builder.add(")");
                    this.addMessage(problem);
                    return;
                }
            } else if (message.startsWith("Failed to configure parser for ") && message.endsWith(".png")) {
                StackTraceElement[] frames;
                for (StackTraceElement frame : frames = throwable.getStackTrace()) {
                    if (frame.getMethodName().equals("createFromXml") && frame.getClassName().equals("android.content.res.ColorStateList")) {
                        String path = message.substring("Failed to configure parser for ".length());
                        RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                        problem.tag("bitmapAsColor");
                        HtmlBuilder builder = problem.getHtmlBuilder();
                        builder.add("Resource error: Attempted to load a bitmap as a color state list.").newline();
                        builder.add("Verify that your style/theme attributes are correct, and make sure layouts are using the right attributes.");
                        builder.newline().newline();
                        path = FileUtil.toSystemIndependentName((String)path);
                        String basePath = FileUtil.toSystemIndependentName((String)this.myModule.getProject().getBasePath());
                        if (path.startsWith(basePath) && (path = path.substring(basePath.length())).startsWith(File.separator)) {
                            path = path.substring(File.separator.length());
                        }
                        path = FileUtil.toSystemDependentName((String)path);
                        builder.add("The relevant image is ").add(path);
                        java.util.HashSet widgets = Sets.newHashSet();
                        for (StackTraceElement f : frames) {
                            String className;
                            if (!f.getMethodName().equals("<init>") || !(className = f.getClassName()).startsWith("android.widget.")) continue;
                            widgets.add(className.substring(className.lastIndexOf(46) + 1));
                        }
                        if (!widgets.isEmpty()) {
                            ArrayList sorted = Lists.newArrayList((Iterable)widgets);
                            Collections.sort(sorted);
                            builder.newline().newline().add("Widgets possibly involved: ").add(Joiner.on((String)", ").join((Iterable)sorted));
                        }
                        this.addMessage(problem);
                        return;
                    }
                    if (!frame.getClassName().startsWith("com.android.tools.")) {
                        continue;
                    }
                    break;
                }
            } else if (message.startsWith("Failed to parse file ") && throwable instanceof XmlPullParserException) {
                int index;
                XmlPullParserException e = (XmlPullParserException)throwable;
                String msg = e.getMessage();
                if (msg.startsWith("Binary XML file ") && (index = msg.indexOf(58)) != -1 && index < msg.length() - 1) {
                    msg = msg.substring(index + 1).trim();
                }
                int lineNumber = e.getLineNumber();
                int column = e.getColumnNumber();
                String path = message.substring("Failed to parse file ".length());
                RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                problem.tag("xmlParse");
                problem.throwable(throwable);
                HtmlBuilder builder = problem.getHtmlBuilder();
                if (lineNumber != -1) {
                    builder.add("Line ").add(Integer.toString(lineNumber)).add(": ");
                }
                builder.add(msg);
                if (lineNumber != -1) {
                    builder.add(" (");
                    File file = new File(path);
                    String url = HtmlLinkManager.createFilePositionUrl(file, lineNumber, column);
                    if (url != null) {
                        builder.addLink("Show", url);
                        builder.add(")");
                    }
                }
                this.addMessage(problem);
                return;
            }
            this.recordThrowable(throwable);
            this.myHaveExceptions = true;
        }
        this.addTag(tag);
        this.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, description).tag(tag).throwable(throwable));
    }

    public void recordThrowable(@NotNull Throwable throwable) {
        if (throwable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderLogger", "recordThrowable"));
        }
        if (this.myTraces == null) {
            this.myTraces = new ArrayList<Throwable>();
        }
        this.myTraces.add(throwable);
    }

    public void warning(@Nullable String tag, @NotNull String message, @Nullable Object data) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/rendering/RenderLogger", "warning"));
        }
        String description = RenderLogger.describe(message);
        if ("resources.format".equals(tag)) {
            Pattern pattern;
            Matcher matcher;
            if (description.equals("You must supply a layout_width attribute.") || description.equals("You must supply a layout_height attribute.")) {
                this.myMissingSize = true;
                this.addTag(TAG_MISSING_DIMENSION);
                return;
            }
            if (description.endsWith(" is not a valid value") && (matcher = (pattern = Pattern.compile("\"(.*)\" in attribute \"(.*)\" is not a valid value")).matcher(description)).matches()) {
                this.addTag(tag);
                RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                problem.tag(tag);
                String attribute = matcher.group(2);
                String value = matcher.group(1);
                problem.setClientData(new String[]{attribute, value});
                String url = this.getLinkManager().createEditAttributeUrl(attribute, value);
                problem.getHtmlBuilder().add(description).add(" (").addLink("Edit", url).add(")");
                this.addMessage(problem);
                return;
            }
            if (description.endsWith(" is not a valid format.") && (matcher = (pattern = Pattern.compile("\"(.*)\" in attribute \"(.*)\" is not a valid format.")).matcher(description)).matches()) {
                this.addTag(tag);
                RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                problem.tag(tag);
                String attribute = matcher.group(2);
                String value = matcher.group(1);
                problem.setClientData(new String[]{attribute, value});
                String url = this.getLinkManager().createEditAttributeUrl(attribute, value);
                problem.getHtmlBuilder().add(description).add(" (").addLink("Edit", url).add(")");
                problem.setClientData(url);
                this.addMessage(problem);
                return;
            }
        } else if (TAG_MISSING_FRAGMENT.equals(tag)) {
            if (!ourIgnoreFragments) {
                if (this.myMissingFragments == null) {
                    this.myMissingFragments = Lists.newArrayList();
                }
                String name = data instanceof String ? (String)data : null;
                this.myMissingFragments.add(name);
            }
            return;
        }
        this.addTag(tag);
        this.addMessage(RenderProblem.createPlain(HighlightSeverity.WARNING, description).tag(tag));
    }

    public void fidelityWarning(@Nullable String tag, @Nullable String message, @Nullable Throwable throwable, @Nullable Object data) {
        if (ourIgnoreAllFidelityWarnings || ourIgnoredFidelityWarnings != null && ourIgnoredFidelityWarnings.contains(message)) {
            return;
        }
        if ("colorfilter".equals(tag)) {
            return;
        }
        if ("broken".equals(tag) && ("Unable to load font AndroidEmoji.ttf".equals(message) || "Unable to load font NotoSansSymbols-Regular-Subsetted.ttf".equals(message))) {
            return;
        }
        String description = RenderLogger.describe(message);
        if (this.myFidelityWarningStrings != null && this.myFidelityWarningStrings.contains(description)) {
            return;
        }
        if (LOG_ALL) {
            LOG.warn(String.format("%1$s: %2$s", this.myName, description), throwable);
        }
        if (throwable != null) {
            this.myHaveExceptions = true;
        }
        RenderProblem.Deferred error = new RenderProblem.Deferred(HighlightSeverity.ERROR, tag, description, throwable);
        error.setClientData(description);
        if (this.myFidelityWarnings == null) {
            this.myFidelityWarnings = new ArrayList<RenderProblem>();
            this.myFidelityWarningStrings = Sets.newHashSet();
        }
        this.myFidelityWarnings.add(error);
        assert (this.myFidelityWarningStrings != null);
        this.myFidelityWarningStrings.add(description);
        this.addTag(tag);
    }

    public static void ignoreFidelityWarning(@NotNull Object clientData) {
        if (clientData == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderLogger", "ignoreFidelityWarning"));
        }
        if (ourIgnoredFidelityWarnings == null) {
            ourIgnoredFidelityWarnings = new HashSet();
        }
        ourIgnoredFidelityWarnings.add((String)clientData);
    }

    public static void ignoreAllFidelityWarnings() {
        ourIgnoreAllFidelityWarnings = true;
    }

    public static void ignoreFragments() {
        ourIgnoreFragments = true;
    }

    @NotNull
    private static String describe(@Nullable String message) {
        if (message == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderLogger", "describe"));
            }
            return "";
        }
        String string = message;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderLogger", "describe"));
        }
        return string;
    }

    private void addTag(@Nullable String tag) {
        if (tag != null) {
            Integer count;
            if (this.myTags == null) {
                this.myTags = Maps.newHashMap();
            }
            if ((count = this.myTags.get(tag)) == null) {
                this.myTags.put(tag, 1);
            } else {
                this.myTags.put(tag, count + 1);
            }
        }
    }

    public boolean seenTagPrefix(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderLogger", "seenTagPrefix"));
        }
        if (this.myTags != null) {
            for (String tag : this.myTags.keySet()) {
                if (!tag.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public int getTagCount(@NotNull String tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderLogger", "getTagCount"));
        }
        Integer count = this.myTags != null ? this.myTags.get(tag) : null;
        return count != null ? count : 0;
    }

    public HtmlLinkManager getLinkManager() {
        if (this.myLinkManager == null) {
            this.myLinkManager = new HtmlLinkManager();
        }
        return this.myLinkManager;
    }

    public void setResourceClass(@NotNull String resourceClass) {
        if (resourceClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderLogger", "setResourceClass"));
        }
        this.myResourceClass = resourceClass;
    }

    public void setMissingResourceClass(boolean missingResourceClass) {
        this.myMissingResourceClass = missingResourceClass;
    }

    public void setHasLoadedClasses(boolean hasLoadedClasses) {
        this.myHasLoadedClasses = hasLoadedClasses;
    }

    public boolean isMissingSize() {
        return this.myMissingSize;
    }

    public boolean hasLoadedClasses() {
        return this.myHasLoadedClasses;
    }

    public boolean isMissingResourceClass() {
        return this.myMissingResourceClass;
    }

    @Nullable
    public String getResourceClass() {
        return this.myResourceClass;
    }

    @Nullable
    public Map<String, Throwable> getClassesWithIncorrectFormat() {
        return this.myClassesWithIncorrectFormat;
    }

    @Nullable
    public Map<String, Throwable> getBrokenClasses() {
        return this.myBrokenClasses;
    }

    @Nullable
    public Set<String> getMissingClasses() {
        return this.myMissingClasses;
    }

    public void addMissingClass(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderLogger", "addMissingClass"));
        }
        if (!className.equals("fragment")) {
            if (this.myMissingClasses == null) {
                this.myMissingClasses = new TreeSet<String>();
            }
            this.myMissingClasses.add(className);
        }
    }

    public void addIncorrectFormatClass(@NotNull String className, @NotNull Throwable exception) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderLogger", "addIncorrectFormatClass"));
        }
        if (exception == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/rendering/RenderLogger", "addIncorrectFormatClass"));
        }
        if (this.myClassesWithIncorrectFormat == null) {
            this.myClassesWithIncorrectFormat = new HashMap<String, Throwable>();
        }
        this.myClassesWithIncorrectFormat.put(className, exception);
    }

    public void addBrokenClass(@NotNull String className, @NotNull Throwable exception) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderLogger", "addBrokenClass"));
        }
        if (exception == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/rendering/RenderLogger", "addBrokenClass"));
        }
        while (exception.getCause() != null && exception.getCause() != exception) {
            exception = exception.getCause();
        }
        if (this.myBrokenClasses == null) {
            this.myBrokenClasses = new HashMap<String, Throwable>();
        }
        this.myBrokenClasses.put(className, exception);
    }

    @Nullable
    public List<String> getMissingFragments() {
        return this.myMissingFragments;
    }

    void setCredential(@Nullable Object credential) {
        this.myCredential = credential;
    }
}

