/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.ClassConverter;
import com.android.tools.idea.rendering.InconvertibleClassError;
import com.android.tools.lint.detector.api.ClassContext;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RenderClassLoader
extends ClassLoader {
    protected static final Logger LOG = Logger.getInstance(RenderClassLoader.class);
    private ClassLoader myJarClassLoader;
    protected boolean myInsideJarClassLoader;

    public RenderClassLoader(@Nullable ClassLoader parent) {
        super(parent);
    }

    protected abstract URL[] getExternalJars();

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.myInsideJarClassLoader) {
            throw new ClassNotFoundException(name);
        }
        return this.load(name);
    }

    @NotNull
    protected Class<?> load(String name) throws ClassNotFoundException {
        Class<?> clz = this.loadClassFromJar(name);
        if (clz != null) {
            Class<?> clazz = clz;
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderClassLoader", "load"));
            }
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    protected Class<?> loadClassFromJar(@NotNull String name) {
        Object externalJars;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/RenderClassLoader", "loadClassFromJar"));
        }
        if (this.myJarClassLoader == null) {
            externalJars = this.getExternalJars();
            this.myJarClassLoader = this.createClassLoader((URL[])externalJars);
        }
        try {
            this.myInsideJarClassLoader = true;
            externalJars = this.myJarClassLoader.loadClass(name);
            return externalJars;
        }
        catch (UnsupportedClassVersionError e) {
            String relative = ClassContext.getInternalName((String)name) + ".class";
            InputStream is = this.myJarClassLoader.getResourceAsStream(relative);
            if (is == null) throw e;
            byte[] data = ByteStreams.toByteArray((InputStream)is);
            is.close();
            if (!ClassConverter.isValidClassFile(data)) {
                throw e;
            }
            byte[] rewritten = ClassConverter.rewriteClass(data);
            try {
                Class<?> clazz = this.defineClass(null, rewritten, 0, rewritten.length);
                return clazz;
            }
            catch (UnsupportedClassVersionError inner) {
                try {
                    throw InconvertibleClassError.wrap(e, name, data);
                }
                catch (Exception ex) {
                    throw e;
                }
            }
        }
        catch (ClassNotFoundException e) {
            LOG.debug((Throwable)e);
            Class<?> clazz = null;
            return clazz;
        }
        finally {
            this.myInsideJarClassLoader = false;
        }
    }

    private ClassLoader createClassLoader(URL[] externalJars) {
        return UrlClassLoader.build().parent((ClassLoader)this).urls(externalJars).allowUnescaped().noPreload().get();
    }

    @Nullable
    protected Class<?> loadClassFromClassPath(String fqcn, File classPathFolder) {
        File classFile = RenderClassLoader.findClassFile(classPathFolder, fqcn);
        if (classFile == null || !classFile.exists()) {
            return null;
        }
        return this.loadClassFile(fqcn, classFile);
    }

    @Nullable
    protected Class<?> loadClassFile(String fqcn, File classFile) {
        try {
            byte[] data = Files.toByteArray((File)classFile);
            return this.loadClass(fqcn, data);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    protected Class<?> loadClass(String fqcn, @Nullable byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return this.defineClass(null, data, 0, data.length);
        }
        catch (UnsupportedClassVersionError e) {
            if (!ClassConverter.isValidClassFile(data)) {
                throw e;
            }
            byte[] rewritten = ClassConverter.rewriteClass(data);
            try {
                return this.defineClass(null, rewritten, 0, rewritten.length);
            }
            catch (UnsupportedClassVersionError inner) {
                throw InconvertibleClassError.wrap(e, fqcn, data);
            }
        }
    }

    @Nullable
    private static File findClassFile(File parent, String className) {
        if (!parent.exists()) {
            return null;
        }
        String path = ClassContext.getInternalName((String)className).replace('/', File.separatorChar);
        File file = new File(parent, path + ".class");
        if (file.exists()) {
            return file;
        }
        if (className.indexOf(36) != -1) {
            return null;
        }
        path = className.replace('.', File.separatorChar);
        while (!(file = new File(parent, path + ".class")).exists()) {
            int last = path.lastIndexOf(File.separatorChar);
            if (last == -1) {
                return null;
            }
            path = path.substring(0, last) + '$' + path.substring(last + 1);
        }
        return file;
    }
}

