/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.Capability;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.legacy.ILegacyPullParser;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.rendering.DomPullParser;
import com.android.tools.idea.rendering.LayoutPsiPullParser;
import com.android.tools.idea.rendering.MenuLayoutParserFactory;
import com.android.tools.idea.rendering.MenuPreviewRenderer;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.ResourceHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class LayoutPullParserFactory {
    static final boolean DEBUG = false;
    private static final String TAG_APPWIDGET_PROVIDER = "appwidget-provider";
    private static final String TAG_PREFERENCE_SCREEN = "PreferenceScreen";

    public static boolean isSupported(PsiFile file) {
        ResourceFolderType folderType = ResourceHelper.getFolderType(file);
        if (folderType == null) {
            return false;
        }
        switch (folderType) {
            case LAYOUT: 
            case DRAWABLE: 
            case MENU: {
                return true;
            }
            case XML: {
                XmlTag rootTag;
                if (file instanceof XmlFile && (rootTag = ((XmlFile)file).getRootTag()) != null) {
                    String tag = rootTag.getName();
                    return tag.equals(TAG_APPWIDGET_PROVIDER);
                }
                return false;
            }
        }
        return false;
    }

    @Nullable
    public static ILayoutPullParser create(final @NotNull RenderService renderService) {
        if (renderService == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/LayoutPullParserFactory", "create"));
        }
        ResourceFolderType folderType = renderService.getFolderType();
        if (folderType == null) {
            return null;
        }
        if (!(folderType != ResourceFolderType.DRAWABLE && folderType != ResourceFolderType.MENU && folderType != ResourceFolderType.XML || ApplicationManager.getApplication().isReadAccessAllowed())) {
            return (ILayoutPullParser)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ILayoutPullParser>(){

                @Nullable
                public ILayoutPullParser compute() {
                    return LayoutPullParserFactory.create(renderService);
                }
            });
        }
        XmlFile file = renderService.getPsiFile();
        switch (folderType) {
            case LAYOUT: {
                RenderLogger logger = renderService.getLogger();
                Set<XmlTag> expandNodes = renderService.getExpandNodes();
                HardwareConfig hardwareConfig = renderService.getHardwareConfigHelper().getConfig();
                return LayoutPsiPullParser.create(file, logger, expandNodes, hardwareConfig.getDensity());
            }
            case DRAWABLE: {
                renderService.setDecorations(false);
                return LayoutPullParserFactory.createDrawableParser(file);
            }
            case MENU: {
                if (renderService.supportsCapability(Capability.ACTION_BAR)) {
                    return new MenuLayoutParserFactory(renderService).render();
                }
                renderService.setRenderingMode(SessionParams.RenderingMode.V_SCROLL);
                renderService.setDecorations(false);
                return new MenuPreviewRenderer(renderService, file).render();
            }
            case XML: {
                XmlTag rootTag = file.getRootTag();
                if (rootTag != null) {
                    String tag = rootTag.getName();
                    if (tag.equals(TAG_APPWIDGET_PROVIDER)) {
                        renderService.setDecorations(false);
                        return LayoutPullParserFactory.createWidgetParser(rootTag);
                    }
                    if (tag.equals(TAG_PREFERENCE_SCREEN)) {
                        // empty if block
                    }
                }
                return null;
            }
        }
        assert (false) : folderType;
        return null;
    }

    private static ILegacyPullParser createDrawableParser(XmlFile file) {
        org.w3c.dom.Document document = DomPullParser.createEmptyPlainDocument();
        assert (document != null);
        Element imageView = LayoutPullParserFactory.addRootElement(document, "ImageView");
        LayoutPullParserFactory.setAndroidAttr(imageView, "layout_width", "fill_parent");
        LayoutPullParserFactory.setAndroidAttr(imageView, "layout_height", "fill_parent");
        LayoutPullParserFactory.setAndroidAttr(imageView, "src", "@drawable/" + ResourceHelper.getResourceName((PsiFile)file));
        String background = AndroidPsiUtils.getRootTagAttributeSafely(file, "background", "http://schemas.android.com/tools");
        if (background != null && !background.isEmpty()) {
            LayoutPullParserFactory.setAndroidAttr(imageView, "background", background);
        }
        return new DomPullParser(document.getDocumentElement());
    }

    @Nullable
    private static ILayoutPullParser createWidgetParser(XmlTag rootTag) {
        String layout = rootTag.getAttributeValue("initialLayout", "http://schemas.android.com/apk/res/android");
        String preview = rootTag.getAttributeValue("previewImage", "http://schemas.android.com/apk/res/android");
        if (layout == null && preview == null) {
            return null;
        }
        org.w3c.dom.Document document = DomPullParser.createEmptyPlainDocument();
        assert (document != null);
        Element root = LayoutPullParserFactory.addRootElement(document, layout != null ? "include" : "ImageView");
        if (layout != null) {
            root.setAttribute("layout", layout);
            LayoutPullParserFactory.setAndroidAttr(root, "layout_width", "fill_parent");
            LayoutPullParserFactory.setAndroidAttr(root, "layout_height", "fill_parent");
        } else {
            root.setAttribute("src", preview);
            LayoutPullParserFactory.setAndroidAttr(root, "layout_width", "wrap_content");
            LayoutPullParserFactory.setAndroidAttr(root, "layout_height", "wrap_content");
        }
        return new DomPullParser(document.getDocumentElement());
    }

    public static boolean needSave(@Nullable ResourceFolderType type) {
        return type != ResourceFolderType.LAYOUT;
    }

    public static void saveFileIfNecessary(PsiFile psiFile) {
        if (!LayoutPullParserFactory.needSave(ResourceHelper.getFolderType(psiFile.getVirtualFile()))) {
            return;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return;
        }
        final FileDocumentManager fileManager = FileDocumentManager.getInstance();
        if (!fileManager.isFileModified(file)) {
            return;
        }
        final Document document = fileManager.getCachedDocument(file);
        if (document == null || !fileManager.isDocumentUnsaved(document)) {
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        fileManager.saveDocument(document);
                    }
                });
            }
        }, ModalityState.any());
    }

    protected static Element addRootElement(@NotNull org.w3c.dom.Document document, @NotNull String tag) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/LayoutPullParserFactory", "addRootElement"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/rendering/LayoutPullParserFactory", "addRootElement"));
        }
        Element root = document.createElement(tag);
        Attr attr = document.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:android");
        attr.setValue("http://schemas.android.com/apk/res/android");
        root.getAttributes().setNamedItemNS(attr);
        document.appendChild(root);
        return root;
    }

    protected static Element setAndroidAttr(Element element, String name, String value) {
        element.setAttributeNS("http://schemas.android.com/apk/res/android", name, value);
        return element;
    }

    protected static ILegacyPullParser createEmptyParser() {
        org.w3c.dom.Document document = DomPullParser.createEmptyPlainDocument();
        assert (document != null);
        Element root = LayoutPullParserFactory.addRootElement(document, "FrameLayout");
        LayoutPullParserFactory.setAndroidAttr(root, "layout_width", "fill_parent");
        LayoutPullParserFactory.setAndroidAttr(root, "layout_height", "fill_parent");
        return new DomPullParser(document.getDocumentElement());
    }
}

