/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.res2.ValueXmlHelper;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.rendering.LayoutPullParser;
import com.android.tools.idea.rendering.MenuPsiPullParser;
import com.android.tools.idea.rendering.PaddingLayoutPsiPullParser;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.ResourceHelper;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayoutPsiPullParser
extends LayoutPullParser {
    @NotNull
    private final RenderLogger myLogger;
    @NotNull
    private final List<Element> myNodeStack;
    @Nullable
    protected final Element myRoot;
    @Nullable
    private String myToolsPrefix;
    @Nullable
    protected String myAndroidPrefix;
    protected boolean myProvideViewCookies;

    @NotNull
    public static LayoutPsiPullParser create(@NotNull XmlFile file, @NotNull RenderLogger logger) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
        }
        if (ResourceHelper.getFolderType((PsiFile)file) == ResourceFolderType.MENU) {
            MenuPsiPullParser menuPsiPullParser = new MenuPsiPullParser(file, logger);
            if (menuPsiPullParser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
            }
            return menuPsiPullParser;
        }
        LayoutPsiPullParser layoutPsiPullParser = new LayoutPsiPullParser(file, logger);
        if (layoutPsiPullParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
        }
        return layoutPsiPullParser;
    }

    @NotNull
    public static LayoutPsiPullParser create(@NotNull XmlFile file, @NotNull RenderLogger logger, @Nullable Set<XmlTag> explodeNodes, @NotNull Density density) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
        }
        if (density == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
        }
        if (explodeNodes != null && !explodeNodes.isEmpty()) {
            PaddingLayoutPsiPullParser paddingLayoutPsiPullParser = new PaddingLayoutPsiPullParser(file, logger, explodeNodes, density);
            if (paddingLayoutPsiPullParser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
            }
            return paddingLayoutPsiPullParser;
        }
        LayoutPsiPullParser layoutPsiPullParser = new LayoutPsiPullParser(file, logger);
        if (layoutPsiPullParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
        }
        return layoutPsiPullParser;
    }

    @NotNull
    public static LayoutPsiPullParser create(@Nullable RenderService.AttributeFilter filter, @NotNull XmlTag root, @NotNull RenderLogger logger) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
        }
        AttributeFilteredLayoutParser attributeFilteredLayoutParser = new AttributeFilteredLayoutParser(root, logger, filter);
        if (attributeFilteredLayoutParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
        }
        return attributeFilteredLayoutParser;
    }

    protected LayoutPsiPullParser(@NotNull XmlFile file, @NotNull RenderLogger logger) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/LayoutPsiPullParser", "<init>"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/rendering/LayoutPsiPullParser", "<init>"));
        }
        this(AndroidPsiUtils.getRootTagSafely(file), logger);
    }

    protected LayoutPsiPullParser(final @Nullable XmlTag root, @NotNull RenderLogger logger) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/rendering/LayoutPsiPullParser", "<init>"));
        }
        this.myNodeStack = new ArrayList<Element>();
        this.myProvideViewCookies = true;
        this.myLogger = logger;
        if (root != null) {
            if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                if (root.isValid()) {
                    this.myAndroidPrefix = root.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
                    this.myToolsPrefix = root.getPrefixByNamespace("http://schemas.android.com/tools");
                    this.myRoot = LayoutPsiPullParser.createSnapshot(root);
                } else {
                    this.myRoot = null;
                }
            } else {
                this.myRoot = (Element)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Element>(){

                    public Element compute() {
                        if (root.isValid()) {
                            LayoutPsiPullParser.this.myAndroidPrefix = root.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
                            LayoutPsiPullParser.this.myToolsPrefix = root.getPrefixByNamespace("http://schemas.android.com/tools");
                            return LayoutPsiPullParser.createSnapshot(root);
                        }
                        return null;
                    }
                });
            }
        } else {
            this.myRoot = null;
        }
    }

    @Nullable
    protected final Element getCurrentNode() {
        if (this.myNodeStack.size() > 0) {
            return this.myNodeStack.get(this.myNodeStack.size() - 1);
        }
        return null;
    }

    @Nullable
    protected final Element getPreviousNode() {
        if (this.myNodeStack.size() > 1) {
            return this.myNodeStack.get(this.myNodeStack.size() - 2);
        }
        return null;
    }

    @Nullable
    protected final Attribute getAttribute(int i) {
        if (this.myParsingState != 2) {
            throw new IndexOutOfBoundsException();
        }
        Element uiNode = this.getCurrentNode();
        if (uiNode != null) {
            return uiNode.attributes.get(i);
        }
        return null;
    }

    protected void push(@NotNull Element node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/LayoutPsiPullParser", "push"));
        }
        this.myNodeStack.add(node);
    }

    @NotNull
    protected Element pop() {
        Element element = this.myNodeStack.remove(this.myNodeStack.size() - 1);
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/LayoutPsiPullParser", "pop"));
        }
        return element;
    }

    @Nullable
    public Object getViewCookie() {
        Element element;
        if (this.myProvideViewCookies && (element = this.getCurrentNode()) != null) {
            return element.cookie;
        }
        return null;
    }

    @Nullable
    public Object getViewKey() {
        return this.getViewCookie();
    }

    @Nullable
    public ILayoutPullParser getParser(String layoutName) {
        return null;
    }

    public String getPositionDescription() {
        return "XML DOM element depth:" + this.myNodeStack.size();
    }

    public int getAttributeCount() {
        Element node = this.getCurrentNode();
        if (node != null) {
            return node.attributes.size();
        }
        return 0;
    }

    @Nullable
    public String getAttributeName(int i) {
        Attribute attribute = this.getAttribute(i);
        if (attribute != null) {
            return attribute.name;
        }
        return null;
    }

    public String getAttributeNamespace(int i) {
        Attribute attribute = this.getAttribute(i);
        if (attribute != null) {
            return attribute.namespace;
        }
        return "";
    }

    @Nullable
    public String getAttributePrefix(int i) {
        Attribute attribute = this.getAttribute(i);
        if (attribute != null) {
            String prefix = attribute.prefix;
            if (prefix.isEmpty()) {
                prefix = null;
            }
            return prefix;
        }
        return null;
    }

    @Nullable
    public String getAttributeValue(int i) {
        Attribute attribute = this.getAttribute(i);
        if (attribute != null) {
            return attribute.value;
        }
        return null;
    }

    @Nullable
    public String getAttributeValue(String namespace, String localName) {
        Element tag = this.getCurrentNode();
        if (tag != null) {
            String layout;
            if ("layout".equals(localName) && "fragment".equals(tag.tag) && (layout = tag.getAttribute("layout", "http://schemas.android.com/tools")) != null) {
                return layout;
            }
            String value = null;
            if (namespace == null) {
                value = tag.getAttribute(localName);
            } else if (namespace.equals("http://schemas.android.com/apk/res/android")) {
                if (this.myAndroidPrefix != null) {
                    if (this.myToolsPrefix != null) {
                        for (Attribute attribute : tag.attributes) {
                            if (!localName.equals(attribute.name)) continue;
                            if (this.myToolsPrefix.equals(attribute.prefix)) {
                                value = attribute.value;
                                if (!value.isEmpty()) break;
                                value = tag.getAttribute(localName, "http://schemas.android.com/apk/res/android") != null ? null : value;
                                break;
                            }
                            if (!this.myAndroidPrefix.equals(attribute.prefix)) continue;
                            value = attribute.value;
                        }
                    } else {
                        value = tag.getAttribute(localName, "http://schemas.android.com/apk/res/android");
                    }
                } else {
                    value = tag.getAttribute(localName, namespace);
                }
            } else {
                for (Attribute attribute : tag.attributes) {
                    if (!localName.equals(attribute.name) || !namespace.equals(attribute.namespace) && !"http://schemas.android.com/apk/res-auto".equals(attribute.namespace)) continue;
                    value = attribute.value;
                    break;
                }
            }
            if (value != null) {
                if ("match_parent".equals(value) && ("layout_width".equals(localName) || "layout_height".equals(localName)) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                    return "fill_parent";
                }
                int n = value.length();
                for (int i = 0; i < n; ++i) {
                    char c = value.charAt(i);
                    if (c != '&' && c != '\\') continue;
                    value = ValueXmlHelper.unescapeResourceString((String)value, (boolean)true, (boolean)false);
                    break;
                }
            }
            return value;
        }
        return null;
    }

    public int getDepth() {
        return this.myNodeStack.size();
    }

    @Nullable
    public String getName() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            Element currentNode = this.getCurrentNode();
            assert (currentNode != null);
            String name = currentNode.tag;
            if (name.equals("fragment")) {
                String layout = currentNode.getAttribute("layout", "http://schemas.android.com/tools");
                if (layout != null) {
                    return "include";
                }
                String fragmentId = currentNode.getAttribute("class");
                if ((fragmentId == null || fragmentId.isEmpty()) && ((fragmentId = currentNode.getAttribute("name", "http://schemas.android.com/apk/res/android")) == null || fragmentId.isEmpty())) {
                    fragmentId = currentNode.getAttribute("id", "http://schemas.android.com/apk/res/android");
                }
                this.myLogger.warning("missing.fragment", "Missing fragment association", fragmentId);
            }
            return name;
        }
        return null;
    }

    @Nullable
    public String getNamespace() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            Element currentNode = this.getCurrentNode();
            assert (currentNode != null);
            return currentNode.namespace;
        }
        return null;
    }

    @Nullable
    public String getPrefix() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            Element currentNode = this.getCurrentNode();
            assert (currentNode != null);
            String prefix = currentNode.prefix;
            if (prefix.isEmpty()) {
                prefix = null;
            }
            return prefix;
        }
        return null;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.myParsingState == 2) {
            Element currentNode = this.getCurrentNode();
            assert (currentNode != null);
            return currentNode.children.isEmpty();
        }
        throw new XmlPullParserException("Call to isEmptyElementTag while not in START_TAG", (XmlPullParser)this, null);
    }

    @Override
    protected void onNextFromStartDocument() {
        if (this.myRoot != null) {
            this.push(this.myRoot);
            this.myParsingState = 2;
        } else {
            this.myParsingState = 1;
        }
    }

    @Override
    protected void onNextFromStartTag() {
        Element node = this.getCurrentNode();
        assert (node != null);
        List<Element> children = node.children;
        if (!children.isEmpty()) {
            this.push(children.get(0));
            this.myParsingState = 2;
        } else {
            this.myParsingState = this.myParsingState == 0 ? 1 : 3;
        }
    }

    @Override
    protected void onNextFromEndTag() {
        Element node = this.getCurrentNode();
        assert (node != null);
        Element sibling = node.next;
        if (sibling != null) {
            node = sibling;
            this.pop();
            this.push(node);
            this.myParsingState = 2;
        } else {
            this.pop();
            this.myParsingState = this.myNodeStack.isEmpty() ? 1 : 3;
        }
    }

    public void setProvideViewCookies(boolean provideViewCookies) {
        this.myProvideViewCookies = provideViewCookies;
    }

    private static Element createSnapshot(XmlTag tag) {
        String prefix;
        XmlAttribute id;
        String rootTag = tag.getName();
        if (rootTag.equals("fragment")) {
            ArrayList includeAttributes;
            ArrayList attributes;
            Element element = new Element(tag, "FrameLayout", "", "");
            XmlAttribute[] psiAttributes = tag.getAttributes();
            element.attributes = attributes = Lists.newArrayListWithExpectedSize((int)psiAttributes.length);
            for (XmlAttribute psiAttribute : psiAttributes) {
                Attribute attribute = LayoutPsiPullParser.createAttributeSnapshot(psiAttribute);
                attributes.add(attribute);
            }
            Element include = new Element(null, "fragment", "", "");
            element.children = Collections.singletonList(include);
            include.children = Collections.emptyList();
            include.attributes = includeAttributes = Lists.newArrayListWithExpectedSize((int)psiAttributes.length);
            for (XmlAttribute psiAttribute : psiAttributes) {
                String localName;
                String name = psiAttribute.getName();
                if (name.startsWith("xmlns:") || (localName = psiAttribute.getLocalName()).startsWith("layout_margin") || localName.startsWith("padding") || localName.equals("id")) continue;
                Attribute attribute = LayoutPsiPullParser.createAttributeSnapshot(psiAttribute);
                includeAttributes.add(attribute);
            }
            return element;
        }
        if (rootTag.equals("FrameLayout")) {
            String visibleChild;
            String prefix2;
            Element root = LayoutPsiPullParser.createTagSnapshot(tag);
            String layout = tag.getAttributeValue("layout", "http://schemas.android.com/tools");
            if (layout != null && root.children.isEmpty() && (prefix2 = tag.getPrefixByNamespace("http://schemas.android.com/apk/res/android")) != null) {
                ArrayList attributes;
                ArrayList children = Lists.newArrayList();
                children.addAll(root.children);
                root.children = children;
                Element element = new Element(null, "include", "", "");
                children.add(element);
                element.children = Collections.emptyList();
                element.attributes = attributes = Lists.newArrayListWithExpectedSize((int)3);
                attributes.add(new Attribute("", "", "layout", layout));
                attributes.add(new Attribute("http://schemas.android.com/apk/res/android", prefix2, "layout_width", "fill_parent"));
                attributes.add(new Attribute("http://schemas.android.com/apk/res/android", prefix2, "layout_height", "fill_parent"));
            }
            if ((visibleChild = tag.getAttributeValue("visibleChildren", "http://schemas.android.com/tools")) != null) {
                HashSet indices = Sets.newHashSet();
                for (String s : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)visibleChild)) {
                    try {
                        indices.add(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {}
                }
                String prefix3 = tag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
                if (prefix3 != null) {
                    int n = root.children.size();
                    for (int i = 0; i < n; ++i) {
                        Element child = root.children.get(i);
                        boolean visible = indices.contains(i);
                        child.setAttribute("visibility", "http://schemas.android.com/apk/res/android", prefix3, visible ? "visible" : "gone");
                    }
                }
            }
            return root;
        }
        Element root = LayoutPsiPullParser.createTagSnapshot(tag);
        if ((rootTag.equals("ListView") || rootTag.equals("ExpandableListView") || rootTag.equals("GridView") || rootTag.equals("Spinner")) && (id = tag.getAttribute("id", "http://schemas.android.com/apk/res/android")) == null && (prefix = tag.getPrefixByNamespace("http://schemas.android.com/apk/res/android")) != null) {
            root.attributes.add(new Attribute("http://schemas.android.com/apk/res/android", prefix, "id", "@+id/_dynamic"));
        }
        return root;
    }

    private static Element createTagSnapshot(XmlTag tag) {
        ArrayList attributes;
        Element element = new Element(tag);
        XmlAttribute[] psiAttributes = tag.getAttributes();
        element.attributes = attributes = Lists.newArrayListWithExpectedSize((int)psiAttributes.length);
        for (XmlAttribute psiAttribute : psiAttributes) {
            Attribute attribute = LayoutPsiPullParser.createAttributeSnapshot(psiAttribute);
            attributes.add(attribute);
        }
        XmlTag[] subTags = tag.getSubTags();
        if (subTags.length > 0) {
            ArrayList children;
            Element last = null;
            element.children = children = Lists.newArrayListWithExpectedSize((int)subTags.length);
            for (XmlTag subTag : subTags) {
                Element child = LayoutPsiPullParser.createTagSnapshot(subTag);
                children.add(child);
                if (last != null) {
                    last.next = child;
                }
                last = child;
            }
        } else {
            element.children = Collections.emptyList();
        }
        return element;
    }

    private static Attribute createAttributeSnapshot(XmlAttribute psiAttribute) {
        String localName = psiAttribute.getLocalName();
        String namespace = psiAttribute.getNamespace();
        String prefix = psiAttribute.getNamespacePrefix();
        String value = psiAttribute.getValue();
        return new Attribute(namespace, prefix, localName, value);
    }

    static class AttributeFilteredLayoutParser
    extends LayoutPsiPullParser {
        @Nullable
        private final RenderService.AttributeFilter myFilter;

        public AttributeFilteredLayoutParser(@NotNull XmlTag root, @NotNull RenderLogger logger, @Nullable RenderService.AttributeFilter filter) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/LayoutPsiPullParser$AttributeFilteredLayoutParser", "<init>"));
            }
            if (logger == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/rendering/LayoutPsiPullParser$AttributeFilteredLayoutParser", "<init>"));
            }
            super(root, logger);
            this.myFilter = filter;
        }

        public AttributeFilteredLayoutParser(@NotNull XmlFile file, @NotNull RenderLogger logger, @Nullable RenderService.AttributeFilter filter) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/LayoutPsiPullParser$AttributeFilteredLayoutParser", "<init>"));
            }
            if (logger == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/rendering/LayoutPsiPullParser$AttributeFilteredLayoutParser", "<init>"));
            }
            super(file, logger);
            this.myFilter = filter;
        }

        @Override
        @Nullable
        public String getAttributeValue(final String namespace, final String localName) {
            String value;
            XmlTag tag;
            Element element;
            if (this.myFilter != null && (element = this.getCurrentNode()) != null && (tag = element.cookie) != null && (value = ApplicationManager.getApplication().isReadAccessAllowed() ? this.myFilter.getAttribute(tag, namespace, localName) : (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                @Nullable
                public String compute() {
                    return AttributeFilteredLayoutParser.this.myFilter.getAttribute(tag, namespace, localName);
                }
            })) != null) {
                if (value.isEmpty()) {
                    return null;
                }
                return value;
            }
            return super.getAttributeValue(namespace, localName);
        }
    }

    protected static class Attribute {
        public String namespace;
        public String prefix;
        public String name;
        public String value;

        private Attribute(@Nullable String namespace, String prefix, String name, @Nullable String value) {
            this.namespace = namespace;
            this.prefix = prefix;
            this.name = name;
            this.value = value;
        }
    }

    protected static class Element {
        public final String namespace;
        public final String tag;
        public final XmlTag cookie;
        private final String prefix;
        public Element next;
        public List<Element> children;
        public List<Attribute> attributes;

        public Element(@Nullable XmlTag tag, String tagName, String prefix, String namespace) {
            this.tag = tagName;
            this.prefix = prefix;
            this.namespace = namespace;
            this.cookie = tag;
        }

        public Element(@NotNull XmlTag tag) {
            if (tag == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/LayoutPsiPullParser$Element", "<init>"));
            }
            this(tag, tag.getName(), tag.getNamespacePrefix(), tag.getNamespace());
        }

        @Nullable
        public String getAttribute(String name) {
            return this.getAttribute(name, null);
        }

        @Nullable
        public String getAttribute(String name, @Nullable String namespace) {
            for (Attribute attribute : this.attributes) {
                if (!name.equals(attribute.name) || namespace != null && !namespace.equals(attribute.namespace)) continue;
                return attribute.value;
            }
            return null;
        }

        private void setAttribute(String name, String namespace, String prefix, @Nullable String value) {
            for (Attribute attribute : this.attributes) {
                if (!name.equals(attribute.name) || namespace != null && !namespace.equals(attribute.namespace)) continue;
                this.attributes.remove(attribute);
                break;
            }
            if (value != null) {
                this.attributes.add(new Attribute(namespace, prefix, name, value));
            }
        }
    }
}

