/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.configurations.OverlayContainer;
import com.android.tools.idea.rendering.Overlay;
import com.android.tools.idea.rendering.RenderedView;
import com.android.tools.idea.rendering.RenderedViewHierarchy;
import com.google.common.collect.Lists;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncludeOverlay
extends Overlay {
    private static final int MASK_TRANSPARENCY = 160;
    private final OverlayContainer myContainer;

    public IncludeOverlay(@NotNull OverlayContainer container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/IncludeOverlay", "<init>"));
        }
        this.myContainer = container;
    }

    @Override
    public void paint(@Nullable Component component, @NotNull Graphics2D gc, int deltaX, int deltaY) {
        if (gc == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/rendering/IncludeOverlay", "paint"));
        }
        RenderedViewHierarchy viewHierarchy = this.myContainer.getViewHierarchy();
        if (viewHierarchy == null) {
            return;
        }
        List<RenderedView> includedRoots = viewHierarchy.getIncludedRoots();
        if (includedRoots == null || includedRoots.size() == 0 || component == null) {
            return;
        }
        gc.setColor(Color.GRAY);
        Composite prevComposite = gc.getComposite();
        gc.setComposite(AlphaComposite.getInstance(3, 0.627451f));
        Shape prevClip = gc.getClip();
        Shape clip = this.setScreenClip(this.myContainer, component, gc, deltaX, deltaY);
        Collection<Rectangle> masks = this.computeMasks(component, includedRoots);
        for (Rectangle r : masks) {
            gc.fillRect(r.x + deltaX, r.y + deltaY, r.width, r.height);
        }
        gc.setComposite(prevComposite);
        if (clip != null) {
            gc.setClip(prevClip);
        }
    }

    protected Collection<Rectangle> computeMasks(Component component, List<RenderedView> includedRoots) {
        Dimension fullImageSize = this.myContainer.getFullImageSize();
        Rectangle whole = new Rectangle(0, 0, fullImageSize.width, fullImageSize.height);
        whole = this.myContainer.fromModel(component, whole);
        ArrayList includedBounds = Lists.newArrayListWithExpectedSize((int)includedRoots.size());
        for (RenderedView view : includedRoots) {
            includedBounds.add(this.myContainer.fromModel(component, view.getBounds()));
        }
        return IncludeOverlay.subtractRectangles(whole, includedBounds);
    }

    static Collection<Rectangle> subtractRectangles(Rectangle rectangle, Collection<Rectangle> holes) {
        ArrayList<Rectangle> result = new ArrayList<Rectangle>();
        result.add(rectangle);
        for (Rectangle hole : holes) {
            ArrayList<Rectangle> tempResult = new ArrayList<Rectangle>();
            for (Rectangle r : result) {
                if (hole.intersects(r)) {
                    Rectangle h = hole.intersection(r);
                    if (h.y > r.y) {
                        tempResult.add(new Rectangle(r.x, r.y, r.width, h.y - r.y));
                    }
                    if (h.x > r.x) {
                        tempResult.add(new Rectangle(r.x, h.y, h.x - r.x, h.height));
                    }
                    int hx2 = h.x + h.width;
                    int hy2 = h.y + h.height;
                    int rx2 = r.x + r.width;
                    int ry2 = r.y + r.height;
                    if (hy2 < ry2) {
                        tempResult.add(new Rectangle(r.x, hy2, r.width, ry2 - hy2));
                    }
                    if (hx2 >= rx2) continue;
                    tempResult.add(new Rectangle(hx2, h.y, rx2 - hx2, h.height));
                    continue;
                }
                tempResult.add(r);
            }
            result = tempResult;
        }
        return result;
    }
}

