/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.annotations.Nullable;
import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.LanguageQualifier;
import com.android.ide.common.resources.configuration.RegionQualifier;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.Function;
import icons.AndroidIcons;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class FlagManager {
    private static final FlagManager ourInstance = new FlagManager();
    @NotNull
    private final Map<String, Icon> myImageMap = Maps.newHashMap();

    @NotNull
    public static FlagManager get() {
        FlagManager flagManager = ourInstance;
        if (flagManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/FlagManager", "get"));
        }
        return flagManager;
    }

    private FlagManager() {
    }

    @Nullable
    public Icon getFlag(@Nullable String language, @Nullable String region) {
        assert (region != null || language != null);
        if (region == null || region.isEmpty()) {
            Icon flag;
            assert (language != null);
            Locale locale = Locale.getDefault();
            if (language.equals(locale.getLanguage()) && (flag = this.getFlag(locale.getCountry())) != null) {
                return flag;
            }
            region = language.equals("ca") ? "catalonia" : (language.equals("gd") ? "scotland" : (language.equals("cy") ? "wales" : LocaleManager.getLanguageRegion((String)language)));
        }
        if (region == null || region.isEmpty()) {
            return null;
        }
        return this.getIcon(region);
    }

    @Nullable
    public Icon getFlag(@Nullable LanguageQualifier language, @Nullable RegionQualifier region) {
        String regionCode;
        String languageCode = language != null ? language.getValue() : null;
        String string = regionCode = region != null ? region.getValue() : null;
        if ("__".equals(languageCode)) {
            languageCode = null;
        }
        if ("__".equals(regionCode)) {
            regionCode = null;
        }
        return this.getFlag(languageCode, regionCode);
    }

    @Nullable
    public Icon getFlagForFolderName(@NotNull String folder) {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/FlagManager", "getFlagForFolderName"));
        }
        RegionQualifier region = null;
        LanguageQualifier language = null;
        for (String qualifier : Splitter.on((char)'-').split((CharSequence)folder)) {
            if (qualifier.length() == 3) {
                region = RegionQualifier.getQualifier((String)qualifier);
                if (region == null) continue;
                break;
            }
            if (qualifier.length() != 2 || language != null) continue;
            language = LanguageQualifier.getQualifier((String)qualifier);
        }
        if (region != null || language != null) {
            return FlagManager.get().getFlag(language, region);
        }
        return null;
    }

    @Nullable
    public Icon getFlag(@NotNull String region) {
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/FlagManager", "getFlag"));
        }
        assert (region.length() == 2 && Character.isUpperCase(region.charAt(0)) && Character.isUpperCase(region.charAt(1))) : region;
        return this.getIcon(region);
    }

    @Nullable
    private Icon getIcon(@NotNull String base) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/FlagManager", "getIcon"));
        }
        Icon flagImage = this.myImageMap.get(base);
        if (flagImage == null) {
            if (this.myImageMap.containsKey(base)) {
                return null;
            }
            String flagFileName = base.toLowerCase(Locale.US) + ".png";
            try {
                flagImage = IconLoader.findIcon((String)("/icons/flags/" + flagFileName), AndroidIcons.class);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (flagImage == null) {
                flagImage = AndroidIcons.EmptyFlag;
            }
            this.myImageMap.put(base, flagImage);
        }
        return flagImage;
    }

    @NotNull
    public ListCellRenderer getLanguageCodeCellRenderer() {
        final Function<Object, String> nameMapper = FlagManager.getLanguageNameMapper();
        ColoredListCellRenderer coloredListCellRenderer = new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                this.append((String)nameMapper.fun(value));
                this.setIcon(FlagManager.this.getFlag((String)value, null));
            }
        };
        if (coloredListCellRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/FlagManager", "getLanguageCodeCellRenderer"));
        }
        return coloredListCellRenderer;
    }

    @NotNull
    public ListCellRenderer getRegionCodeCellRenderer() {
        final Function<Object, String> nameMapper = FlagManager.getRegionNameMapper();
        ColoredListCellRenderer coloredListCellRenderer = new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                this.append((String)nameMapper.fun(value));
                this.setIcon(FlagManager.this.getFlag(null, (String)value));
            }
        };
        if (coloredListCellRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/FlagManager", "getRegionCodeCellRenderer"));
        }
        return coloredListCellRenderer;
    }

    @NotNull
    public static Function<Object, String> getLanguageNameMapper() {
        Function<Object, String> function = new Function<Object, String>(){

            public String fun(Object value) {
                String languageCode = (String)value;
                return String.format("%1$s: %2$s", languageCode, LocaleManager.getLanguageName((String)languageCode));
            }
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/FlagManager", "getLanguageNameMapper"));
        }
        return function;
    }

    @NotNull
    public static Function<Object, String> getRegionNameMapper() {
        Function<Object, String> function = new Function<Object, String>(){

            public String fun(Object value) {
                String regionCode = (String)value;
                return String.format("%1$s: %2$s", regionCode, LocaleManager.getRegionName((String)regionCode));
            }
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/FlagManager", "getRegionNameMapper"));
        }
        return function;
    }
}

