/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.annotations.NonNull;
import com.android.ide.common.res2.DataSet;
import com.android.ide.common.res2.DuplicateDataException;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ResourceMerger;
import com.android.ide.common.res2.ResourceSet;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.LogWrapper;
import com.android.utils.ILogger;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.SoftValueHashMap;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileResourceRepository
extends LocalResourceRepository {
    private static final Logger LOG = Logger.getInstance(FileResourceRepository.class);
    protected final Map<ResourceType, ListMultimap<String, ResourceItem>> mItems;
    private final File myFile;
    private static final SoftValueHashMap<File, FileResourceRepository> ourCache = new SoftValueHashMap();

    private FileResourceRepository(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/FileResourceRepository", "<init>"));
        }
        super(file.getName());
        this.mItems = Maps.newEnumMap(ResourceType.class);
        this.myFile = file;
    }

    @NotNull
    static FileResourceRepository get(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/FileResourceRepository", "get"));
        }
        FileResourceRepository repository = (FileResourceRepository)((Object)ourCache.get((Object)file));
        if (repository == null) {
            repository = FileResourceRepository.create(file);
            ourCache.put((Object)file, (Object)repository);
        }
        FileResourceRepository fileResourceRepository = repository;
        if (fileResourceRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/FileResourceRepository", "get"));
        }
        return fileResourceRepository;
    }

    @Nullable
    static FileResourceRepository getCached(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/FileResourceRepository", "getCached"));
        }
        return (FileResourceRepository)((Object)ourCache.get((Object)file));
    }

    @NotNull
    private static FileResourceRepository create(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/FileResourceRepository", "create"));
        }
        FileResourceRepository repository = new FileResourceRepository(file);
        try {
            ResourceMerger resourceMerger = FileResourceRepository.createResourceMerger(file);
            resourceMerger.mergeData(repository.createMergeConsumer(), true);
        }
        catch (Exception e) {
            LOG.error("Failed to initialize resources", (Throwable)e);
        }
        FileResourceRepository fileResourceRepository = repository;
        if (fileResourceRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/FileResourceRepository", "create"));
        }
        return fileResourceRepository;
    }

    public static void reset() {
        ourCache.clear();
    }

    public File getResourceDirectory() {
        return this.myFile;
    }

    private static ResourceMerger createResourceMerger(File file) {
        LogWrapper logger = new LogWrapper(LOG);
        ResourceMerger merger = new ResourceMerger();
        ResourceSet resourceSet = new ResourceSet(file.getName()){

            protected void checkItems() throws DuplicateDataException {
            }
        };
        resourceSet.addSource(file);
        try {
            resourceSet.loadFromFiles((ILogger)logger);
        }
        catch (DuplicateDataException e) {
            assert (false);
        }
        catch (MergingException e) {
            LOG.warn((Throwable)e);
        }
        merger.addDataSet((DataSet)resourceSet);
        return merger;
    }

    @NonNull
    protected Map<ResourceType, ListMultimap<String, ResourceItem>> getMap() {
        return this.mItems;
    }

    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(ResourceType type, boolean create) {
        ArrayListMultimap multimap = this.mItems.get(type);
        if (multimap == null && create) {
            multimap = ArrayListMultimap.create();
            this.mItems.put(type, (ListMultimap<String, ResourceItem>)multimap);
        }
        return multimap;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " for " + this.myFile + ": @" + Integer.toHexString(System.identityHashCode((Object)this));
    }
}

