/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.RenderSecurityManager;
import com.android.ide.common.rendering.api.ActionBarCallback;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.ResourceHelper;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionBarHandler
extends ActionBarCallback {
    private static final String ON_CREATE_OPTIONS_MENU = "onCreateOptionsMenu";
    private static final Pattern MENU_FIELD_PATTERN = Pattern.compile("R\\.menu\\.([a-z0-9_]+)");
    private final Object myCredential;
    @NotNull
    private RenderService myRenderService;
    @Nullable
    private List<String> myMenus;
    private static boolean ourShowMenu = false;

    ActionBarHandler(@NotNull RenderService renderService, @Nullable Object credential) {
        if (renderService == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/rendering/ActionBarHandler", "<init>"));
        }
        this.myRenderService = renderService;
        this.myCredential = credential;
    }

    public boolean getSplitActionBarWhenNarrow() {
        ManifestInfo.ActivityAttributes attributes = this.getActivityAttributes();
        if (attributes != null) {
            return "splitActionBarWhenNarrow".equals(attributes.getUiOptions());
        }
        return false;
    }

    public static boolean isShowingMenu(@Nullable RenderContext context) {
        return ourShowMenu;
    }

    public static boolean showMenu(boolean showMenu, @Nullable RenderContext context, boolean repaint) {
        if (showMenu != ourShowMenu) {
            ourShowMenu = showMenu;
            if (context != null && repaint) {
                context.requestRender();
            }
            return true;
        }
        return false;
    }

    public boolean isOverflowPopupNeeded() {
        return ourShowMenu || ResourceHelper.getFolderType((PsiFile)this.myRenderService.getPsiFile()) == ResourceFolderType.MENU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMenuIdNames() {
        if (this.myMenus != null) {
            return this.myMenus;
        }
        boolean token = RenderSecurityManager.enterSafeRegion((Object)this.myCredential);
        try {
            final XmlFile xmlFile = this.myRenderService.getPsiFile();
            String commaSeparatedMenus = AndroidPsiUtils.getRootTagAttributeSafely(xmlFile, "menu", "http://schemas.android.com/tools");
            if (commaSeparatedMenus != null) {
                this.myMenus = new ArrayList<String>();
                Iterables.addAll(this.myMenus, (Iterable)Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)commaSeparatedMenus));
            } else {
                String context = AndroidPsiUtils.getRootTagAttributeSafely(xmlFile, "context", "http://schemas.android.com/tools");
                if (context != null && !context.isEmpty()) {
                    boolean startsWithDot;
                    boolean bl = startsWithDot = context.charAt(0) == '.';
                    if (startsWithDot || context.indexOf(46) == -1) {
                        String pkg = ManifestInfo.get(this.myRenderService.getModule(), false).getPackage();
                        context = startsWithDot ? pkg + context : pkg + '.' + context;
                    }
                    final String fqn = context;
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            Project project = xmlFile.getProject();
                            PsiClass clz = JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.allScope((Project)project));
                            if (clz != null) {
                                for (PsiMethod method : clz.findMethodsByName(ActionBarHandler.ON_CREATE_OPTIONS_MENU, true)) {
                                    if (method instanceof PsiCompiledElement) continue;
                                    String matchText = method.getText();
                                    Matcher matcher = MENU_FIELD_PATTERN.matcher(matchText);
                                    TreeSet menus = Sets.newTreeSet();
                                    int index = 0;
                                    while (matcher.find(index)) {
                                        menus.add(matcher.group(1));
                                        index = matcher.end();
                                    }
                                    if (menus.isEmpty()) continue;
                                    ActionBarHandler.this.myMenus = new ArrayList(menus);
                                }
                            }
                        }
                    });
                }
            }
            if (this.myMenus == null) {
                this.myMenus = Collections.emptyList();
            }
        }
        finally {
            RenderSecurityManager.exitSafeRegion((boolean)token);
        }
        return this.myMenus;
    }

    public ActionBarCallback.HomeButtonStyle getHomeButtonStyle() {
        ManifestInfo.ActivityAttributes attributes = this.getActivityAttributes();
        if (attributes != null && attributes.getParentActivity() != null) {
            return ActionBarCallback.HomeButtonStyle.SHOW_HOME_AS_UP;
        }
        return ActionBarCallback.HomeButtonStyle.NONE;
    }

    public int getNavigationMode() {
        XmlFile xmlFile = this.myRenderService.getPsiFile();
        String navMode = StringUtil.notNullize((String)AndroidPsiUtils.getRootTagAttributeSafely(xmlFile, "actionBarNavMode", "http://schemas.android.com/tools")).trim();
        if (navMode.equalsIgnoreCase("tabs")) {
            return 2;
        }
        if (navMode.equalsIgnoreCase("list")) {
            return 1;
        }
        return 0;
    }

    public void setMenuIdNames(@Nullable List<String> menus) {
        this.myMenus = menus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ManifestInfo.ActivityAttributes getActivityAttributes() {
        boolean token = RenderSecurityManager.enterSafeRegion((Object)this.myCredential);
        try {
            ManifestInfo manifest = ManifestInfo.get(this.myRenderService.getModule(), false);
            String activity = StringUtil.notNullize((String)this.myRenderService.getConfiguration().getActivity());
            ManifestInfo.ActivityAttributes activityAttributes = manifest.getActivityAttributes(activity);
            return activityAttributes;
        }
        finally {
            RenderSecurityManager.exitSafeRegion((boolean)token);
        }
    }
}

