/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.navigator.nodes.AndroidProjectViewNode;
import com.android.tools.idea.navigator.nodes.AndroidResFileNode;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResGroupNode
extends ProjectViewNode<List<PsiFile>>
implements AndroidProjectViewNode {
    @NotNull
    private final String myResName;
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final List<PsiFile> myFiles;

    public AndroidResGroupNode(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull List<PsiFile> files, @NotNull String resName, @NotNull ViewSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/navigator/nodes/AndroidResGroupNode", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/navigator/nodes/AndroidResGroupNode", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/navigator/nodes/AndroidResGroupNode", "<init>"));
        }
        if (resName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/android/tools/idea/navigator/nodes/AndroidResGroupNode", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/android/tools/idea/navigator/nodes/AndroidResGroupNode", "<init>"));
        }
        super(project, files, settings);
        this.myResName = resName;
        this.myFacet = facet;
        this.myFiles = files;
    }

    @Override
    @NotNull
    public AndroidFacet getAndroidFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidResGroupNode", "getAndroidFacet"));
        }
        return androidFacet;
    }

    @Override
    @NotNull
    public PsiDirectory[] getDirectories() {
        List psiFiles = (List)this.getValue();
        PsiDirectory[] folders = new PsiDirectory[psiFiles.size()];
        for (int i = 0; i < psiFiles.size(); ++i) {
            folders[i] = ((PsiFile)psiFiles.get(i)).getParent();
        }
        if (folders == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidResGroupNode", "getDirectories"));
        }
        return folders;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/navigator/nodes/AndroidResGroupNode", "contains"));
        }
        for (PsiFile psiFile : this.myFiles) {
            if (!psiFile.getVirtualFile().equals(file)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList children = Lists.newArrayListWithExpectedSize((int)this.myFiles.size());
        for (PsiFile file : this.myFiles) {
            children.add(new AndroidResFileNode(this.myProject, file, this.getSettings(), this.myFacet));
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidResGroupNode", "getChildren"));
        }
        return arrayList;
    }

    protected void update(PresentationData presentation) {
        presentation.setPresentableText(this.myResName);
        presentation.addText(this.myResName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myFiles.size() > 1) {
            presentation.addText(String.format(" (%1$d)", this.myFiles.size()), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        presentation.setIcon(PlatformIcons.PACKAGE_ICON);
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        StringBuilder sb = new StringBuilder(this.myResName);
        sb.append(" (");
        sb.append(this.myFiles.size());
        sb.append(")");
        return sb.toString();
    }
}

