/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.resources.ScreenSize;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PrimaryManifestInfo
extends ManifestInfo {
    private static final Logger LOG = Logger.getInstance(PrimaryManifestInfo.class);
    private final Module myModule;
    private String myPackage;
    private String myManifestTheme;
    private Map<String, ManifestInfo.ActivityAttributes> myActivityAttributesMap;
    private ManifestFile myManifestFile;
    private long myLastChecked;
    private AndroidVersion myMinSdk;
    private AndroidVersion myTargetSdk;
    private String myApplicationIcon;
    private String myApplicationLabel;
    private boolean myApplicationSupportsRtl;
    private Manifest myManifest;
    private Boolean myApplicationDebuggable;

    PrimaryManifestInfo(Module module) {
        this.myModule = module;
    }

    @Override
    public void clear() {
        this.myLastChecked = 0L;
    }

    @Override
    @Nullable
    public String getPackage() {
        this.sync();
        return this.myPackage;
    }

    @Override
    @NotNull
    public Map<String, ManifestInfo.ActivityAttributes> getActivityAttributesMap() {
        this.sync();
        if (this.myActivityAttributesMap == null) {
            Map<String, ManifestInfo.ActivityAttributes> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/PrimaryManifestInfo", "getActivityAttributesMap"));
            }
            return map;
        }
        Map<String, ManifestInfo.ActivityAttributes> map = this.myActivityAttributesMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/PrimaryManifestInfo", "getActivityAttributesMap"));
        }
        return map;
    }

    @Override
    @Nullable
    public ManifestInfo.ActivityAttributes getActivityAttributes(@NotNull String activity) {
        if (activity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/model/PrimaryManifestInfo", "getActivityAttributes"));
        }
        int index = activity.indexOf(46);
        if (index <= 0 && this.myPackage != null && !this.myPackage.isEmpty()) {
            activity = this.myPackage + (index == -1 ? "." : "") + activity;
        }
        return this.getActivityAttributesMap().get(activity);
    }

    @Override
    @Nullable
    public String getManifestTheme() {
        this.sync();
        return this.myManifestTheme;
    }

    @Override
    @NotNull
    public String getDefaultTheme(@Nullable IAndroidTarget renderingTarget, @Nullable ScreenSize screenSize, @Nullable Device device) {
        AndroidModuleInfo info;
        this.sync();
        if (this.myManifestTheme != null) {
            String string = this.myManifestTheme;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/PrimaryManifestInfo", "getDefaultTheme"));
            }
            return string;
        }
        if (device != null) {
            if (HardwareConfigHelper.isWear((Device)device)) {
                if ("@android:style/Theme.DeviceDefault.Light" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/PrimaryManifestInfo", "getDefaultTheme"));
                }
                return "@android:style/Theme.DeviceDefault.Light";
            }
            if (HardwareConfigHelper.isTv((Device)device)) {
                if ("@style/Theme.Leanback" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/PrimaryManifestInfo", "getDefaultTheme"));
                }
                return "@style/Theme.Leanback";
            }
        }
        int targetSdk = (info = AndroidModuleInfo.get(this.myModule)) != null ? info.getTargetSdkVersion().getApiLevel() : (this.myTargetSdk != null ? this.myTargetSdk.getApiLevel() : 21);
        int renderingTargetSdk = targetSdk;
        if (renderingTarget instanceof CompatibilityRenderTarget) {
            renderingTargetSdk = renderingTarget.getVersion().getApiLevel();
        } else if (renderingTarget != null) {
            renderingTargetSdk = renderingTarget.getVersion().getApiLevel();
        }
        int apiLevel = Math.min(targetSdk, renderingTargetSdk);
        if (apiLevel >= 11 && screenSize == ScreenSize.XLARGE || apiLevel >= 14) {
            if ("@android:style/Theme.Holo" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/PrimaryManifestInfo", "getDefaultTheme"));
            }
            return "@android:style/Theme.Holo";
        }
        if ("@android:style/Theme" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/PrimaryManifestInfo", "getDefaultTheme"));
        }
        return "@android:style/Theme";
    }

    @Override
    @Nullable
    public String getApplicationIcon() {
        this.sync();
        return this.myApplicationIcon;
    }

    @Override
    @Nullable
    public String getApplicationLabel() {
        this.sync();
        return this.myApplicationLabel;
    }

    @Override
    public boolean isRtlSupported() {
        this.sync();
        return this.myApplicationSupportsRtl;
    }

    @Override
    @Nullable
    public Boolean getApplicationDebuggable() {
        this.sync();
        return this.myApplicationDebuggable;
    }

    @Override
    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        this.sync();
        AndroidVersion androidVersion = this.myTargetSdk != null ? this.myTargetSdk : this.getMinSdkVersion();
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/PrimaryManifestInfo", "getTargetSdkVersion"));
        }
        return androidVersion;
    }

    @Override
    @NotNull
    public AndroidVersion getMinSdkVersion() {
        this.sync();
        AndroidVersion androidVersion = this.myMinSdk != null ? this.myMinSdk : AndroidVersion.DEFAULT;
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/PrimaryManifestInfo", "getMinSdkVersion"));
        }
        return androidVersion;
    }

    @Override
    @NotNull
    protected List<Manifest> getManifests() {
        this.sync();
        List<Manifest> list = this.myManifest != null ? Collections.singletonList(this.myManifest) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/PrimaryManifestInfo", "getManifests"));
        }
        return list;
    }

    private void sync() {
        long now = System.currentTimeMillis();
        if (now - this.myLastChecked < 50L && this.myManifestFile != null) {
            return;
        }
        this.myLastChecked = now;
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PrimaryManifestInfo.this.syncWithReadPermission();
            }
        });
    }

    private void syncWithReadPermission() {
        boolean refresh;
        if (this.myManifestFile == null) {
            this.myManifestFile = ManifestFile.create(this.myModule);
            if (this.myManifestFile == null) {
                return;
            }
        }
        if (!(refresh = this.myManifestFile.refresh())) {
            return;
        }
        this.myActivityAttributesMap = new HashMap<String, ManifestInfo.ActivityAttributes>();
        this.myManifestTheme = null;
        this.myTargetSdk = AndroidVersion.DEFAULT;
        this.myMinSdk = AndroidVersion.DEFAULT;
        this.myPackage = "";
        this.myApplicationIcon = null;
        this.myApplicationLabel = null;
        this.myApplicationSupportsRtl = false;
        try {
            XmlTag[] usesSdks;
            XmlFile xmlFile = this.myManifestFile.getXmlFile();
            if (xmlFile == null) {
                return;
            }
            XmlTag root = xmlFile.getRootTag();
            if (root == null) {
                return;
            }
            this.myPackage = root.getAttributeValue("package");
            XmlTag[] applications = root.findSubTags("application");
            if (applications.length > 0) {
                XmlTag[] activities;
                assert (applications.length == 1);
                XmlTag application = applications[0];
                this.myApplicationIcon = application.getAttributeValue("icon", "http://schemas.android.com/apk/res/android");
                this.myApplicationLabel = application.getAttributeValue("label", "http://schemas.android.com/apk/res/android");
                this.myManifestTheme = application.getAttributeValue("theme", "http://schemas.android.com/apk/res/android");
                this.myApplicationSupportsRtl = "true".equals(application.getAttributeValue("supportsRtl", "http://schemas.android.com/apk/res/android"));
                String debuggable = application.getAttributeValue("debuggable", "http://schemas.android.com/apk/res/android");
                this.myApplicationDebuggable = debuggable == null ? null : Boolean.valueOf("true".equals(debuggable));
                for (XmlTag activity : activities = application.findSubTags("activity")) {
                    ManifestInfo.ActivityAttributes attributes = new ManifestInfo.ActivityAttributes(activity, this.myPackage);
                    this.myActivityAttributesMap.put(attributes.getName(), attributes);
                }
            }
            if ((usesSdks = root.findSubTags("uses-sdk")).length > 0) {
                XmlTag usesSdk = usesSdks[0];
                this.myMinSdk = PrimaryManifestInfo.getApiVersion(usesSdk, "minSdkVersion", AndroidVersion.DEFAULT);
                this.myTargetSdk = PrimaryManifestInfo.getApiVersion(usesSdk, "targetSdkVersion", this.myMinSdk);
            }
            this.myManifest = AndroidUtils.loadDomElementWithReadPermission(this.myModule.getProject(), xmlFile, Manifest.class);
        }
        catch (Exception e) {
            LOG.error("Could not read Manifest data", (Throwable)e);
        }
    }

    private static AndroidVersion getApiVersion(XmlTag usesSdk, String attribute, AndroidVersion defaultApiLevel) {
        AndroidVersion version;
        String valueString = usesSdk.getAttributeValue(attribute, "http://schemas.android.com/apk/res/android");
        if (valueString != null && (version = SdkVersionInfo.getVersion((String)valueString, null)) != null) {
            return version;
        }
        return defaultApiLevel;
    }

    private static class ManifestFile {
        private final Module myModule;
        private VirtualFile myVFile;
        private XmlFile myXmlFile;
        private long myLastModified;

        private ManifestFile(@NotNull Module module, @NotNull VirtualFile file) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/model/PrimaryManifestInfo$ManifestFile", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/model/PrimaryManifestInfo$ManifestFile", "<init>"));
            }
            this.myLastModified = 0L;
            this.myModule = module;
            this.myVFile = file;
        }

        @Nullable
        public static synchronized ManifestFile create(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/model/PrimaryManifestInfo$ManifestFile", "create"));
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) {
                return null;
            }
            VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(facet);
            if (manifestFile == null) {
                return null;
            }
            return new ManifestFile(module, manifestFile);
        }

        @Nullable
        private XmlFile parseManifest() {
            if (this.myVFile == null || !this.myVFile.exists()) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)this.myModule.getProject()).findFile(this.myVFile);
            return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        }

        public synchronized boolean refresh() {
            long lastModified = this.getLastModified();
            if (this.myXmlFile == null || this.myLastModified < lastModified) {
                this.myXmlFile = this.parseManifest();
                if (this.myXmlFile == null) {
                    return false;
                }
                this.myLastModified = lastModified;
                return true;
            }
            return false;
        }

        private long getLastModified() {
            if (this.myXmlFile != null) {
                return this.myXmlFile.getModificationStamp();
            }
            return 0L;
        }

        @Nullable
        public synchronized XmlFile getXmlFile() {
            return this.myXmlFile;
        }
    }
}

