/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.proguard;

import com.android.tools.idea.lang.proguard.ProguardFileType;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProguardFileTypeFactory
extends FileTypeFactory {
    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/lang/proguard/ProguardFileTypeFactory", "createFileTypes"));
        }
        consumer.consume((FileType)ProguardFileType.INSTANCE, new FileNameMatcher[]{new ProguardNameMatcher()});
    }

    private static class ProguardNameMatcher
    implements FileNameMatcher {
        private ProguardNameMatcher() {
        }

        public boolean accept(@NonNls @NotNull String fileName) {
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/lang/proguard/ProguardFileTypeFactory$ProguardNameMatcher", "accept"));
            }
            return fileName.endsWith(".pro") || fileName.endsWith(".txt") && fileName.startsWith("proguard-");
        }

        @NotNull
        public String getPresentableString() {
            if ("*.pro or proguard-*.txt" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/proguard/ProguardFileTypeFactory$ProguardNameMatcher", "getPresentableString"));
            }
            return "*.pro or proguard-*.txt";
        }
    }
}

