/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.ui;

import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import icons.AndroidIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VariantCheckboxTreeCellRenderer
extends CheckboxTree.CheckboxTreeCellRenderer {
    protected void appendVariant(@NotNull String variant) {
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/variant/ui/VariantCheckboxTreeCellRenderer", "appendVariant"));
        }
        ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
        textRenderer.append(variant, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
        textRenderer.setIcon(AndroidIcons.Variant);
    }

    protected void appendModule(@NotNull Module module, @Nullable String variant) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/variant/ui/VariantCheckboxTreeCellRenderer", "appendModule"));
        }
        ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
        textRenderer.append(module.getName());
        textRenderer.setIcon(GradleUtil.getModuleIcon(module));
        if (StringUtil.isNotEmpty((String)variant)) {
            textRenderer.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            textRenderer.append("(" + variant + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }
}

