/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.conflict;

import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictResolutionDialog;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public final class ConflictResolution {
    private ConflictResolution() {
    }

    public static boolean solveSelectionConflicts(@NotNull Collection<Conflict> conflicts) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/variant/conflict/ConflictResolution", "solveSelectionConflicts"));
        }
        boolean atLeastOneSolved = false;
        for (Conflict conflict : conflicts) {
            if (!ConflictResolution.solveSelectionConflict(conflict, false)) continue;
            atLeastOneSolved = true;
        }
        return atLeastOneSolved;
    }

    public static boolean solveSelectionConflict(@NotNull Conflict conflict) {
        if (conflict == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/variant/conflict/ConflictResolution", "solveSelectionConflict"));
        }
        return ConflictResolution.solveSelectionConflict(conflict, true);
    }

    private static boolean solveSelectionConflict(@NotNull Conflict conflict, boolean showConflictResolutionDialog) {
        String selectedVariant;
        ConflictResolutionDialog dialog;
        if (conflict == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/variant/conflict/ConflictResolution", "solveSelectionConflict"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(conflict.getSource());
        if (facet == null || !facet.isGradleProject()) {
            return true;
        }
        IdeaAndroidProject source = facet.getIdeaAndroidProject();
        if (source == null) {
            return false;
        }
        Collection<String> variants = conflict.getVariants();
        if (variants.size() == 1) {
            String expectedVariant = (String)ContainerUtil.getFirstItem(variants);
            if (StringUtil.isNotEmpty((String)expectedVariant)) {
                source.setSelectedVariantName(expectedVariant);
                facet.syncSelectedVariant();
                return true;
            }
        } else if (showConflictResolutionDialog && (dialog = new ConflictResolutionDialog(conflict)).showAndGet() && StringUtil.isNotEmpty((String)(selectedVariant = dialog.getSelectedVariant()))) {
            source.setSelectedVariantName(selectedVariant);
            facet.syncSelectedVariant();
            return true;
        }
        return false;
    }
}

