/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.SystemProperties;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalProperties {
    private static final String HEADER_COMMENT = LocalProperties.getHeaderComment();
    @NotNull
    private final File myFilePath;
    @NotNull
    private final Properties myProperties;

    @NotNull
    private static String getHeaderComment() {
        Object[] lines = new String[]{"# This file is automatically generated by Android Studio.", "# Do not modify this file -- YOUR CHANGES WILL BE ERASED!", "#", "# This file must *NOT* be checked into Version Control Systems,", "# as it contains information specific to your local configuration.", "", "# Location of the SDK. This is only used by Gradle.", "# For customization when using a Version Control System, please read the", "# header note."};
        String string = Joiner.on((String)SystemProperties.getLineSeparator()).join(lines);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/LocalProperties", "getHeaderComment"));
        }
        return string;
    }

    public LocalProperties(@NotNull Project project) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/LocalProperties", "<init>"));
        }
        this(new File(project.getBasePath()));
    }

    public LocalProperties(@NotNull File projectDirPath) throws IOException {
        if (projectDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/LocalProperties", "<init>"));
        }
        this.myFilePath = new File(projectDirPath, "local.properties");
        this.myProperties = LocalProperties.readFile(this.myFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Properties readFile(@NotNull File filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/LocalProperties", "readFile"));
        }
        if (filePath.isDirectory()) {
            throw new IllegalArgumentException(String.format("The path '%1$s' belongs to a directory!", filePath.getPath()));
        }
        if (!filePath.exists()) {
            Properties properties = new Properties();
            if (properties == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/LocalProperties", "readFile"));
            }
            return properties;
        }
        Properties properties = new Properties();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(filePath)), Charsets.UTF_8);
            properties.load(reader);
        }
        catch (Throwable throwable) {
            Closeables.close(reader, (boolean)true);
            throw throwable;
        }
        Closeables.close((Closeable)reader, (boolean)true);
        Properties properties2 = properties;
        if (properties2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/LocalProperties", "readFile"));
        }
        return properties2;
    }

    @Nullable
    public File getAndroidSdkPath() {
        String path = this.myProperties.getProperty("sdk.dir");
        if (path != null && !path.isEmpty()) {
            return new File(FileUtil.toSystemDependentName((String)path));
        }
        return null;
    }

    public void setAndroidSdkPath(@NotNull Sdk androidSdk) {
        if (androidSdk == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/LocalProperties", "setAndroidSdkPath"));
        }
        String androidSdkPath = androidSdk.getHomePath();
        assert (androidSdkPath != null);
        this.setAndroidSdkPath(androidSdkPath);
    }

    public void setAndroidSdkPath(@NotNull String androidSdkPath) {
        if (androidSdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/LocalProperties", "setAndroidSdkPath"));
        }
        String path = FileUtil.toSystemIndependentName((String)androidSdkPath);
        this.myProperties.setProperty("sdk.dir", path);
    }

    public void setAndroidSdkPath(@NotNull File androidSdkPath) {
        if (androidSdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/LocalProperties", "setAndroidSdkPath"));
        }
        this.myProperties.setProperty("sdk.dir", androidSdkPath.getPath());
    }

    public boolean hasAndroidDirProperty() {
        String property = this.myProperties.getProperty("android.dir");
        return !Strings.isNullOrEmpty((String)property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        FileUtilRt.createParentDirs((File)this.myFilePath);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.myFilePath);
            this.myProperties.store(out, HEADER_COMMENT);
        }
        catch (Throwable throwable) {
            Closeables.close(out, (boolean)true);
            throw throwable;
        }
        Closeables.close((Closeable)out, (boolean)true);
    }

    @NotNull
    public File getFilePath() {
        File file = this.myFilePath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/LocalProperties", "getFilePath"));
        }
        return file;
    }
}

