/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.NotificationHyperlink;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

class ToggleOfflineModeHyperlink
extends NotificationHyperlink {
    private final boolean myEnableOfflineMode;

    @Nullable
    static ToggleOfflineModeHyperlink enableOfflineMode(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/ToggleOfflineModeHyperlink", "enableOfflineMode"));
        }
        GradleSettings settings = GradleSettings.getInstance((Project)project);
        return settings.isOfflineWork() ? null : new ToggleOfflineModeHyperlink(true);
    }

    @Nullable
    static ToggleOfflineModeHyperlink disableOfflineMode(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/ToggleOfflineModeHyperlink", "disableOfflineMode"));
        }
        GradleSettings settings = GradleSettings.getInstance((Project)project);
        return !settings.isOfflineWork() ? null : new ToggleOfflineModeHyperlink(false);
    }

    private ToggleOfflineModeHyperlink(boolean enableOfflineMode) {
        super("toggle.offline.mode", ToggleOfflineModeHyperlink.getText(enableOfflineMode));
        this.myEnableOfflineMode = enableOfflineMode;
    }

    @NotNull
    private static String getText(boolean enableOfflineMode) {
        String msg = enableOfflineMode ? "Enable" : "Disable";
        String string = msg + " Gradle 'offline mode' and sync project";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/notification/ToggleOfflineModeHyperlink", "getText"));
        }
        return string;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/ToggleOfflineModeHyperlink", "execute"));
        }
        GradleSettings.getInstance((Project)project).setOfflineWork(this.myEnableOfflineMode);
        GradleProjectImporter.getInstance().requestProjectSync(project, null);
    }
}

