/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.NotificationHyperlink;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

class FixBuildToolsVersionHyperlink
extends NotificationHyperlink {
    @NotNull
    private final VirtualFile myBuildFile;
    @NotNull
    private final String myVersion;

    FixBuildToolsVersionHyperlink(@NotNull VirtualFile buildFile, @NotNull String version) {
        if (buildFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/FixBuildToolsVersionHyperlink", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/service/notification/FixBuildToolsVersionHyperlink", "<init>"));
        }
        super("fix.build.tools.version", "Update Build Tools version and sync project");
        this.myBuildFile = buildFile;
        this.myVersion = version;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/FixBuildToolsVersionHyperlink", "execute"));
        }
        FixBuildToolsVersionHyperlink.fixBuildToolsVersionAndSync(project, this.myBuildFile, this.myVersion);
    }

    static void fixBuildToolsVersionAndSync(@NotNull Project project, @NotNull VirtualFile buildFile, final @NotNull String version) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/service/notification/FixBuildToolsVersionHyperlink", "fixBuildToolsVersionAndSync"));
        }
        if (buildFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/service/notification/FixBuildToolsVersionHyperlink", "fixBuildToolsVersionAndSync"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/service/notification/FixBuildToolsVersionHyperlink", "fixBuildToolsVersionAndSync"));
        }
        final GradleBuildFile gradleBuildFile = new GradleBuildFile(buildFile, project);
        Object pluginVersion = gradleBuildFile.getValue(BuildFileKey.BUILD_TOOLS_VERSION);
        if (pluginVersion != null) {
            WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    gradleBuildFile.setValue(BuildFileKey.BUILD_TOOLS_VERSION, version);
                }
            });
            GradleProjectImporter.getInstance().requestProjectSync(project, null);
        }
    }
}

