/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.AndroidGradleProjectComponent;
import com.android.tools.idea.gradle.project.ChooseGradleHomeDialog;
import com.android.tools.idea.gradle.project.GradleProjectDependencyParser;
import com.android.tools.idea.gradle.project.GradleSiblingLookup;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.project.ModuleToImport;
import com.android.tools.idea.gradle.project.NewProjectImportGradleSyncListener;
import com.android.tools.idea.gradle.project.OpenMigrationToGradleUrlHyperlink;
import com.android.tools.idea.gradle.project.PostProjectSetupTasksExecutor;
import com.android.tools.idea.gradle.project.ProjectValidator;
import com.android.tools.idea.gradle.project.SdkSync;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectImporter {
    private static final Logger LOG = Logger.getInstance(GradleProjectImporter.class);
    private static final ProjectSystemId SYSTEM_ID = GradleConstants.SYSTEM_ID;
    private final ImporterDelegate myDelegate;
    public static boolean ourSkipSetupFromTest;

    @NotNull
    public static GradleProjectImporter getInstance() {
        GradleProjectImporter gradleProjectImporter = (GradleProjectImporter)ServiceManager.getService(GradleProjectImporter.class);
        if (gradleProjectImporter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleProjectImporter", "getInstance"));
        }
        return gradleProjectImporter;
    }

    public GradleProjectImporter() {
        this.myDelegate = new ImporterDelegate();
    }

    @VisibleForTesting
    GradleProjectImporter(ImporterDelegate delegate) {
        this.myDelegate = delegate;
    }

    public void importProject(@NotNull VirtualFile selectedFile) {
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "importProject"));
        }
        VirtualFile projectDir = selectedFile.isDirectory() ? selectedFile : selectedFile.getParent();
        File projectDirPath = new File(FileUtil.toSystemDependentName((String)projectDir.getPath()));
        try {
            LocalProperties localProperties = new LocalProperties(projectDirPath);
            if (AndroidStudioSpecificInitializer.isAndroidStudio()) {
                SdkSync.syncIdeAndProjectAndroidHomes(localProperties);
            }
        }
        catch (IOException e) {
            LOG.info("Failed to sync SDKs", (Throwable)e);
            Messages.showErrorDialog((String)e.getMessage(), (String)"Project Import");
            return;
        }
        new GradleSettings(ProjectManager.getInstance().getDefaultProject());
        boolean hasGradleWrapper = org.jetbrains.plugins.gradle.util.GradleUtil.isGradleDefaultWrapperFilesExist((String)projectDirPath.getPath());
        if (!hasGradleWrapper) {
            boolean validGradleHome = false;
            String gradleHome = org.jetbrains.plugins.gradle.util.GradleUtil.getLastUsedGradleHome();
            if (!gradleHome.isEmpty()) {
                GradleInstallationManager gradleInstallationManager = (GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class);
                File gradleHomePath = new File(FileUtil.toSystemDependentName((String)gradleHome));
                validGradleHome = gradleInstallationManager.isGradleSdkHome(gradleHomePath);
            }
            if (!validGradleHome) {
                ChooseGradleHomeDialog chooseGradleHomeDialog = new ChooseGradleHomeDialog();
                if (!chooseGradleHomeDialog.showAndGet()) {
                    return;
                }
                chooseGradleHomeDialog.storeLastUsedGradleHome();
            }
        }
        this.createProjectFileForGradleProject(selectedFile, null);
    }

    public void importModules(final @NotNull Map<String, VirtualFile> modules, final @Nullable Project project, final @Nullable GradleSyncListener listener) throws IOException, ConfigurationException {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "importModules"));
        }
        String error = GradleProjectImporter.validateProjectsForImport(modules);
        if (error != null) {
            if (listener != null && project != null) {
                listener.syncFailed(project, error);
                return;
            }
            throw new IOException(error);
        }
        assert (project != null);
        Throwable throwable = new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                GradleProjectImporter.this.copyAndRegisterModule(modules, project, listener);
            }

            public boolean isSilentExecution() {
                return true;
            }
        }.execute().getThrowable();
        GradleProjectImporter.rethrowAsProperlyTypedException(throwable);
    }

    @Nullable
    private static String validateProjectsForImport(@NotNull Map<String, VirtualFile> modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "validateProjectsForImport"));
        }
        TreeSet<String> projects = new TreeSet<String>();
        for (Map.Entry<String, VirtualFile> mapping : modules.entrySet()) {
            if (mapping.getValue() != null) continue;
            projects.add(mapping.getKey());
        }
        if (projects.isEmpty()) {
            return null;
        }
        if (projects.size() == 1) {
            return String.format("Sources for module '%1$s' were not found", Iterables.getFirst(projects, null));
        }
        String projectsList = Joiner.on((String)"', '").join(projects);
        return String.format("Sources were not found for modules '%1$s'", projectsList);
    }

    private static void rethrowAsProperlyTypedException(Throwable throwable) throws IOException, ConfigurationException {
        if (throwable != null) {
            Throwables.propagateIfPossible((Throwable)throwable, IOException.class, ConfigurationException.class);
            throw new IllegalStateException(throwable);
        }
    }

    private void copyAndRegisterModule(@NotNull Map<String, VirtualFile> modules, @NotNull Project project, @Nullable GradleSyncListener listener) throws IOException, ConfigurationException {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "copyAndRegisterModule"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/project/GradleProjectImporter", "copyAndRegisterModule"));
        }
        VirtualFile projectRoot = project.getBaseDir();
        if (projectRoot.findChild("settings.gradle") == null) {
            projectRoot.createChildData((Object)this, "settings.gradle");
        }
        GradleSettingsFile gradleSettingsFile = GradleSettingsFile.get(project);
        assert (gradleSettingsFile != null) : "File should have been created";
        for (Map.Entry<String, VirtualFile> module : modules.entrySet()) {
            String name = module.getKey();
            File targetFile = GradleUtil.getDefaultSubprojectLocation(projectRoot, name);
            VirtualFile moduleSource = module.getValue();
            if (moduleSource != null) {
                if (!VfsUtilCore.isAncestor((VirtualFile)projectRoot, (VirtualFile)moduleSource, (boolean)true)) {
                    VirtualFile target = VfsUtil.createDirectoryIfMissing((String)targetFile.getAbsolutePath());
                    if (target == null) {
                        throw new IOException(String.format("Unable to create directory %1$s", targetFile));
                    }
                    moduleSource.copy((Object)this, target.getParent(), target.getName());
                } else {
                    targetFile = VfsUtilCore.virtualToIoFile((VirtualFile)moduleSource);
                }
            }
            gradleSettingsFile.addModule(name, targetFile);
        }
        this.requestProjectSync(project, false, listener);
    }

    private void createProjectFileForGradleProject(@NotNull VirtualFile selectedFile, @Nullable Project parentProject) {
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "createProjectFileForGradleProject"));
        }
        VirtualFile projectDir = selectedFile.isDirectory() ? selectedFile : selectedFile.getParent();
        File projectDirPath = VfsUtilCore.virtualToIoFile((VirtualFile)projectDir);
        try {
            this.importProject(projectDir.getName(), projectDirPath, new NewProjectImportGradleSyncListener(){

                @Override
                public void syncSucceeded(@NotNull Project project) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter$2", "syncSucceeded"));
                    }
                    2.activateProjectView(project);
                }
            }, parentProject);
        }
        catch (Exception e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new RuntimeException(e);
            }
            Messages.showErrorDialog((String)e.getMessage(), (String)"Project Import");
            LOG.error((Throwable)e);
        }
    }

    public void requestProjectSync(@NotNull Project project, @Nullable GradleSyncListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "requestProjectSync"));
        }
        this.requestProjectSync(project, true, listener);
    }

    public void requestProjectSync(final @NotNull Project project, final boolean generateSourcesOnSuccess, final @Nullable GradleSyncListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "requestProjectSync"));
        }
        Runnable syncRequest = new Runnable(){

            @Override
            public void run() {
                try {
                    GradleProjectImporter.this.doRequestSync(project, ProgressExecutionMode.IN_BACKGROUND_ASYNC, generateSourcesOnSuccess, listener);
                }
                catch (ConfigurationException e) {
                    Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)e.getTitle());
                }
            }
        };
        AppUIUtil.invokeLaterIfProjectAlive((Project)project, (Runnable)syncRequest);
    }

    public void syncProjectSynchronously(final @NotNull Project project, final boolean generateSourcesOnSuccess, final @Nullable GradleSyncListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "syncProjectSynchronously"));
        }
        Runnable syncRequest = new Runnable(){

            @Override
            public void run() {
                try {
                    GradleProjectImporter.this.doRequestSync(project, ProgressExecutionMode.MODAL_SYNC, generateSourcesOnSuccess, listener);
                }
                catch (ConfigurationException e) {
                    Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)e.getTitle());
                }
            }
        };
        UIUtil.invokeAndWaitIfNeeded((Runnable)syncRequest);
    }

    private void doRequestSync(final @NotNull Project project, @NotNull ProgressExecutionMode progressExecutionMode, boolean generateSourcesOnSuccess, final @Nullable GradleSyncListener listener) throws ConfigurationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "doRequestSync"));
        }
        if (progressExecutionMode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/project/GradleProjectImporter", "doRequestSync"));
        }
        if (Projects.isGradleProject(project) || GradleProjectImporter.hasTopLevelGradleBuildFile(project)) {
            FileDocumentManager.getInstance().saveAllDocuments();
            GradleProjectImporter.setUpGradleSettings(project);
            GradleProjectImporter.resetProject(project);
            this.doImport(project, false, progressExecutionMode, generateSourcesOnSuccess, listener);
        } else {
            Runnable notificationTask = new Runnable(){

                @Override
                public void run() {
                    String msg = String.format("The project '%s' is not a Gradle-based project", project.getName());
                    AndroidGradleNotification.getInstance(project).showBalloon("Project Sync", msg, NotificationType.ERROR, new OpenMigrationToGradleUrlHyperlink());
                    if (listener != null) {
                        listener.syncFailed(project, msg);
                    }
                }
            };
            Application application = ApplicationManager.getApplication();
            if (application.isDispatchThread()) {
                notificationTask.run();
            } else {
                application.invokeLater(notificationTask);
            }
        }
    }

    private static boolean hasTopLevelGradleBuildFile(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "hasTopLevelGradleBuildFile"));
        }
        VirtualFile baseDir = project.getBaseDir();
        VirtualFile gradleBuildFile = baseDir.findChild("build.gradle");
        return gradleBuildFile != null && gradleBuildFile.exists() && !gradleBuildFile.isDirectory();
    }

    private static void resetProject(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "resetProject"));
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() {
                LibraryTable libraryTable = ProjectLibraryTable.getInstance((Project)project);
                LibraryTable.ModifiableModel model = libraryTable.getModifiableModel();
                try {
                    for (Library library : model.getLibraries()) {
                        model.removeLibrary(library);
                    }
                }
                finally {
                    model.commit();
                }
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                for (Module module : moduleManager.getModules()) {
                    AndroidFacet facet = AndroidFacet.getInstance(module);
                    if (facet == null) continue;
                    facet.setIdeaAndroidProject(null);
                }
            }
        });
    }

    public void importProject(@NotNull String projectName, @NotNull File projectRootDir, @Nullable GradleSyncListener listener, @Nullable Project project) throws IOException, ConfigurationException {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "importProject"));
        }
        if (projectRootDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/project/GradleProjectImporter", "importProject"));
        }
        this.importProject(projectName, projectRootDir, true, listener, project, null);
    }

    public void importProject(@NotNull String projectName, @NotNull File projectRootDir, boolean generateSourcesOnSuccess, @Nullable GradleSyncListener listener, @Nullable Project project, @Nullable LanguageLevel initialLanguageLevel) throws IOException, ConfigurationException {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "importProject"));
        }
        if (projectRootDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/project/GradleProjectImporter", "importProject"));
        }
        GradleProjectImporter.createTopLevelBuildFileIfNotExisting(projectRootDir);
        GradleProjectImporter.createIdeaProjectDir(projectRootDir);
        Project newProject = project == null ? GradleProjectImporter.createProject(projectName, projectRootDir.getPath()) : project;
        GradleProjectImporter.setUpProject(newProject, initialLanguageLevel);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            newProject.save();
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            if (!newProject.isOpen()) {
                Projects.open(newProject);
            }
            if (!ProjectValidator.validate(newProject, projectRootDir)) {
                NewProjectImportGradleSyncListener.createTopLevelProjectAndOpen(newProject);
                return;
            }
        }
        assert (newProject != null);
        this.doImport(newProject, true, ProgressExecutionMode.MODAL_SYNC, generateSourcesOnSuccess, listener);
    }

    public void importProject(@NotNull String projectName, @NotNull File projectRootDir, @Nullable GradleSyncListener listener) throws IOException, ConfigurationException {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "importProject"));
        }
        if (projectRootDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/project/GradleProjectImporter", "importProject"));
        }
        this.importProject(projectName, projectRootDir, listener, null);
    }

    private static void createTopLevelBuildFileIfNotExisting(@NotNull File projectRootDir) throws IOException {
        if (projectRootDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "createTopLevelBuildFileIfNotExisting"));
        }
        File projectFile = GradleUtil.getGradleBuildFilePath(projectRootDir);
        if (projectFile.isFile()) {
            return;
        }
        FileUtilRt.createIfNotExists((File)projectFile);
        String contents = "// Top-level build file where you can add configuration options common to all sub-projects/modules." + SystemProperties.getLineSeparator();
        FileUtil.writeToFile((File)projectFile, (String)contents);
    }

    private static void createIdeaProjectDir(@NotNull File projectRootDir) throws IOException {
        if (projectRootDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "createIdeaProjectDir"));
        }
        File ideaDir = new File(projectRootDir, ".idea");
        if (ideaDir.isDirectory()) {
            boolean librariesDirDeleted;
            File librariesDir = new File(ideaDir, "libraries");
            if (librariesDir.exists() && !(librariesDirDeleted = FileUtil.delete((File)librariesDir))) {
                LOG.info(String.format("Failed to delete %1$s'", librariesDir.getPath()));
            }
        } else {
            FileUtil.ensureExists((File)ideaDir);
        }
    }

    @NotNull
    private static Project createProject(@NotNull String projectName, @NotNull String projectPath) throws ConfigurationException {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "createProject"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/project/GradleProjectImporter", "createProject"));
        }
        ProjectManager projectManager = ProjectManager.getInstance();
        Project newProject = projectManager.createProject(projectName, projectPath);
        if (newProject == null) {
            throw new NullPointerException("Failed to create a new IDEA project");
        }
        Project project = newProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleProjectImporter", "createProject"));
        }
        return project;
    }

    private static void setUpProject(final @NotNull Project newProject, final @Nullable LanguageLevel initialLanguageLevel) {
        if (newProject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "setUpProject"));
        }
        CommandProcessor.getInstance().executeCommand(newProject, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        LanguageLevelProjectExtension extension;
                        if (initialLanguageLevel != null && (extension = LanguageLevelProjectExtension.getInstance((Project)newProject)) != null) {
                            extension.setLanguageLevel(initialLanguageLevel);
                        }
                        File compilerOutputDir = new File(newProject.getBasePath(), FileUtil.join((String[])new String[]{"build", "classes"}));
                        String compilerOutputDirUrl = FilePaths.pathToIdeaUrl(compilerOutputDir);
                        CompilerProjectExtension compilerProjectExt = CompilerProjectExtension.getInstance((Project)newProject);
                        assert (compilerProjectExt != null);
                        compilerProjectExt.setCompilerOutputUrl(compilerOutputDirUrl);
                        GradleProjectImporter.setUpGradleSettings(newProject);
                    }
                });
            }
        }, null, null);
    }

    private static void setUpGradleSettings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "setUpGradleSettings"));
        }
        GradleProjectSettings projectSettings = GradleUtil.getGradleProjectSettings(project);
        if (projectSettings == null) {
            projectSettings = new GradleProjectSettings();
        }
        projectSettings.setUseAutoImport(false);
        GradleProjectImporter.setUpGradleProjectSettings(project, projectSettings);
        GradleSettings gradleSettings = GradleSettings.getInstance((Project)project);
        gradleSettings.setLinkedProjectsSettings((Collection)ImmutableList.of((Object)projectSettings));
    }

    private static void setUpGradleProjectSettings(@NotNull Project project, @NotNull GradleProjectSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "setUpGradleProjectSettings"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/project/GradleProjectImporter", "setUpGradleProjectSettings"));
        }
        settings.setExternalProjectPath(FileUtil.toCanonicalPath((String)project.getBasePath()));
        DistributionType distributionType = settings.getDistributionType();
        File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
        if (wrapperPropertiesFile == null) {
            if (DistributionType.LOCAL != distributionType) {
                settings.setDistributionType(DistributionType.LOCAL);
            }
            if (StringUtil.isEmpty((String)settings.getGradleHome())) {
                settings.setGradleHome(org.jetbrains.plugins.gradle.util.GradleUtil.getLastUsedGradleHome());
            }
        } else if (distributionType == null) {
            settings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
        }
    }

    private void doImport(final @NotNull Project project, final boolean newProject, @NotNull ProgressExecutionMode progressExecutionMode, boolean generateSourcesOnSuccess, final @Nullable GradleSyncListener listener) throws ConfigurationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "doImport"));
        }
        if (progressExecutionMode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/project/GradleProjectImporter", "doImport"));
        }
        if (AndroidStudioSpecificInitializer.isAndroidStudio() && Projects.isDirectGradleInvocationEnabled(project)) {
            GradleInvoker.getInstance(project).clearConsoleAndBuildMessages();
        }
        project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)true);
        project.putUserData(Projects.HAS_UNRESOLVED_DEPENDENCIES, (Object)false);
        project.putUserData(Projects.HAS_WRONG_JDK, (Object)false);
        final Application application = ApplicationManager.getApplication();
        final boolean isTest = application.isUnitTestMode();
        PostProjectSetupTasksExecutor.getInstance(project).setGenerateSourcesAfterSync(generateSourcesOnSuccess);
        GradleSyncState.getInstance(project).syncStarted(!newProject);
        this.myDelegate.importProject(project, new ExternalProjectRefreshCallback(){

            public void onSuccess(final @Nullable DataNode<ProjectData> projectInfo) {
                assert (projectInfo != null);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        GradleProjectImporter.populateProject(project, (DataNode<ProjectData>)projectInfo);
                        if (!isTest || !ourSkipSetupFromTest) {
                            if (newProject) {
                                Projects.open(project);
                            }
                            if (!isTest) {
                                project.save();
                            }
                        }
                        if (newProject) {
                            AndroidGradleProjectComponent projectComponent = (AndroidGradleProjectComponent)((Object)ServiceManager.getService((Project)project, AndroidGradleProjectComponent.class));
                            projectComponent.configureGradleProject(false);
                        }
                        if (listener != null) {
                            listener.syncSucceeded(project);
                        }
                    }
                };
                if (application.isUnitTestMode()) {
                    runnable.run();
                } else {
                    application.invokeLater(runnable);
                }
            }

            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter$8", "onFailure"));
                }
                if (errorDetails != null) {
                    LOG.warn(errorDetails);
                }
                String newMessage = ExternalSystemBundle.message((String)"error.resolve.with.reason", (Object[])new Object[]{errorMessage});
                LOG.info(newMessage);
                GradleSyncState.getInstance(project).syncFailed(newMessage);
                if (listener != null) {
                    listener.syncFailed(project, newMessage);
                }
            }
        }, progressExecutionMode);
    }

    private static void populateProject(final @NotNull Project newProject, final @NotNull DataNode<ProjectData> projectInfo) {
        if (newProject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "populateProject"));
        }
        if (projectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/project/GradleProjectImporter", "populateProject"));
        }
        StartupManager.getInstance((Project)newProject).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                ExternalSystemApiUtil.executeProjectChangeAction((DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)newProject){

                    public void execute() {
                        ProjectRootManagerEx.getInstanceEx((Project)newProject).mergeRootsChangesDuring(new Runnable(){

                            @Override
                            public void run() {
                                ProjectDataManager dataManager = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
                                Collection modules = ExternalSystemApiUtil.findAll((DataNode)projectInfo, (Key)ProjectKeys.MODULE);
                                dataManager.importData(ProjectKeys.MODULE, modules, newProject, true);
                            }
                        });
                    }
                });
            }
        });
    }

    @NotNull
    public Set<ModuleToImport> getRelatedProjects(@NotNull VirtualFile sourceProject, @NotNull Project destinationProject) {
        if (sourceProject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "getRelatedProjects"));
        }
        if (destinationProject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/project/GradleProjectImporter", "getRelatedProjects"));
        }
        VirtualFile settingsGradle = sourceProject.findFileByRelativePath("settings.gradle");
        if (settingsGradle != null) {
            Set<ModuleToImport> set = GradleProjectImporter.buildModulesSet(GradleProjectImporter.getSubprojects(settingsGradle, destinationProject), GradleProjectDependencyParser.newInstance(destinationProject));
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleProjectImporter", "getRelatedProjects"));
            }
            return set;
        }
        Set<ModuleToImport> set = GradleProjectImporter.getRequiredProjects(sourceProject, destinationProject);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleProjectImporter", "getRelatedProjects"));
        }
        return set;
    }

    @NotNull
    private static Set<ModuleToImport> getRequiredProjects(VirtualFile sourceProject, Project destinationProject) {
        GradleSiblingLookup subprojectLocations = new GradleSiblingLookup(sourceProject, destinationProject);
        Function<VirtualFile, Iterable<String>> parser = GradleProjectDependencyParser.newInstance(destinationProject);
        HashMap modules = Maps.newHashMap();
        LinkedList toAnalyze = Lists.newLinkedList();
        toAnalyze.add(sourceProject);
        while (!toAnalyze.isEmpty()) {
            HashSet dependencies = Sets.newHashSet((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)toAnalyze, parser)));
            Iterable notAnalyzed = Iterables.filter((Iterable)dependencies, (Predicate)Predicates.not((Predicate)Predicates.in(modules.keySet())));
            HashMap dependencyToLocation = Maps.newHashMap();
            for (String dependency : notAnalyzed) {
                dependencyToLocation.put(dependency, subprojectLocations.apply(dependency));
            }
            modules.putAll(dependencyToLocation);
            toAnalyze = FluentIterable.from(dependencyToLocation.values()).filter(Predicates.notNull()).toList();
        }
        modules.put(subprojectLocations.getPrimaryProjectName(), sourceProject);
        Set<ModuleToImport> set = GradleProjectImporter.buildModulesSet(modules, parser);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleProjectImporter", "getRequiredProjects"));
        }
        return set;
    }

    private static Set<ModuleToImport> buildModulesSet(Map<String, VirtualFile> modules, Function<VirtualFile, Iterable<String>> parser) {
        com.intellij.util.containers.HashSet modulesSet = new com.intellij.util.containers.HashSet(modules.size());
        for (Map.Entry<String, VirtualFile> entry : modules.entrySet()) {
            modulesSet.add(new ModuleToImport(entry.getKey(), entry.getValue(), parser));
        }
        return modulesSet;
    }

    @NotNull
    public static Map<String, VirtualFile> getSubprojects(@NotNull VirtualFile settingsGradle, Project destinationProject) {
        if (settingsGradle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter", "getSubprojects"));
        }
        GradleSettingsFile settingsFile = new GradleSettingsFile(settingsGradle, destinationProject);
        Map<String, File> allProjects = settingsFile.getModulesWithLocation();
        Map map = Maps.transformValues(allProjects, (Function)new ResolvePath(VfsUtilCore.virtualToIoFile((VirtualFile)settingsGradle.getParent())));
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleProjectImporter", "getSubprojects"));
        }
        return map;
    }

    private static class ResolvePath
    implements Function<File, VirtualFile> {
        private final File mySourceDir;

        public ResolvePath(File sourceDir) {
            this.mySourceDir = sourceDir;
        }

        public VirtualFile apply(File path) {
            if (!path.isAbsolute()) {
                path = new File(this.mySourceDir, path.getPath());
            }
            return VfsUtil.findFileByIoFile((File)path, (boolean)true);
        }
    }

    static class ImporterDelegate {
        ImporterDelegate() {
        }

        void importProject(@NotNull Project project, @NotNull ExternalProjectRefreshCallback callback, @NotNull ProgressExecutionMode progressExecutionMode) throws ConfigurationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleProjectImporter$ImporterDelegate", "importProject"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/project/GradleProjectImporter$ImporterDelegate", "importProject"));
            }
            if (progressExecutionMode == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/project/GradleProjectImporter$ImporterDelegate", "importProject"));
            }
            try {
                String externalProjectPath = FileUtil.toCanonicalPath((String)project.getBasePath());
                ExternalSystemUtil.refreshProject((Project)project, (ProjectSystemId)SYSTEM_ID, (String)externalProjectPath, (ExternalProjectRefreshCallback)callback, (boolean)false, (ProgressExecutionMode)progressExecutionMode, (boolean)true);
            }
            catch (RuntimeException e) {
                String externalSystemName = SYSTEM_ID.getReadableName();
                throw new ConfigurationException(e.getMessage(), ExternalSystemBundle.message((String)"error.cannot.parse.project", (Object[])new Object[]{externalSystemName}));
            }
        }
    }
}

