/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.ModuleImporter;
import com.android.tools.idea.gradle.project.ModuleToImport;
import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleModuleImporter
extends ModuleImporter {
    private final Logger LOG;
    @Nullable
    private final Project myProject;
    private final boolean myIsWizard;
    private final GradleProjectImporter myImporter;

    public GradleModuleImporter(@NotNull WizardContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleModuleImporter", "<init>"));
        }
        this(context.getProject(), true);
    }

    public GradleModuleImporter(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/GradleModuleImporter", "<init>"));
        }
        this(project, false);
    }

    private GradleModuleImporter(@Nullable Project project, boolean isWizard) {
        this.LOG = Logger.getInstance(this.getClass());
        this.myIsWizard = isWizard;
        this.myProject = project;
        this.myImporter = GradleProjectImporter.getInstance();
    }

    public static boolean isGradleProject(VirtualFile importSource) {
        VirtualFile target = ProjectImportUtil.findImportTarget(importSource);
        return target != null && "gradle".equals(target.getExtension());
    }

    @Override
    public boolean isStepVisible(ModuleWizardStep step) {
        return false;
    }

    @Override
    public List<? extends ModuleWizardStep> createWizardSteps() {
        return Collections.emptyList();
    }

    @Override
    public void importProjects(Map<String, VirtualFile> projects) {
        try {
            this.myImporter.importModules(projects, this.myProject, null);
        }
        catch (IOException e) {
            this.LOG.error((Throwable)e);
        }
        catch (ConfigurationException e) {
            this.LOG.error((Throwable)e);
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean canImport(VirtualFile importSource) {
        try {
            return GradleModuleImporter.isGradleProject(importSource) && (this.myIsWizard || this.findModules(importSource).size() == 1);
        }
        catch (IOException e) {
            this.LOG.error((Throwable)e);
            return false;
        }
    }

    @Override
    public Set<ModuleToImport> findModules(VirtualFile importSource) throws IOException {
        assert (this.myProject != null);
        return this.myImporter.getRelatedProjects(importSource, this.myProject);
    }
}

