/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.settings.LocationSettingType;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class ChooseGradleHomeDialog
extends DialogWrapper {
    @NotNull
    private final GradleInstallationManager myInstallationManager;
    private TextFieldWithBrowseButton myGradleHomePathField;
    private JBLabel myGradleHomeLabel;
    private JPanel myPanel;
    private JXLabel myDescriptionLabel;

    public ChooseGradleHomeDialog() {
        super(null);
        this.$$$setupUI$$$();
        this.myInstallationManager = (GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class);
        this.init();
        this.initValidation();
        this.setTitle("Import Gradle Project");
        FileChooserDescriptor fileChooserDescriptor = GradleUtil.getGradleHomeFileChooserDescriptor();
        this.myGradleHomePathField.addBrowseFolderListener("", GradleBundle.message((String)"gradle.settings.text.home.path", (Object[])new Object[0]), null, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT, false);
        this.myGradleHomeLabel.setLabelFor((Component)this.myGradleHomePathField.getTextField());
        this.getPeer().getWindow().pack();
        this.myGradleHomePathField.setText(GradleUtil.getLastUsedGradleHome());
        this.myGradleHomePathField.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ChooseGradleHomeDialog.this.initValidation();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ChooseGradleHomeDialog.this.initValidation();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    public void setDescription(@NotNull String descriptionLabel) {
        if (descriptionLabel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/project/ChooseGradleHomeDialog", "setDescription"));
        }
        this.myDescriptionLabel.setText(descriptionLabel);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        LocationSettingType locationSettingType = this.validateLocation();
        switch (locationSettingType) {
            case EXPLICIT_CORRECT: {
                return super.doValidate();
            }
        }
        return new ValidationInfo(locationSettingType.getDescription(GradleConstants.SYSTEM_ID), (JComponent)this.myGradleHomePathField.getTextField());
    }

    @NotNull
    private LocationSettingType validateLocation() {
        String gradleHome = this.getEnteredGradleHomePath();
        if (gradleHome.isEmpty()) {
            LocationSettingType locationSettingType = LocationSettingType.UNKNOWN;
            if (locationSettingType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ChooseGradleHomeDialog", "validateLocation"));
            }
            return locationSettingType;
        }
        File gradleHomePath = new File(FileUtil.toSystemDependentName((String)gradleHome));
        LocationSettingType locationSettingType = this.myInstallationManager.isGradleSdkHome(gradleHomePath) ? LocationSettingType.EXPLICIT_CORRECT : LocationSettingType.EXPLICIT_INCORRECT;
        if (locationSettingType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ChooseGradleHomeDialog", "validateLocation"));
        }
        return locationSettingType;
    }

    public void storeLastUsedGradleHome() {
        GradleUtil.storeLastUsedGradleHome((String)this.getEnteredGradleHomePath());
    }

    @NotNull
    public String getEnteredGradleHomePath() {
        String string = this.myGradleHomePathField.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ChooseGradleHomeDialog", "getEnteredGradleHomePath"));
        }
        return string;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JXLabel jXLabel;
        JBLabel jBLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myGradleHomePathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(500, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myGradleHomeLabel = jBLabel = new JBLabel();
        jBLabel.setText("Gradle home:");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myDescriptionLabel = jXLabel = new JXLabel();
        jXLabel.setLineWrap(true);
        jXLabel.setText("");
        jPanel.add((Component)jXLabel, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

