/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.annotations.Nullable;
import com.android.tools.idea.gradle.parser.GradleGroovyFile;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public abstract class ValueFactory<E> {
    @NotNull
    public List<E> getValues(@NotNull GrStatementOwner closure) {
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/parser/ValueFactory", "getValues"));
        }
        ArrayList result = Lists.newArrayList();
        for (PsiElement element : closure.getChildren()) {
            List<E> values = this.getValues(element);
            if (values == null || values.isEmpty()) continue;
            result.addAll(values);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/ValueFactory", "getValues"));
        }
        return arrayList;
    }

    public void setValues(@NotNull GrStatementOwner closure, @NotNull List<E> values) {
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/parser/ValueFactory", "setValues"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/parser/ValueFactory", "setValues"));
        }
        for (E value : values) {
            this.setValue(closure, value);
        }
        for (E existingValue : this.getValues(closure)) {
            if (values.contains(existingValue)) continue;
            this.removeValue(closure, existingValue);
        }
        GradleGroovyFile.reformatClosure(closure);
    }

    @NotNull
    public E parse(@NotNull String s, Project project) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/parser/ValueFactory", "parse"));
        }
        throw new UnsupportedOperationException("parse not implemented");
    }

    protected abstract void setValue(@NotNull GrStatementOwner var1, @NotNull E var2);

    @Nullable
    protected abstract List<E> getValues(@NotNull PsiElement var1);

    protected void removeValue(@NotNull GrStatementOwner closure, @NotNull E value) {
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/parser/ValueFactory", "removeValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/parser/ValueFactory", "removeValue"));
        }
        throw new UnsupportedOperationException("removeValue not implemented");
    }
}

